/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.synthetics.model.ArtifactConfigInput;
import software.amazon.awssdk.services.synthetics.model.BrowserConfig;
import software.amazon.awssdk.services.synthetics.model.BrowserConfigsCopier;
import software.amazon.awssdk.services.synthetics.model.CanaryCodeInput;
import software.amazon.awssdk.services.synthetics.model.CanaryRunConfigInput;
import software.amazon.awssdk.services.synthetics.model.ProvisionedResourceCleanupSetting;
import software.amazon.awssdk.services.synthetics.model.SyntheticsRequest;
import software.amazon.awssdk.services.synthetics.model.VisualReferenceInput;
import software.amazon.awssdk.services.synthetics.model.VisualReferencesCopier;
import software.amazon.awssdk.services.synthetics.model.VpcConfigInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCanaryDryRunRequest
extends SyntheticsRequest
implements ToCopyableBuilder<Builder, StartCanaryDryRunRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::name)).setter(StartCanaryDryRunRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<CanaryCodeInput> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Code").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::code)).setter(StartCanaryDryRunRequest.setter(Builder::code)).constructor(CanaryCodeInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeVersion").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::runtimeVersion)).setter(StartCanaryDryRunRequest.setter(Builder::runtimeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersion").build()}).build();
    private static final SdkField<CanaryRunConfigInput> RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunConfig").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::runConfig)).setter(StartCanaryDryRunRequest.setter(Builder::runConfig)).constructor(CanaryRunConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfig").build()}).build();
    private static final SdkField<VpcConfigInput> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::vpcConfig)).setter(StartCanaryDryRunRequest.setter(Builder::vpcConfig)).constructor(VpcConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::executionRoleArn)).setter(StartCanaryDryRunRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<Integer> SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuccessRetentionPeriodInDays").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::successRetentionPeriodInDays)).setter(StartCanaryDryRunRequest.setter(Builder::successRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRetentionPeriodInDays").build()}).build();
    private static final SdkField<Integer> FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailureRetentionPeriodInDays").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::failureRetentionPeriodInDays)).setter(StartCanaryDryRunRequest.setter(Builder::failureRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRetentionPeriodInDays").build()}).build();
    private static final SdkField<VisualReferenceInput> VISUAL_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualReference").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::visualReference)).setter(StartCanaryDryRunRequest.setter(Builder::visualReference)).constructor(VisualReferenceInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualReference").build()}).build();
    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactS3Location").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::artifactS3Location)).setter(StartCanaryDryRunRequest.setter(Builder::artifactS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build()}).build();
    private static final SdkField<ArtifactConfigInput> ARTIFACT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArtifactConfig").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::artifactConfig)).setter(StartCanaryDryRunRequest.setter(Builder::artifactConfig)).constructor(ArtifactConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactConfig").build()}).build();
    private static final SdkField<String> PROVISIONED_RESOURCE_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedResourceCleanup").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::provisionedResourceCleanupAsString)).setter(StartCanaryDryRunRequest.setter(Builder::provisionedResourceCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedResourceCleanup").build()}).build();
    private static final SdkField<List<BrowserConfig>> BROWSER_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BrowserConfigs").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::browserConfigs)).setter(StartCanaryDryRunRequest.setter(Builder::browserConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrowserConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BrowserConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VisualReferenceInput>> VISUAL_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VisualReferences").getter(StartCanaryDryRunRequest.getter(StartCanaryDryRunRequest::visualReferences)).setter(StartCanaryDryRunRequest.setter(Builder::visualReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VisualReferenceInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CODE_FIELD, RUNTIME_VERSION_FIELD, RUN_CONFIG_FIELD, VPC_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD, SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD, FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD, VISUAL_REFERENCE_FIELD, ARTIFACT_S3_LOCATION_FIELD, ARTIFACT_CONFIG_FIELD, PROVISIONED_RESOURCE_CLEANUP_FIELD, BROWSER_CONFIGS_FIELD, VISUAL_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCanaryDryRunRequest.memberNameToFieldInitializer();
    private final String name;
    private final CanaryCodeInput code;
    private final String runtimeVersion;
    private final CanaryRunConfigInput runConfig;
    private final VpcConfigInput vpcConfig;
    private final String executionRoleArn;
    private final Integer successRetentionPeriodInDays;
    private final Integer failureRetentionPeriodInDays;
    private final VisualReferenceInput visualReference;
    private final String artifactS3Location;
    private final ArtifactConfigInput artifactConfig;
    private final String provisionedResourceCleanup;
    private final List<BrowserConfig> browserConfigs;
    private final List<VisualReferenceInput> visualReferences;

    private StartCanaryDryRunRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.code = builder.code;
        this.runtimeVersion = builder.runtimeVersion;
        this.runConfig = builder.runConfig;
        this.vpcConfig = builder.vpcConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.successRetentionPeriodInDays = builder.successRetentionPeriodInDays;
        this.failureRetentionPeriodInDays = builder.failureRetentionPeriodInDays;
        this.visualReference = builder.visualReference;
        this.artifactS3Location = builder.artifactS3Location;
        this.artifactConfig = builder.artifactConfig;
        this.provisionedResourceCleanup = builder.provisionedResourceCleanup;
        this.browserConfigs = builder.browserConfigs;
        this.visualReferences = builder.visualReferences;
    }

    public final String name() {
        return this.name;
    }

    public final CanaryCodeInput code() {
        return this.code;
    }

    public final String runtimeVersion() {
        return this.runtimeVersion;
    }

    public final CanaryRunConfigInput runConfig() {
        return this.runConfig;
    }

    public final VpcConfigInput vpcConfig() {
        return this.vpcConfig;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final Integer successRetentionPeriodInDays() {
        return this.successRetentionPeriodInDays;
    }

    public final Integer failureRetentionPeriodInDays() {
        return this.failureRetentionPeriodInDays;
    }

    public final VisualReferenceInput visualReference() {
        return this.visualReference;
    }

    public final String artifactS3Location() {
        return this.artifactS3Location;
    }

    public final ArtifactConfigInput artifactConfig() {
        return this.artifactConfig;
    }

    public final ProvisionedResourceCleanupSetting provisionedResourceCleanup() {
        return ProvisionedResourceCleanupSetting.fromValue(this.provisionedResourceCleanup);
    }

    public final String provisionedResourceCleanupAsString() {
        return this.provisionedResourceCleanup;
    }

    public final boolean hasBrowserConfigs() {
        return this.browserConfigs != null && !(this.browserConfigs instanceof SdkAutoConstructList);
    }

    public final List<BrowserConfig> browserConfigs() {
        return this.browserConfigs;
    }

    public final boolean hasVisualReferences() {
        return this.visualReferences != null && !(this.visualReferences instanceof SdkAutoConstructList);
    }

    public final List<VisualReferenceInput> visualReferences() {
        return this.visualReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.runConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.successRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedResourceCleanupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBrowserConfigs() ? this.browserConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVisualReferences() ? this.visualReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCanaryDryRunRequest)) {
            return false;
        }
        StartCanaryDryRunRequest other = (StartCanaryDryRunRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.runtimeVersion(), other.runtimeVersion()) && Objects.equals(this.runConfig(), other.runConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.successRetentionPeriodInDays(), other.successRetentionPeriodInDays()) && Objects.equals(this.failureRetentionPeriodInDays(), other.failureRetentionPeriodInDays()) && Objects.equals(this.visualReference(), other.visualReference()) && Objects.equals(this.artifactS3Location(), other.artifactS3Location()) && Objects.equals(this.artifactConfig(), other.artifactConfig()) && Objects.equals(this.provisionedResourceCleanupAsString(), other.provisionedResourceCleanupAsString()) && this.hasBrowserConfigs() == other.hasBrowserConfigs() && Objects.equals(this.browserConfigs(), other.browserConfigs()) && this.hasVisualReferences() == other.hasVisualReferences() && Objects.equals(this.visualReferences(), other.visualReferences());
    }

    public final String toString() {
        return ToString.builder((String)"StartCanaryDryRunRequest").add("Name", (Object)this.name()).add("Code", (Object)this.code()).add("RuntimeVersion", (Object)this.runtimeVersion()).add("RunConfig", (Object)this.runConfig()).add("VpcConfig", (Object)this.vpcConfig()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("SuccessRetentionPeriodInDays", (Object)this.successRetentionPeriodInDays()).add("FailureRetentionPeriodInDays", (Object)this.failureRetentionPeriodInDays()).add("VisualReference", (Object)this.visualReference()).add("ArtifactS3Location", (Object)this.artifactS3Location()).add("ArtifactConfig", (Object)this.artifactConfig()).add("ProvisionedResourceCleanup", (Object)this.provisionedResourceCleanupAsString()).add("BrowserConfigs", this.hasBrowserConfigs() ? this.browserConfigs() : null).add("VisualReferences", this.hasVisualReferences() ? this.visualReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "RuntimeVersion": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersion()));
            }
            case "RunConfig": {
                return Optional.ofNullable(clazz.cast(this.runConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "SuccessRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.successRetentionPeriodInDays()));
            }
            case "FailureRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.failureRetentionPeriodInDays()));
            }
            case "VisualReference": {
                return Optional.ofNullable(clazz.cast(this.visualReference()));
            }
            case "ArtifactS3Location": {
                return Optional.ofNullable(clazz.cast(this.artifactS3Location()));
            }
            case "ArtifactConfig": {
                return Optional.ofNullable(clazz.cast(this.artifactConfig()));
            }
            case "ProvisionedResourceCleanup": {
                return Optional.ofNullable(clazz.cast(this.provisionedResourceCleanupAsString()));
            }
            case "BrowserConfigs": {
                return Optional.ofNullable(clazz.cast(this.browserConfigs()));
            }
            case "VisualReferences": {
                return Optional.ofNullable(clazz.cast(this.visualReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("RuntimeVersion", RUNTIME_VERSION_FIELD);
        map.put("RunConfig", RUN_CONFIG_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("SuccessRetentionPeriodInDays", SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("FailureRetentionPeriodInDays", FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("VisualReference", VISUAL_REFERENCE_FIELD);
        map.put("ArtifactS3Location", ARTIFACT_S3_LOCATION_FIELD);
        map.put("ArtifactConfig", ARTIFACT_CONFIG_FIELD);
        map.put("ProvisionedResourceCleanup", PROVISIONED_RESOURCE_CLEANUP_FIELD);
        map.put("BrowserConfigs", BROWSER_CONFIGS_FIELD);
        map.put("VisualReferences", VISUAL_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCanaryDryRunRequest, T> g) {
        return obj -> g.apply((StartCanaryDryRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SyntheticsRequest.BuilderImpl
    implements Builder {
        private String name;
        private CanaryCodeInput code;
        private String runtimeVersion;
        private CanaryRunConfigInput runConfig;
        private VpcConfigInput vpcConfig;
        private String executionRoleArn;
        private Integer successRetentionPeriodInDays;
        private Integer failureRetentionPeriodInDays;
        private VisualReferenceInput visualReference;
        private String artifactS3Location;
        private ArtifactConfigInput artifactConfig;
        private String provisionedResourceCleanup;
        private List<BrowserConfig> browserConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<VisualReferenceInput> visualReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCanaryDryRunRequest model) {
            super(model);
            this.name(model.name);
            this.code(model.code);
            this.runtimeVersion(model.runtimeVersion);
            this.runConfig(model.runConfig);
            this.vpcConfig(model.vpcConfig);
            this.executionRoleArn(model.executionRoleArn);
            this.successRetentionPeriodInDays(model.successRetentionPeriodInDays);
            this.failureRetentionPeriodInDays(model.failureRetentionPeriodInDays);
            this.visualReference(model.visualReference);
            this.artifactS3Location(model.artifactS3Location);
            this.artifactConfig(model.artifactConfig);
            this.provisionedResourceCleanup(model.provisionedResourceCleanup);
            this.browserConfigs(model.browserConfigs);
            this.visualReferences(model.visualReferences);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CanaryCodeInput.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(CanaryCodeInput.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(CanaryCodeInput code) {
            this.code = code;
            return this;
        }

        public final String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        public final CanaryRunConfigInput.Builder getRunConfig() {
            return this.runConfig != null ? this.runConfig.toBuilder() : null;
        }

        public final void setRunConfig(CanaryRunConfigInput.BuilderImpl runConfig) {
            this.runConfig = runConfig != null ? runConfig.build() : null;
        }

        @Override
        public final Builder runConfig(CanaryRunConfigInput runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        public final VpcConfigInput.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfigInput.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigInput vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Integer getSuccessRetentionPeriodInDays() {
            return this.successRetentionPeriodInDays;
        }

        public final void setSuccessRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
        }

        @Override
        public final Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
            return this;
        }

        public final Integer getFailureRetentionPeriodInDays() {
            return this.failureRetentionPeriodInDays;
        }

        public final void setFailureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
        }

        @Override
        public final Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
            return this;
        }

        public final VisualReferenceInput.Builder getVisualReference() {
            return this.visualReference != null ? this.visualReference.toBuilder() : null;
        }

        public final void setVisualReference(VisualReferenceInput.BuilderImpl visualReference) {
            this.visualReference = visualReference != null ? visualReference.build() : null;
        }

        @Override
        public final Builder visualReference(VisualReferenceInput visualReference) {
            this.visualReference = visualReference;
            return this;
        }

        public final String getArtifactS3Location() {
            return this.artifactS3Location;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        @Override
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        public final ArtifactConfigInput.Builder getArtifactConfig() {
            return this.artifactConfig != null ? this.artifactConfig.toBuilder() : null;
        }

        public final void setArtifactConfig(ArtifactConfigInput.BuilderImpl artifactConfig) {
            this.artifactConfig = artifactConfig != null ? artifactConfig.build() : null;
        }

        @Override
        public final Builder artifactConfig(ArtifactConfigInput artifactConfig) {
            this.artifactConfig = artifactConfig;
            return this;
        }

        public final String getProvisionedResourceCleanup() {
            return this.provisionedResourceCleanup;
        }

        public final void setProvisionedResourceCleanup(String provisionedResourceCleanup) {
            this.provisionedResourceCleanup = provisionedResourceCleanup;
        }

        @Override
        public final Builder provisionedResourceCleanup(String provisionedResourceCleanup) {
            this.provisionedResourceCleanup = provisionedResourceCleanup;
            return this;
        }

        @Override
        public final Builder provisionedResourceCleanup(ProvisionedResourceCleanupSetting provisionedResourceCleanup) {
            this.provisionedResourceCleanup(provisionedResourceCleanup == null ? null : provisionedResourceCleanup.toString());
            return this;
        }

        public final List<BrowserConfig.Builder> getBrowserConfigs() {
            List<BrowserConfig.Builder> result = BrowserConfigsCopier.copyToBuilder(this.browserConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrowserConfigs(Collection<BrowserConfig.BuilderImpl> browserConfigs) {
            this.browserConfigs = BrowserConfigsCopier.copyFromBuilder(browserConfigs);
        }

        @Override
        public final Builder browserConfigs(Collection<BrowserConfig> browserConfigs) {
            this.browserConfigs = BrowserConfigsCopier.copy(browserConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserConfigs(BrowserConfig ... browserConfigs) {
            this.browserConfigs(Arrays.asList(browserConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserConfigs(Consumer<BrowserConfig.Builder> ... browserConfigs) {
            this.browserConfigs(Stream.of(browserConfigs).map(c -> (BrowserConfig)((BrowserConfig.Builder)BrowserConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VisualReferenceInput.Builder> getVisualReferences() {
            List<VisualReferenceInput.Builder> result = VisualReferencesCopier.copyToBuilder(this.visualReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVisualReferences(Collection<VisualReferenceInput.BuilderImpl> visualReferences) {
            this.visualReferences = VisualReferencesCopier.copyFromBuilder(visualReferences);
        }

        @Override
        public final Builder visualReferences(Collection<VisualReferenceInput> visualReferences) {
            this.visualReferences = VisualReferencesCopier.copy(visualReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visualReferences(VisualReferenceInput ... visualReferences) {
            this.visualReferences(Arrays.asList(visualReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visualReferences(Consumer<VisualReferenceInput.Builder> ... visualReferences) {
            this.visualReferences(Stream.of(visualReferences).map(c -> (VisualReferenceInput)((VisualReferenceInput.Builder)VisualReferenceInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCanaryDryRunRequest build() {
            return new StartCanaryDryRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SyntheticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCanaryDryRunRequest> {
        public Builder name(String var1);

        public Builder code(CanaryCodeInput var1);

        default public Builder code(Consumer<CanaryCodeInput.Builder> code) {
            return this.code((CanaryCodeInput)((CanaryCodeInput.Builder)CanaryCodeInput.builder().applyMutation(code)).build());
        }

        public Builder runtimeVersion(String var1);

        public Builder runConfig(CanaryRunConfigInput var1);

        default public Builder runConfig(Consumer<CanaryRunConfigInput.Builder> runConfig) {
            return this.runConfig((CanaryRunConfigInput)((CanaryRunConfigInput.Builder)CanaryRunConfigInput.builder().applyMutation(runConfig)).build());
        }

        public Builder vpcConfig(VpcConfigInput var1);

        default public Builder vpcConfig(Consumer<VpcConfigInput.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfigInput)((VpcConfigInput.Builder)VpcConfigInput.builder().applyMutation(vpcConfig)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder successRetentionPeriodInDays(Integer var1);

        public Builder failureRetentionPeriodInDays(Integer var1);

        public Builder visualReference(VisualReferenceInput var1);

        default public Builder visualReference(Consumer<VisualReferenceInput.Builder> visualReference) {
            return this.visualReference((VisualReferenceInput)((VisualReferenceInput.Builder)VisualReferenceInput.builder().applyMutation(visualReference)).build());
        }

        public Builder artifactS3Location(String var1);

        public Builder artifactConfig(ArtifactConfigInput var1);

        default public Builder artifactConfig(Consumer<ArtifactConfigInput.Builder> artifactConfig) {
            return this.artifactConfig((ArtifactConfigInput)((ArtifactConfigInput.Builder)ArtifactConfigInput.builder().applyMutation(artifactConfig)).build());
        }

        public Builder provisionedResourceCleanup(String var1);

        public Builder provisionedResourceCleanup(ProvisionedResourceCleanupSetting var1);

        public Builder browserConfigs(Collection<BrowserConfig> var1);

        public Builder browserConfigs(BrowserConfig ... var1);

        public Builder browserConfigs(Consumer<BrowserConfig.Builder> ... var1);

        public Builder visualReferences(Collection<VisualReferenceInput> var1);

        public Builder visualReferences(VisualReferenceInput ... var1);

        public Builder visualReferences(Consumer<VisualReferenceInput.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

