/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.ComputeMode;
import software.amazon.awssdk.services.timestreamquery.model.ProvisionedCapacityResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryComputeResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryComputeResponse> {
    private static final SdkField<String> COMPUTE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeMode").getter(QueryComputeResponse.getter(QueryComputeResponse::computeModeAsString)).setter(QueryComputeResponse.setter(Builder::computeMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeMode").build()}).build();
    private static final SdkField<ProvisionedCapacityResponse> PROVISIONED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedCapacity").getter(QueryComputeResponse.getter(QueryComputeResponse::provisionedCapacity)).setter(QueryComputeResponse.setter(Builder::provisionedCapacity)).constructor(ProvisionedCapacityResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_MODE_FIELD, PROVISIONED_CAPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryComputeResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String computeMode;
    private final ProvisionedCapacityResponse provisionedCapacity;

    private QueryComputeResponse(BuilderImpl builder) {
        this.computeMode = builder.computeMode;
        this.provisionedCapacity = builder.provisionedCapacity;
    }

    public final ComputeMode computeMode() {
        return ComputeMode.fromValue(this.computeMode);
    }

    public final String computeModeAsString() {
        return this.computeMode;
    }

    public final ProvisionedCapacityResponse provisionedCapacity() {
        return this.provisionedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedCapacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryComputeResponse)) {
            return false;
        }
        QueryComputeResponse other = (QueryComputeResponse)obj;
        return Objects.equals(this.computeModeAsString(), other.computeModeAsString()) && Objects.equals(this.provisionedCapacity(), other.provisionedCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"QueryComputeResponse").add("ComputeMode", (Object)this.computeModeAsString()).add("ProvisionedCapacity", (Object)this.provisionedCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputeMode": {
                return Optional.ofNullable(clazz.cast(this.computeModeAsString()));
            }
            case "ProvisionedCapacity": {
                return Optional.ofNullable(clazz.cast(this.provisionedCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ComputeMode", COMPUTE_MODE_FIELD);
        map.put("ProvisionedCapacity", PROVISIONED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryComputeResponse, T> g) {
        return obj -> g.apply((QueryComputeResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String computeMode;
        private ProvisionedCapacityResponse provisionedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryComputeResponse model) {
            this.computeMode(model.computeMode);
            this.provisionedCapacity(model.provisionedCapacity);
        }

        public final String getComputeMode() {
            return this.computeMode;
        }

        public final void setComputeMode(String computeMode) {
            this.computeMode = computeMode;
        }

        @Override
        public final Builder computeMode(String computeMode) {
            this.computeMode = computeMode;
            return this;
        }

        @Override
        public final Builder computeMode(ComputeMode computeMode) {
            this.computeMode(computeMode == null ? null : computeMode.toString());
            return this;
        }

        public final ProvisionedCapacityResponse.Builder getProvisionedCapacity() {
            return this.provisionedCapacity != null ? this.provisionedCapacity.toBuilder() : null;
        }

        public final void setProvisionedCapacity(ProvisionedCapacityResponse.BuilderImpl provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity != null ? provisionedCapacity.build() : null;
        }

        @Override
        public final Builder provisionedCapacity(ProvisionedCapacityResponse provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity;
            return this;
        }

        public QueryComputeResponse build() {
            return new QueryComputeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryComputeResponse> {
        public Builder computeMode(String var1);

        public Builder computeMode(ComputeMode var1);

        public Builder provisionedCapacity(ProvisionedCapacityResponse var1);

        default public Builder provisionedCapacity(Consumer<ProvisionedCapacityResponse.Builder> provisionedCapacity) {
            return this.provisionedCapacity((ProvisionedCapacityResponse)((ProvisionedCapacityResponse.Builder)ProvisionedCapacityResponse.builder().applyMutation(provisionedCapacity)).build());
        }
    }
}

