/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides error information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorInfo implements SdkPojo, Serializable, ToCopyableBuilder<ErrorInfo.Builder, ErrorInfo> {
    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cause")
            .getter(getter(ErrorInfo::cause)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("details")
            .getter(getter(ErrorInfo::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAUSE_FIELD, DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String causeValue;

    private final String details;

    private ErrorInfo(BuilderImpl builder) {
        this.causeValue = builder.causeValue;
        this.details = builder.details;
    }

    /**
     * <p>
     * Error cause.
     * </p>
     * 
     * @return Error cause.
     */
    public final String cause() {
        return causeValue;
    }

    /**
     * <p>
     * Error details.
     * </p>
     * 
     * @return Error details.
     */
    public final String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cause());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorInfo)) {
            return false;
        }
        ErrorInfo other = (ErrorInfo) obj;
        return Objects.equals(cause(), other.cause()) && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorInfo").add("Cause", cause()).add("Details", details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cause":
            return Optional.ofNullable(clazz.cast(cause()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorInfo, T> g) {
        return obj -> g.apply((ErrorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorInfo> {
        /**
         * <p>
         * Error cause.
         * </p>
         * 
         * @param causeValue
         *        Error cause.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * Error details.
         * </p>
         * 
         * @param details
         *        Error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    static final class BuilderImpl implements Builder {
        private String causeValue;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorInfo model) {
            cause(model.causeValue);
            details(model.details);
        }

        public final String getCause() {
            return causeValue;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        public final String getDetails() {
            return details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        @Override
        public ErrorInfo build() {
            return new ErrorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
