/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstantiateSolNetworkInstanceRequest extends TnbRequest implements
        ToCopyableBuilder<InstantiateSolNetworkInstanceRequest.Builder, InstantiateSolNetworkInstanceRequest> {
    private static final SdkField<Document> ADDITIONAL_PARAMS_FOR_NS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("additionalParamsForNs")
            .getter(getter(InstantiateSolNetworkInstanceRequest::additionalParamsForNs))
            .setter(setter(Builder::additionalParamsForNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalParamsForNs").build())
            .build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dryRun").getter(getter(InstantiateSolNetworkInstanceRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dry_run").build()).build();

    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsInstanceId").getter(getter(InstantiateSolNetworkInstanceRequest::nsInstanceId))
            .setter(setter(Builder::nsInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nsInstanceId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(InstantiateSolNetworkInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_PARAMS_FOR_NS_FIELD, DRY_RUN_FIELD, NS_INSTANCE_ID_FIELD, TAGS_FIELD));

    private final Document additionalParamsForNs;

    private final Boolean dryRun;

    private final String nsInstanceId;

    private final Map<String, String> tags;

    private InstantiateSolNetworkInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.additionalParamsForNs = builder.additionalParamsForNs;
        this.dryRun = builder.dryRun;
        this.nsInstanceId = builder.nsInstanceId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Provides values for the configurable properties.
     * </p>
     * 
     * @return Provides values for the configurable properties.
     */
    public final Document additionalParamsForNs() {
        return additionalParamsForNs;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * ID of the network instance.
     * </p>
     * 
     * @return ID of the network instance.
     */
    public final String nsInstanceId() {
        return nsInstanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. When you use this API, the tags are transferred to the network operation that is created. Use tags to
     * search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. When you use this API, the tags are transferred to the network operation that is created.
     *         Use tags to search and filter your resources or track your Amazon Web Services costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(additionalParamsForNs());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstantiateSolNetworkInstanceRequest)) {
            return false;
        }
        InstantiateSolNetworkInstanceRequest other = (InstantiateSolNetworkInstanceRequest) obj;
        return Objects.equals(additionalParamsForNs(), other.additionalParamsForNs()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(nsInstanceId(), other.nsInstanceId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstantiateSolNetworkInstanceRequest").add("AdditionalParamsForNs", additionalParamsForNs())
                .add("DryRun", dryRun()).add("NsInstanceId", nsInstanceId())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalParamsForNs":
            return Optional.ofNullable(clazz.cast(additionalParamsForNs()));
        case "dryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "nsInstanceId":
            return Optional.ofNullable(clazz.cast(nsInstanceId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstantiateSolNetworkInstanceRequest, T> g) {
        return obj -> g.apply((InstantiateSolNetworkInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TnbRequest.Builder, SdkPojo, CopyableBuilder<Builder, InstantiateSolNetworkInstanceRequest> {
        /**
         * <p>
         * Provides values for the configurable properties.
         * </p>
         * 
         * @param additionalParamsForNs
         *        Provides values for the configurable properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalParamsForNs(Document additionalParamsForNs);

        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * ID of the network instance.
         * </p>
         * 
         * @param nsInstanceId
         *        ID of the network instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsInstanceId(String nsInstanceId);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. When you use this API, the tags are transferred to the network operation that is created. Use
         * tags to search and filter your resources or track your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. When you use this API, the tags are transferred to the network operation that is
         *        created. Use tags to search and filter your resources or track your Amazon Web Services costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TnbRequest.BuilderImpl implements Builder {
        private Document additionalParamsForNs;

        private Boolean dryRun;

        private String nsInstanceId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstantiateSolNetworkInstanceRequest model) {
            super(model);
            additionalParamsForNs(model.additionalParamsForNs);
            dryRun(model.dryRun);
            nsInstanceId(model.nsInstanceId);
            tags(model.tags);
        }

        public final Document getAdditionalParamsForNs() {
            return additionalParamsForNs;
        }

        public final void setAdditionalParamsForNs(Document additionalParamsForNs) {
            this.additionalParamsForNs = additionalParamsForNs;
        }

        @Override
        public final Builder additionalParamsForNs(Document additionalParamsForNs) {
            this.additionalParamsForNs = additionalParamsForNs;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNsInstanceId() {
            return nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InstantiateSolNetworkInstanceRequest build() {
            return new InstantiateSolNetworkInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
