/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationMetadata;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationTaskDetails;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationTasksListCopier;
import software.amazon.awssdk.services.tnb.model.LcmOperationType;
import software.amazon.awssdk.services.tnb.model.NsLcmOperationState;
import software.amazon.awssdk.services.tnb.model.ProblemDetails;
import software.amazon.awssdk.services.tnb.model.TagMapCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSolNetworkOperationResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, GetSolNetworkOperationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSolNetworkOperationResponse.getter(GetSolNetworkOperationResponse::arn)).setter(GetSolNetworkOperationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<ProblemDetails> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(GetSolNetworkOperationResponse.getter(GetSolNetworkOperationResponse::error)).setter(GetSolNetworkOperationResponse.setter(Builder::error)).constructor(ProblemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetSolNetworkOperationResponse.getter(GetSolNetworkOperationResponse::id)).setter(GetSolNetworkOperationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> LCM_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lcmOperationType").getter(GetSolNetworkOperationResponse.getter(GetSolNetworkOperationResponse::lcmOperationTypeAsString)).setter(GetSolNetworkOperationResponse.setter(Builder::lcmOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lcmOperationType").build()}).build();
    private static final SdkField<GetSolNetworkOperationMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(GetSolNetworkOperationResponse.getter(GetSolNetworkOperationResponse::metadata)).setter(GetSolNetworkOperationResponse.setter(Builder::metadata)).constructor(GetSolNetworkOperationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsInstanceId").getter(GetSolNetworkOperationResponse.getter(GetSolNetworkOperationResponse::nsInstanceId)).setter(GetSolNetworkOperationResponse.setter(Builder::nsInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceId").build()}).build();
    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationState").getter(GetSolNetworkOperationResponse.getter(GetSolNetworkOperationResponse::operationStateAsString)).setter(GetSolNetworkOperationResponse.setter(Builder::operationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetSolNetworkOperationResponse.getter(GetSolNetworkOperationResponse::tags)).setter(GetSolNetworkOperationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<GetSolNetworkOperationTaskDetails>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tasks").getter(GetSolNetworkOperationResponse.getter(GetSolNetworkOperationResponse::tasks)).setter(GetSolNetworkOperationResponse.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetSolNetworkOperationTaskDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ERROR_FIELD, ID_FIELD, LCM_OPERATION_TYPE_FIELD, METADATA_FIELD, NS_INSTANCE_ID_FIELD, OPERATION_STATE_FIELD, TAGS_FIELD, TASKS_FIELD));
    private final String arn;
    private final ProblemDetails error;
    private final String id;
    private final String lcmOperationType;
    private final GetSolNetworkOperationMetadata metadata;
    private final String nsInstanceId;
    private final String operationState;
    private final Map<String, String> tags;
    private final List<GetSolNetworkOperationTaskDetails> tasks;

    private GetSolNetworkOperationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.error = builder.error;
        this.id = builder.id;
        this.lcmOperationType = builder.lcmOperationType;
        this.metadata = builder.metadata;
        this.nsInstanceId = builder.nsInstanceId;
        this.operationState = builder.operationState;
        this.tags = builder.tags;
        this.tasks = builder.tasks;
    }

    public final String arn() {
        return this.arn;
    }

    public final ProblemDetails error() {
        return this.error;
    }

    public final String id() {
        return this.id;
    }

    public final LcmOperationType lcmOperationType() {
        return LcmOperationType.fromValue(this.lcmOperationType);
    }

    public final String lcmOperationTypeAsString() {
        return this.lcmOperationType;
    }

    public final GetSolNetworkOperationMetadata metadata() {
        return this.metadata;
    }

    public final String nsInstanceId() {
        return this.nsInstanceId;
    }

    public final NsLcmOperationState operationState() {
        return NsLcmOperationState.fromValue(this.operationState);
    }

    public final String operationStateAsString() {
        return this.operationState;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<GetSolNetworkOperationTaskDetails> tasks() {
        return this.tasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lcmOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkOperationResponse)) {
            return false;
        }
        GetSolNetworkOperationResponse other = (GetSolNetworkOperationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lcmOperationTypeAsString(), other.lcmOperationTypeAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.nsInstanceId(), other.nsInstanceId()) && Objects.equals(this.operationStateAsString(), other.operationStateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks());
    }

    public final String toString() {
        return ToString.builder((String)"GetSolNetworkOperationResponse").add("Arn", (Object)this.arn()).add("Error", (Object)this.error()).add("Id", (Object)this.id()).add("LcmOperationType", (Object)this.lcmOperationTypeAsString()).add("Metadata", (Object)this.metadata()).add("NsInstanceId", (Object)this.nsInstanceId()).add("OperationState", (Object)this.operationStateAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("Tasks", this.hasTasks() ? this.tasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lcmOperationType": {
                return Optional.ofNullable(clazz.cast(this.lcmOperationTypeAsString()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "nsInstanceId": {
                return Optional.ofNullable(clazz.cast(this.nsInstanceId()));
            }
            case "operationState": {
                return Optional.ofNullable(clazz.cast(this.operationStateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkOperationResponse, T> g) {
        return obj -> g.apply((GetSolNetworkOperationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String arn;
        private ProblemDetails error;
        private String id;
        private String lcmOperationType;
        private GetSolNetworkOperationMetadata metadata;
        private String nsInstanceId;
        private String operationState;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<GetSolNetworkOperationTaskDetails> tasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkOperationResponse model) {
            super(model);
            this.arn(model.arn);
            this.error(model.error);
            this.id(model.id);
            this.lcmOperationType(model.lcmOperationType);
            this.metadata(model.metadata);
            this.nsInstanceId(model.nsInstanceId);
            this.operationState(model.operationState);
            this.tags(model.tags);
            this.tasks(model.tasks);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ProblemDetails.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ProblemDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ProblemDetails error) {
            this.error = error;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLcmOperationType() {
            return this.lcmOperationType;
        }

        public final void setLcmOperationType(String lcmOperationType) {
            this.lcmOperationType = lcmOperationType;
        }

        @Override
        public final Builder lcmOperationType(String lcmOperationType) {
            this.lcmOperationType = lcmOperationType;
            return this;
        }

        @Override
        public final Builder lcmOperationType(LcmOperationType lcmOperationType) {
            this.lcmOperationType(lcmOperationType == null ? null : lcmOperationType.toString());
            return this;
        }

        public final GetSolNetworkOperationMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolNetworkOperationMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolNetworkOperationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceId() {
            return this.nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final String getOperationState() {
            return this.operationState;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        @Override
        public final Builder operationState(NsLcmOperationState operationState) {
            this.operationState(operationState == null ? null : operationState.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<GetSolNetworkOperationTaskDetails.Builder> getTasks() {
            List<GetSolNetworkOperationTaskDetails.Builder> result = GetSolNetworkOperationTasksListCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<GetSolNetworkOperationTaskDetails.BuilderImpl> tasks) {
            this.tasks = GetSolNetworkOperationTasksListCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<GetSolNetworkOperationTaskDetails> tasks) {
            this.tasks = GetSolNetworkOperationTasksListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(GetSolNetworkOperationTaskDetails ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<GetSolNetworkOperationTaskDetails.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (GetSolNetworkOperationTaskDetails)((GetSolNetworkOperationTaskDetails.Builder)GetSolNetworkOperationTaskDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSolNetworkOperationResponse build() {
            return new GetSolNetworkOperationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSolNetworkOperationResponse> {
        public Builder arn(String var1);

        public Builder error(ProblemDetails var1);

        default public Builder error(Consumer<ProblemDetails.Builder> error) {
            return this.error((ProblemDetails)((ProblemDetails.Builder)ProblemDetails.builder().applyMutation(error)).build());
        }

        public Builder id(String var1);

        public Builder lcmOperationType(String var1);

        public Builder lcmOperationType(LcmOperationType var1);

        public Builder metadata(GetSolNetworkOperationMetadata var1);

        default public Builder metadata(Consumer<GetSolNetworkOperationMetadata.Builder> metadata) {
            return this.metadata((GetSolNetworkOperationMetadata)((GetSolNetworkOperationMetadata.Builder)GetSolNetworkOperationMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder nsInstanceId(String var1);

        public Builder operationState(String var1);

        public Builder operationState(NsLcmOperationState var1);

        public Builder tags(Map<String, String> var1);

        public Builder tasks(Collection<GetSolNetworkOperationTaskDetails> var1);

        public Builder tasks(GetSolNetworkOperationTaskDetails ... var1);

        public Builder tasks(Consumer<GetSolNetworkOperationTaskDetails.Builder> ... var1);
    }
}

