/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RedactionOutput {
    REDACTED("redacted"),
    REDACTED_AND_UNREDACTED("redacted_and_unredacted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RedactionOutput> VALUE_MAP;
    private final String value;

    private RedactionOutput(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RedactionOutput fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RedactionOutput> knownValues() {
        EnumSet<RedactionOutput> knownValues = EnumSet.allOf(RedactionOutput.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RedactionOutput.class, RedactionOutput::toString);
    }
}

