/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListMedicalScribeJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalScribeJobsResponse;

public class ListMedicalScribeJobsIterable
implements SdkIterable<ListMedicalScribeJobsResponse> {
    private final TranscribeClient client;
    private final ListMedicalScribeJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMedicalScribeJobsIterable(TranscribeClient client, ListMedicalScribeJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMedicalScribeJobsResponseFetcher();
    }

    public Iterator<ListMedicalScribeJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMedicalScribeJobsResponseFetcher
    implements SyncPageFetcher<ListMedicalScribeJobsResponse> {
        private ListMedicalScribeJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMedicalScribeJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMedicalScribeJobsResponse nextPage(ListMedicalScribeJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMedicalScribeJobsIterable.this.client.listMedicalScribeJobs(ListMedicalScribeJobsIterable.this.firstRequest);
            }
            return ListMedicalScribeJobsIterable.this.client.listMedicalScribeJobs((ListMedicalScribeJobsRequest)((Object)ListMedicalScribeJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

