/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.InputType;
import software.amazon.awssdk.services.transcribe.model.Rule;
import software.amazon.awssdk.services.transcribe.model.RuleListCopier;
import software.amazon.awssdk.services.transcribe.model.Tag;
import software.amazon.awssdk.services.transcribe.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CategoryProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CategoryProperties> {
    private static final SdkField<String> CATEGORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CategoryName").getter(CategoryProperties.getter(CategoryProperties::categoryName)).setter(CategoryProperties.setter(Builder::categoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryName").build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(CategoryProperties.getter(CategoryProperties::rules)).setter(CategoryProperties.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CategoryProperties.getter(CategoryProperties::createTime)).setter(CategoryProperties.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(CategoryProperties.getter(CategoryProperties::lastUpdateTime)).setter(CategoryProperties.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CategoryProperties.getter(CategoryProperties::tags)).setter(CategoryProperties.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputType").getter(CategoryProperties.getter(CategoryProperties::inputTypeAsString)).setter(CategoryProperties.setter(Builder::inputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_NAME_FIELD, RULES_FIELD, CREATE_TIME_FIELD, LAST_UPDATE_TIME_FIELD, TAGS_FIELD, INPUT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CategoryProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String categoryName;
    private final List<Rule> rules;
    private final Instant createTime;
    private final Instant lastUpdateTime;
    private final List<Tag> tags;
    private final String inputType;

    private CategoryProperties(BuilderImpl builder) {
        this.categoryName = builder.categoryName;
        this.rules = builder.rules;
        this.createTime = builder.createTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.tags = builder.tags;
        this.inputType = builder.inputType;
    }

    public final String categoryName() {
        return this.categoryName;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final InputType inputType() {
        return InputType.fromValue(this.inputType);
    }

    public final String inputTypeAsString() {
        return this.inputType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryProperties)) {
            return false;
        }
        CategoryProperties other = (CategoryProperties)obj;
        return Objects.equals(this.categoryName(), other.categoryName()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.inputTypeAsString(), other.inputTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CategoryProperties").add("CategoryName", (Object)this.categoryName()).add("Rules", this.hasRules() ? this.rules() : null).add("CreateTime", (Object)this.createTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Tags", this.hasTags() ? this.tags() : null).add("InputType", (Object)this.inputTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategoryName": {
                return Optional.ofNullable(clazz.cast(this.categoryName()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "InputType": {
                return Optional.ofNullable(clazz.cast(this.inputTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CategoryName", CATEGORY_NAME_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("InputType", INPUT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CategoryProperties, T> g) {
        return obj -> g.apply((CategoryProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String categoryName;
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private Instant createTime;
        private Instant lastUpdateTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String inputType;

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryProperties model) {
            this.categoryName(model.categoryName);
            this.rules(model.rules);
            this.createTime(model.createTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.tags(model.tags);
            this.inputType(model.inputType);
        }

        public final String getCategoryName() {
            return this.categoryName;
        }

        public final void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        @Override
        public final Builder categoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInputType() {
            return this.inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(InputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        public CategoryProperties build() {
            return new CategoryProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CategoryProperties> {
        public Builder categoryName(String var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder createTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder inputType(String var1);

        public Builder inputType(InputType var1);
    }
}

