/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.PiiEntityType;
import software.amazon.awssdk.services.transcribe.model.PiiEntityTypesCopier;
import software.amazon.awssdk.services.transcribe.model.RedactionOutput;
import software.amazon.awssdk.services.transcribe.model.RedactionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentRedaction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentRedaction> {
    private static final SdkField<String> REDACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedactionType").getter(ContentRedaction.getter(ContentRedaction::redactionTypeAsString)).setter(ContentRedaction.setter(Builder::redactionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactionType").build()}).build();
    private static final SdkField<String> REDACTION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedactionOutput").getter(ContentRedaction.getter(ContentRedaction::redactionOutputAsString)).setter(ContentRedaction.setter(Builder::redactionOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactionOutput").build()}).build();
    private static final SdkField<List<String>> PII_ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PiiEntityTypes").getter(ContentRedaction.getter(ContentRedaction::piiEntityTypesAsStrings)).setter(ContentRedaction.setter(Builder::piiEntityTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDACTION_TYPE_FIELD, REDACTION_OUTPUT_FIELD, PII_ENTITY_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContentRedaction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String redactionType;
    private final String redactionOutput;
    private final List<String> piiEntityTypes;

    private ContentRedaction(BuilderImpl builder) {
        this.redactionType = builder.redactionType;
        this.redactionOutput = builder.redactionOutput;
        this.piiEntityTypes = builder.piiEntityTypes;
    }

    public final RedactionType redactionType() {
        return RedactionType.fromValue(this.redactionType);
    }

    public final String redactionTypeAsString() {
        return this.redactionType;
    }

    public final RedactionOutput redactionOutput() {
        return RedactionOutput.fromValue(this.redactionOutput);
    }

    public final String redactionOutputAsString() {
        return this.redactionOutput;
    }

    public final List<PiiEntityType> piiEntityTypes() {
        return PiiEntityTypesCopier.copyStringToEnum(this.piiEntityTypes);
    }

    public final boolean hasPiiEntityTypes() {
        return this.piiEntityTypes != null && !(this.piiEntityTypes instanceof SdkAutoConstructList);
    }

    public final List<String> piiEntityTypesAsStrings() {
        return this.piiEntityTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.redactionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.redactionOutputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPiiEntityTypes() ? this.piiEntityTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentRedaction)) {
            return false;
        }
        ContentRedaction other = (ContentRedaction)obj;
        return Objects.equals(this.redactionTypeAsString(), other.redactionTypeAsString()) && Objects.equals(this.redactionOutputAsString(), other.redactionOutputAsString()) && this.hasPiiEntityTypes() == other.hasPiiEntityTypes() && Objects.equals(this.piiEntityTypesAsStrings(), other.piiEntityTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ContentRedaction").add("RedactionType", (Object)this.redactionTypeAsString()).add("RedactionOutput", (Object)this.redactionOutputAsString()).add("PiiEntityTypes", this.hasPiiEntityTypes() ? this.piiEntityTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RedactionType": {
                return Optional.ofNullable(clazz.cast(this.redactionTypeAsString()));
            }
            case "RedactionOutput": {
                return Optional.ofNullable(clazz.cast(this.redactionOutputAsString()));
            }
            case "PiiEntityTypes": {
                return Optional.ofNullable(clazz.cast(this.piiEntityTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RedactionType", REDACTION_TYPE_FIELD);
        map.put("RedactionOutput", REDACTION_OUTPUT_FIELD);
        map.put("PiiEntityTypes", PII_ENTITY_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentRedaction, T> g) {
        return obj -> g.apply((ContentRedaction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String redactionType;
        private String redactionOutput;
        private List<String> piiEntityTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentRedaction model) {
            this.redactionType(model.redactionType);
            this.redactionOutput(model.redactionOutput);
            this.piiEntityTypesWithStrings(model.piiEntityTypes);
        }

        public final String getRedactionType() {
            return this.redactionType;
        }

        public final void setRedactionType(String redactionType) {
            this.redactionType = redactionType;
        }

        @Override
        public final Builder redactionType(String redactionType) {
            this.redactionType = redactionType;
            return this;
        }

        @Override
        public final Builder redactionType(RedactionType redactionType) {
            this.redactionType(redactionType == null ? null : redactionType.toString());
            return this;
        }

        public final String getRedactionOutput() {
            return this.redactionOutput;
        }

        public final void setRedactionOutput(String redactionOutput) {
            this.redactionOutput = redactionOutput;
        }

        @Override
        public final Builder redactionOutput(String redactionOutput) {
            this.redactionOutput = redactionOutput;
            return this;
        }

        @Override
        public final Builder redactionOutput(RedactionOutput redactionOutput) {
            this.redactionOutput(redactionOutput == null ? null : redactionOutput.toString());
            return this;
        }

        public final Collection<String> getPiiEntityTypes() {
            if (this.piiEntityTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.piiEntityTypes;
        }

        public final void setPiiEntityTypes(Collection<String> piiEntityTypes) {
            this.piiEntityTypes = PiiEntityTypesCopier.copy(piiEntityTypes);
        }

        @Override
        public final Builder piiEntityTypesWithStrings(Collection<String> piiEntityTypes) {
            this.piiEntityTypes = PiiEntityTypesCopier.copy(piiEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntityTypesWithStrings(String ... piiEntityTypes) {
            this.piiEntityTypesWithStrings(Arrays.asList(piiEntityTypes));
            return this;
        }

        @Override
        public final Builder piiEntityTypes(Collection<PiiEntityType> piiEntityTypes) {
            this.piiEntityTypes = PiiEntityTypesCopier.copyEnumToString(piiEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntityTypes(PiiEntityType ... piiEntityTypes) {
            this.piiEntityTypes(Arrays.asList(piiEntityTypes));
            return this;
        }

        public ContentRedaction build() {
            return new ContentRedaction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentRedaction> {
        public Builder redactionType(String var1);

        public Builder redactionType(RedactionType var1);

        public Builder redactionOutput(String var1);

        public Builder redactionOutput(RedactionOutput var1);

        public Builder piiEntityTypesWithStrings(Collection<String> var1);

        public Builder piiEntityTypesWithStrings(String ... var1);

        public Builder piiEntityTypes(Collection<PiiEntityType> var1);

        public Builder piiEntityTypes(PiiEntityType ... var1);
    }
}

