/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CallAnalyticsEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CallAnalyticsEntity> {
    private static final SdkField<Long> BEGIN_OFFSET_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BeginOffsetMillis").getter(CallAnalyticsEntity.getter(CallAnalyticsEntity::beginOffsetMillis)).setter(CallAnalyticsEntity.setter(Builder::beginOffsetMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()}).build();
    private static final SdkField<Long> END_OFFSET_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EndOffsetMillis").getter(CallAnalyticsEntity.getter(CallAnalyticsEntity::endOffsetMillis)).setter(CallAnalyticsEntity.setter(Builder::endOffsetMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(CallAnalyticsEntity.getter(CallAnalyticsEntity::category)).setter(CallAnalyticsEntity.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CallAnalyticsEntity.getter(CallAnalyticsEntity::type)).setter(CallAnalyticsEntity.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(CallAnalyticsEntity.getter(CallAnalyticsEntity::content)).setter(CallAnalyticsEntity.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Confidence").getter(CallAnalyticsEntity.getter(CallAnalyticsEntity::confidence)).setter(CallAnalyticsEntity.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_MILLIS_FIELD, END_OFFSET_MILLIS_FIELD, CATEGORY_FIELD, TYPE_FIELD, CONTENT_FIELD, CONFIDENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long beginOffsetMillis;
    private final Long endOffsetMillis;
    private final String category;
    private final String type;
    private final String content;
    private final Double confidence;

    private CallAnalyticsEntity(BuilderImpl builder) {
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
        this.category = builder.category;
        this.type = builder.type;
        this.content = builder.content;
        this.confidence = builder.confidence;
    }

    public final Long beginOffsetMillis() {
        return this.beginOffsetMillis;
    }

    public final Long endOffsetMillis() {
        return this.endOffsetMillis;
    }

    public final String category() {
        return this.category;
    }

    public final String type() {
        return this.type;
    }

    public final String content() {
        return this.content;
    }

    public final Double confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsEntity)) {
            return false;
        }
        CallAnalyticsEntity other = (CallAnalyticsEntity)obj;
        return Objects.equals(this.beginOffsetMillis(), other.beginOffsetMillis()) && Objects.equals(this.endOffsetMillis(), other.endOffsetMillis()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.confidence(), other.confidence());
    }

    public final String toString() {
        return ToString.builder((String)"CallAnalyticsEntity").add("BeginOffsetMillis", (Object)this.beginOffsetMillis()).add("EndOffsetMillis", (Object)this.endOffsetMillis()).add("Category", (Object)this.category()).add("Type", (Object)this.type()).add("Content", (Object)this.content()).add("Confidence", (Object)this.confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BeginOffsetMillis": {
                return Optional.ofNullable(clazz.cast(this.beginOffsetMillis()));
            }
            case "EndOffsetMillis": {
                return Optional.ofNullable(clazz.cast(this.endOffsetMillis()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsEntity, T> g) {
        return obj -> g.apply((CallAnalyticsEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long beginOffsetMillis;
        private Long endOffsetMillis;
        private String category;
        private String type;
        private String content;
        private Double confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsEntity model) {
            this.beginOffsetMillis(model.beginOffsetMillis);
            this.endOffsetMillis(model.endOffsetMillis);
            this.category(model.category);
            this.type(model.type);
            this.content(model.content);
            this.confidence(model.confidence);
        }

        public final Long getBeginOffsetMillis() {
            return this.beginOffsetMillis;
        }

        public final void setBeginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final Long getEndOffsetMillis() {
            return this.endOffsetMillis;
        }

        public final void setEndOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Double getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public CallAnalyticsEntity build() {
            return new CallAnalyticsEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CallAnalyticsEntity> {
        public Builder beginOffsetMillis(Long var1);

        public Builder endOffsetMillis(Long var1);

        public Builder category(String var1);

        public Builder type(String var1);

        public Builder content(String var1);

        public Builder confidence(Double var1);
    }
}

