/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessesResponse extends TransferResponse implements
        ToCopyableBuilder<ListAccessesResponse.Builder, ListAccessesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAccessesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(ListAccessesResponse::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<List<ListedAccess>> ACCESSES_FIELD = SdkField
            .<List<ListedAccess>> builder(MarshallingType.LIST)
            .memberName("Accesses")
            .getter(getter(ListAccessesResponse::accesses))
            .setter(setter(Builder::accesses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accesses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedAccess> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedAccess::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVER_ID_FIELD, ACCESSES_FIELD));

    private final String nextToken;

    private final String serverId;

    private final List<ListedAccess> accesses;

    private ListAccessesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serverId = builder.serverId;
        this.accesses = builder.accesses;
    }

    /**
     * <p>
     * When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter
     * is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to
     * continue listing additional accesses.
     * </p>
     * 
     * @return When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code>
     *         parameter is returned in the output. You can then pass in a subsequent command to the
     *         <code>NextToken</code> parameter to continue listing additional accesses.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a server that has users assigned to it.
     * </p>
     * 
     * @return A system-assigned unique identifier for a server that has users assigned to it.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accesses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccesses() {
        return accesses != null && !(accesses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the accesses and their properties for the <code>ServerId</code> value that you specify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccesses} method.
     * </p>
     * 
     * @return Returns the accesses and their properties for the <code>ServerId</code> value that you specify.
     */
    public final List<ListedAccess> accesses() {
        return accesses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccesses() ? accesses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessesResponse)) {
            return false;
        }
        ListAccessesResponse other = (ListAccessesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(serverId(), other.serverId())
                && hasAccesses() == other.hasAccesses() && Objects.equals(accesses(), other.accesses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessesResponse").add("NextToken", nextToken()).add("ServerId", serverId())
                .add("Accesses", hasAccesses() ? accesses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "Accesses":
            return Optional.ofNullable(clazz.cast(accesses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessesResponse, T> g) {
        return obj -> g.apply((ListAccessesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessesResponse> {
        /**
         * <p>
         * When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code>
         * parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code>
         * parameter to continue listing additional accesses.
         * </p>
         * 
         * @param nextToken
         *        When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code>
         *        parameter is returned in the output. You can then pass in a subsequent command to the
         *        <code>NextToken</code> parameter to continue listing additional accesses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A system-assigned unique identifier for a server that has users assigned to it.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for a server that has users assigned to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * Returns the accesses and their properties for the <code>ServerId</code> value that you specify.
         * </p>
         * 
         * @param accesses
         *        Returns the accesses and their properties for the <code>ServerId</code> value that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accesses(Collection<ListedAccess> accesses);

        /**
         * <p>
         * Returns the accesses and their properties for the <code>ServerId</code> value that you specify.
         * </p>
         * 
         * @param accesses
         *        Returns the accesses and their properties for the <code>ServerId</code> value that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accesses(ListedAccess... accesses);

        /**
         * <p>
         * Returns the accesses and their properties for the <code>ServerId</code> value that you specify.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.ListedAccess.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.transfer.model.ListedAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.ListedAccess.Builder#build()} is called immediately and
         * its result is passed to {@link #accesses(List<ListedAccess>)}.
         * 
         * @param accesses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.ListedAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accesses(java.util.Collection<ListedAccess>)
         */
        Builder accesses(Consumer<ListedAccess.Builder>... accesses);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String serverId;

        private List<ListedAccess> accesses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessesResponse model) {
            super(model);
            nextToken(model.nextToken);
            serverId(model.serverId);
            accesses(model.accesses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final List<ListedAccess.Builder> getAccesses() {
            List<ListedAccess.Builder> result = ListedAccessesCopier.copyToBuilder(this.accesses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccesses(Collection<ListedAccess.BuilderImpl> accesses) {
            this.accesses = ListedAccessesCopier.copyFromBuilder(accesses);
        }

        @Override
        public final Builder accesses(Collection<ListedAccess> accesses) {
            this.accesses = ListedAccessesCopier.copy(accesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accesses(ListedAccess... accesses) {
            accesses(Arrays.asList(accesses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accesses(Consumer<ListedAccess.Builder>... accesses) {
            accesses(Stream.of(accesses).map(c -> ListedAccess.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessesResponse build() {
            return new ListAccessesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
