/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.SubnetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedWebAppVpcConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedWebAppVpcConfig> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(DescribedWebAppVpcConfig.getter(DescribedWebAppVpcConfig::subnetIds)).setter(DescribedWebAppVpcConfig.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DescribedWebAppVpcConfig.getter(DescribedWebAppVpcConfig::vpcId)).setter(DescribedWebAppVpcConfig.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(DescribedWebAppVpcConfig.getter(DescribedWebAppVpcConfig::vpcEndpointId)).setter(DescribedWebAppVpcConfig.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD, VPC_ID_FIELD, VPC_ENDPOINT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribedWebAppVpcConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> subnetIds;
    private final String vpcId;
    private final String vpcEndpointId;

    private DescribedWebAppVpcConfig(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.vpcId = builder.vpcId;
        this.vpcEndpointId = builder.vpcEndpointId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedWebAppVpcConfig)) {
            return false;
        }
        DescribedWebAppVpcConfig other = (DescribedWebAppVpcConfig)obj;
        return this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedWebAppVpcConfig").add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("VpcId", (Object)this.vpcId()).add("VpcEndpointId", (Object)this.vpcEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedWebAppVpcConfig, T> g) {
        return obj -> g.apply((DescribedWebAppVpcConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private String vpcEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedWebAppVpcConfig model) {
            this.subnetIds(model.subnetIds);
            this.vpcId(model.vpcId);
            this.vpcEndpointId(model.vpcEndpointId);
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public DescribedWebAppVpcConfig build() {
            return new DescribedWebAppVpcConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedWebAppVpcConfig> {
        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder vpcId(String var1);

        public Builder vpcEndpointId(String var1);
    }
}

