/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.ListedExecution;
import software.amazon.awssdk.services.transfer.model.ListedExecutionsCopier;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExecutionsResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ListExecutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExecutionsResponse.getter(ListExecutionsResponse::nextToken)).setter(ListExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowId").getter(ListExecutionsResponse.getter(ListExecutionsResponse::workflowId)).setter(ListExecutionsResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()}).build();
    private static final SdkField<List<ListedExecution>> EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Executions").getter(ListExecutionsResponse.getter(ListExecutionsResponse::executions)).setter(ListExecutionsResponse.setter(Builder::executions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Executions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKFLOW_ID_FIELD, EXECUTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExecutionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final String workflowId;
    private final List<ListedExecution> executions;

    private ListExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workflowId = builder.workflowId;
        this.executions = builder.executions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final boolean hasExecutions() {
        return this.executions != null && !(this.executions instanceof SdkAutoConstructList);
    }

    public final List<ListedExecution> executions() {
        return this.executions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutions() ? this.executions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsResponse)) {
            return false;
        }
        ListExecutionsResponse other = (ListExecutionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.workflowId(), other.workflowId()) && this.hasExecutions() == other.hasExecutions() && Objects.equals(this.executions(), other.executions());
    }

    public final String toString() {
        return ToString.builder((String)"ListExecutionsResponse").add("NextToken", (Object)this.nextToken()).add("WorkflowId", (Object)this.workflowId()).add("Executions", this.hasExecutions() ? this.executions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "WorkflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "Executions": {
                return Optional.ofNullable(clazz.cast(this.executions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WorkflowId", WORKFLOW_ID_FIELD);
        map.put("Executions", EXECUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExecutionsResponse, T> g) {
        return obj -> g.apply((ListExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String workflowId;
        private List<ListedExecution> executions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workflowId(model.workflowId);
            this.executions(model.executions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final List<ListedExecution.Builder> getExecutions() {
            List<ListedExecution.Builder> result = ListedExecutionsCopier.copyToBuilder(this.executions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutions(Collection<ListedExecution.BuilderImpl> executions) {
            this.executions = ListedExecutionsCopier.copyFromBuilder(executions);
        }

        @Override
        public final Builder executions(Collection<ListedExecution> executions) {
            this.executions = ListedExecutionsCopier.copy(executions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executions(ListedExecution ... executions) {
            this.executions(Arrays.asList(executions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executions(Consumer<ListedExecution.Builder> ... executions) {
            this.executions(Stream.of(executions).map(c -> (ListedExecution)((ListedExecution.Builder)ListedExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListExecutionsResponse build() {
            return new ListExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExecutionsResponse> {
        public Builder nextToken(String var1);

        public Builder workflowId(String var1);

        public Builder executions(Collection<ListedExecution> var1);

        public Builder executions(ListedExecution ... var1);

        public Builder executions(Consumer<ListedExecution.Builder> ... var1);
    }
}

