/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.WebAppEndpointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedWebApp
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedWebApp> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListedWebApp.getter(ListedWebApp::arn)).setter(ListedWebApp.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAppId").getter(ListedWebApp.getter(ListedWebApp::webAppId)).setter(ListedWebApp.setter(Builder::webAppId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()}).build();
    private static final SdkField<String> ACCESS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessEndpoint").getter(ListedWebApp.getter(ListedWebApp::accessEndpoint)).setter(ListedWebApp.setter(Builder::accessEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoint").build()}).build();
    private static final SdkField<String> WEB_APP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAppEndpoint").getter(ListedWebApp.getter(ListedWebApp::webAppEndpoint)).setter(ListedWebApp.setter(Builder::webAppEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppEndpoint").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(ListedWebApp.getter(ListedWebApp::endpointTypeAsString)).setter(ListedWebApp.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WEB_APP_ID_FIELD, ACCESS_ENDPOINT_FIELD, WEB_APP_ENDPOINT_FIELD, ENDPOINT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListedWebApp.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String webAppId;
    private final String accessEndpoint;
    private final String webAppEndpoint;
    private final String endpointType;

    private ListedWebApp(BuilderImpl builder) {
        this.arn = builder.arn;
        this.webAppId = builder.webAppId;
        this.accessEndpoint = builder.accessEndpoint;
        this.webAppEndpoint = builder.webAppEndpoint;
        this.endpointType = builder.endpointType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String webAppId() {
        return this.webAppId;
    }

    public final String accessEndpoint() {
        return this.accessEndpoint;
    }

    public final String webAppEndpoint() {
        return this.webAppEndpoint;
    }

    public final WebAppEndpointType endpointType() {
        return WebAppEndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedWebApp)) {
            return false;
        }
        ListedWebApp other = (ListedWebApp)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.webAppId(), other.webAppId()) && Objects.equals(this.accessEndpoint(), other.accessEndpoint()) && Objects.equals(this.webAppEndpoint(), other.webAppEndpoint()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListedWebApp").add("Arn", (Object)this.arn()).add("WebAppId", (Object)this.webAppId()).add("AccessEndpoint", (Object)this.accessEndpoint()).add("WebAppEndpoint", (Object)this.webAppEndpoint()).add("EndpointType", (Object)this.endpointTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "WebAppId": {
                return Optional.ofNullable(clazz.cast(this.webAppId()));
            }
            case "AccessEndpoint": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoint()));
            }
            case "WebAppEndpoint": {
                return Optional.ofNullable(clazz.cast(this.webAppEndpoint()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Arn", ARN_FIELD);
        map.put("WebAppId", WEB_APP_ID_FIELD);
        map.put("AccessEndpoint", ACCESS_ENDPOINT_FIELD);
        map.put("WebAppEndpoint", WEB_APP_ENDPOINT_FIELD);
        map.put("EndpointType", ENDPOINT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedWebApp, T> g) {
        return obj -> g.apply((ListedWebApp)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String webAppId;
        private String accessEndpoint;
        private String webAppEndpoint;
        private String endpointType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedWebApp model) {
            this.arn(model.arn);
            this.webAppId(model.webAppId);
            this.accessEndpoint(model.accessEndpoint);
            this.webAppEndpoint(model.webAppEndpoint);
            this.endpointType(model.endpointType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWebAppId() {
            return this.webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final String getAccessEndpoint() {
            return this.accessEndpoint;
        }

        public final void setAccessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
        }

        @Override
        public final Builder accessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
            return this;
        }

        public final String getWebAppEndpoint() {
            return this.webAppEndpoint;
        }

        public final void setWebAppEndpoint(String webAppEndpoint) {
            this.webAppEndpoint = webAppEndpoint;
        }

        @Override
        public final Builder webAppEndpoint(String webAppEndpoint) {
            this.webAppEndpoint = webAppEndpoint;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(WebAppEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public ListedWebApp build() {
            return new ListedWebApp(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedWebApp> {
        public Builder arn(String var1);

        public Builder webAppId(String var1);

        public Builder accessEndpoint(String var1);

        public Builder webAppEndpoint(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(WebAppEndpointType var1);
    }
}

