/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.transfer.model.DescribeServerRequest;
import software.amazon.awssdk.services.transfer.model.DescribeServerResponse;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.services.transfer.waiters.TransferWaiter;
import software.amazon.awssdk.services.transfer.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultTransferWaiter
implements TransferWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final TransferClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeServerResponse> serverOfflineWaiter;
    private final Waiter<DescribeServerResponse> serverOnlineWaiter;

    private DefaultTransferWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (TransferClient)TransferClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.serverOfflineWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeServerResponse.class).acceptors(DefaultTransferWaiter.serverOfflineWaiterAcceptors())).overrideConfiguration(DefaultTransferWaiter.serverOfflineWaiterConfig(builder.overrideConfiguration))).build();
        this.serverOnlineWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeServerResponse.class).acceptors(DefaultTransferWaiter.serverOnlineWaiterAcceptors())).overrideConfiguration(DefaultTransferWaiter.serverOnlineWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeServerResponse> waitUntilServerOffline(DescribeServerRequest describeServerRequest) {
        return this.serverOfflineWaiter.run(() -> this.client.describeServer(this.applyWaitersUserAgent(describeServerRequest)));
    }

    @Override
    public WaiterResponse<DescribeServerResponse> waitUntilServerOffline(DescribeServerRequest describeServerRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serverOfflineWaiter.run(() -> this.client.describeServer(this.applyWaitersUserAgent(describeServerRequest)), DefaultTransferWaiter.serverOfflineWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeServerResponse> waitUntilServerOnline(DescribeServerRequest describeServerRequest) {
        return this.serverOnlineWaiter.run(() -> this.client.describeServer(this.applyWaitersUserAgent(describeServerRequest)));
    }

    @Override
    public WaiterResponse<DescribeServerResponse> waitUntilServerOnline(DescribeServerRequest describeServerRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serverOnlineWaiter.run(() -> this.client.describeServer(this.applyWaitersUserAgent(describeServerRequest)), DefaultTransferWaiter.serverOnlineWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeServerResponse>> serverOfflineWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeServerResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeServerResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Server").field("State").value(), "OFFLINE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Server").field("State").value(), "STOP_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Server.State=STOP_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeServerResponse>> serverOnlineWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeServerResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeServerResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Server").field("State").value(), "ONLINE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Server").field("State").value(), "START_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Server.State=START_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration serverOfflineWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serverOnlineWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static TransferWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends TransferRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TransferRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements TransferWaiter.Builder {
        private TransferClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public TransferWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public TransferWaiter.Builder client(TransferClient client) {
            this.client = client;
            return this;
        }

        @Override
        public TransferWaiter build() {
            return new DefaultTransferWaiter(this);
        }
    }
}

