/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.OrganizationRecommendationSummary;

public class ListOrganizationRecommendationsIterable
implements SdkIterable<ListOrganizationRecommendationsResponse> {
    private final TrustedAdvisorClient client;
    private final ListOrganizationRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrganizationRecommendationsIterable(TrustedAdvisorClient client, ListOrganizationRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOrganizationRecommendationsResponseFetcher();
    }

    public Iterator<ListOrganizationRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OrganizationRecommendationSummary> organizationRecommendationSummaries() {
        Function<ListOrganizationRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationRecommendationSummaries() != null) {
                return response.organizationRecommendationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOrganizationRecommendationsResponseFetcher
    implements SyncPageFetcher<ListOrganizationRecommendationsResponse> {
        private ListOrganizationRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrganizationRecommendationsResponse nextPage(ListOrganizationRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationRecommendationsIterable.this.client.listOrganizationRecommendations(ListOrganizationRecommendationsIterable.this.firstRequest);
            }
            return ListOrganizationRecommendationsIterable.this.client.listOrganizationRecommendations((ListOrganizationRecommendationsRequest)((Object)ListOrganizationRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

