/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentitySourcesRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<ListIdentitySourcesRequest.Builder, ListIdentitySourcesRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(ListIdentitySourcesRequest::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIdentitySourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListIdentitySourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<IdentitySourceFilter>> FILTERS_FIELD = SdkField
            .<List<IdentitySourceFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListIdentitySourcesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentitySourceFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentitySourceFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD));

    private final String policyStoreId;

    private final String nextToken;

    private final Integer maxResults;

    private final List<IdentitySourceFilter> filters;

    private ListIdentitySourcesRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * Specifies the ID of the policy store that contains the identity sources that you want to list.
     * </p>
     * 
     * @return Specifies the ID of the policy store that contains the identity sources that you want to list.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>NextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the total number of results that you want included in each response. If additional items exist beyond
     * the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include
     * the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the
     * next set of results. Note that the service might return fewer results than the maximum even when there are more
     * results available. You should check <code>NextToken</code> after every operation to ensure that you receive all
     * of the results.
     * </p>
     * <p>
     * If you do not specify this parameter, the operation defaults to 10 identity sources per response. You can specify
     * a maximum of 200 identity sources per response.
     * </p>
     * 
     * @return Specifies the total number of results that you want included in each response. If additional items exist
     *         beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
     *         null). Include the specified value as the <code>NextToken</code> request parameter in the next call to
     *         the operation to get the next set of results. Note that the service might return fewer results than the
     *         maximum even when there are more results available. You should check <code>NextToken</code> after every
     *         operation to ensure that you receive all of the results.</p>
     *         <p>
     *         If you do not specify this parameter, the operation defaults to 10 identity sources per response. You can
     *         specify a maximum of 200 identity sources per response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies characteristics of an identity source that you can use to limit the output to matching identity
     * sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Specifies characteristics of an identity source that you can use to limit the output to matching identity
     *         sources.
     */
    public final List<IdentitySourceFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitySourcesRequest)) {
            return false;
        }
        ListIdentitySourcesRequest other = (ListIdentitySourcesRequest) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdentitySourcesRequest").add("PolicyStoreId", policyStoreId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentitySourcesRequest, T> g) {
        return obj -> g.apply((ListIdentitySourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIdentitySourcesRequest> {
        /**
         * <p>
         * Specifies the ID of the policy store that contains the identity sources that you want to list.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the ID of the policy store that contains the identity sources that you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the total number of results that you want included in each response. If additional items exist
         * beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
         * null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next set of results. Note that the service might return fewer results than the maximum
         * even when there are more results available. You should check <code>NextToken</code> after every operation to
         * ensure that you receive all of the results.
         * </p>
         * <p>
         * If you do not specify this parameter, the operation defaults to 10 identity sources per response. You can
         * specify a maximum of 200 identity sources per response.
         * </p>
         * 
         * @param maxResults
         *        Specifies the total number of results that you want included in each response. If additional items
         *        exist beyond the number you specify, the <code>NextToken</code> response element is returned with a
         *        value (not null). Include the specified value as the <code>NextToken</code> request parameter in the
         *        next call to the operation to get the next set of results. Note that the service might return fewer
         *        results than the maximum even when there are more results available. You should check
         *        <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
         *        <p>
         *        If you do not specify this parameter, the operation defaults to 10 identity sources per response. You
         *        can specify a maximum of 200 identity sources per response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies characteristics of an identity source that you can use to limit the output to matching identity
         * sources.
         * </p>
         * 
         * @param filters
         *        Specifies characteristics of an identity source that you can use to limit the output to matching
         *        identity sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<IdentitySourceFilter> filters);

        /**
         * <p>
         * Specifies characteristics of an identity source that you can use to limit the output to matching identity
         * sources.
         * </p>
         * 
         * @param filters
         *        Specifies characteristics of an identity source that you can use to limit the output to matching
         *        identity sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(IdentitySourceFilter... filters);

        /**
         * <p>
         * Specifies characteristics of an identity source that you can use to limit the output to matching identity
         * sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.IdentitySourceFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.IdentitySourceFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.IdentitySourceFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(List<IdentitySourceFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.IdentitySourceFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<IdentitySourceFilter>)
         */
        Builder filters(Consumer<IdentitySourceFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String policyStoreId;

        private String nextToken;

        private Integer maxResults;

        private List<IdentitySourceFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitySourcesRequest model) {
            super(model);
            policyStoreId(model.policyStoreId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<IdentitySourceFilter.Builder> getFilters() {
            List<IdentitySourceFilter.Builder> result = IdentitySourceFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IdentitySourceFilter.BuilderImpl> filters) {
            this.filters = IdentitySourceFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IdentitySourceFilter> filters) {
            this.filters = IdentitySourceFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IdentitySourceFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IdentitySourceFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> IdentitySourceFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIdentitySourcesRequest build() {
            return new ListIdentitySourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
