/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.voiceid.VoiceIdClient;
import software.amazon.awssdk.services.voiceid.internal.UserAgentUtils;
import software.amazon.awssdk.services.voiceid.model.FraudsterRegistrationJobSummary;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse;

public class ListFraudsterRegistrationJobsIterable
implements SdkIterable<ListFraudsterRegistrationJobsResponse> {
    private final VoiceIdClient client;
    private final ListFraudsterRegistrationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFraudsterRegistrationJobsIterable(VoiceIdClient client, ListFraudsterRegistrationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFraudsterRegistrationJobsResponseFetcher();
    }

    public Iterator<ListFraudsterRegistrationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FraudsterRegistrationJobSummary> jobSummaries() {
        Function<ListFraudsterRegistrationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFraudsterRegistrationJobsResponseFetcher
    implements SyncPageFetcher<ListFraudsterRegistrationJobsResponse> {
        private ListFraudsterRegistrationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListFraudsterRegistrationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFraudsterRegistrationJobsResponse nextPage(ListFraudsterRegistrationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListFraudsterRegistrationJobsIterable.this.client.listFraudsterRegistrationJobs(ListFraudsterRegistrationJobsIterable.this.firstRequest);
            }
            return ListFraudsterRegistrationJobsIterable.this.client.listFraudsterRegistrationJobs((ListFraudsterRegistrationJobsRequest)((Object)ListFraudsterRegistrationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

