/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.AuthenticationConfiguration;
import software.amazon.awssdk.services.voiceid.model.AuthenticationDecision;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationResult> {
    private static final SdkField<Instant> AUDIO_AGGREGATION_ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AudioAggregationEndedAt").getter(AuthenticationResult.getter(AuthenticationResult::audioAggregationEndedAt)).setter(AuthenticationResult.setter(Builder::audioAggregationEndedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioAggregationEndedAt").build()}).build();
    private static final SdkField<Instant> AUDIO_AGGREGATION_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AudioAggregationStartedAt").getter(AuthenticationResult.getter(AuthenticationResult::audioAggregationStartedAt)).setter(AuthenticationResult.setter(Builder::audioAggregationStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioAggregationStartedAt").build()}).build();
    private static final SdkField<String> AUTHENTICATION_RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationResultId").getter(AuthenticationResult.getter(AuthenticationResult::authenticationResultId)).setter(AuthenticationResult.setter(Builder::authenticationResultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationResultId").build()}).build();
    private static final SdkField<AuthenticationConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(AuthenticationResult.getter(AuthenticationResult::configuration)).setter(AuthenticationResult.setter(Builder::configuration)).constructor(AuthenticationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> CUSTOMER_SPEAKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerSpeakerId").getter(AuthenticationResult.getter(AuthenticationResult::customerSpeakerId)).setter(AuthenticationResult.setter(Builder::customerSpeakerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerSpeakerId").build()}).build();
    private static final SdkField<String> DECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Decision").getter(AuthenticationResult.getter(AuthenticationResult::decisionAsString)).setter(AuthenticationResult.setter(Builder::decision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Decision").build()}).build();
    private static final SdkField<String> GENERATED_SPEAKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedSpeakerId").getter(AuthenticationResult.getter(AuthenticationResult::generatedSpeakerId)).setter(AuthenticationResult.setter(Builder::generatedSpeakerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedSpeakerId").build()}).build();
    private static final SdkField<Integer> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Score").getter(AuthenticationResult.getter(AuthenticationResult::score)).setter(AuthenticationResult.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_AGGREGATION_ENDED_AT_FIELD, AUDIO_AGGREGATION_STARTED_AT_FIELD, AUTHENTICATION_RESULT_ID_FIELD, CONFIGURATION_FIELD, CUSTOMER_SPEAKER_ID_FIELD, DECISION_FIELD, GENERATED_SPEAKER_ID_FIELD, SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthenticationResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant audioAggregationEndedAt;
    private final Instant audioAggregationStartedAt;
    private final String authenticationResultId;
    private final AuthenticationConfiguration configuration;
    private final String customerSpeakerId;
    private final String decision;
    private final String generatedSpeakerId;
    private final Integer score;

    private AuthenticationResult(BuilderImpl builder) {
        this.audioAggregationEndedAt = builder.audioAggregationEndedAt;
        this.audioAggregationStartedAt = builder.audioAggregationStartedAt;
        this.authenticationResultId = builder.authenticationResultId;
        this.configuration = builder.configuration;
        this.customerSpeakerId = builder.customerSpeakerId;
        this.decision = builder.decision;
        this.generatedSpeakerId = builder.generatedSpeakerId;
        this.score = builder.score;
    }

    public final Instant audioAggregationEndedAt() {
        return this.audioAggregationEndedAt;
    }

    public final Instant audioAggregationStartedAt() {
        return this.audioAggregationStartedAt;
    }

    public final String authenticationResultId() {
        return this.authenticationResultId;
    }

    public final AuthenticationConfiguration configuration() {
        return this.configuration;
    }

    public final String customerSpeakerId() {
        return this.customerSpeakerId;
    }

    public final AuthenticationDecision decision() {
        return AuthenticationDecision.fromValue(this.decision);
    }

    public final String decisionAsString() {
        return this.decision;
    }

    public final String generatedSpeakerId() {
        return this.generatedSpeakerId;
    }

    public final Integer score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioAggregationEndedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioAggregationStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationResultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationResult)) {
            return false;
        }
        AuthenticationResult other = (AuthenticationResult)obj;
        return Objects.equals(this.audioAggregationEndedAt(), other.audioAggregationEndedAt()) && Objects.equals(this.audioAggregationStartedAt(), other.audioAggregationStartedAt()) && Objects.equals(this.authenticationResultId(), other.authenticationResultId()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.customerSpeakerId(), other.customerSpeakerId()) && Objects.equals(this.decisionAsString(), other.decisionAsString()) && Objects.equals(this.generatedSpeakerId(), other.generatedSpeakerId()) && Objects.equals(this.score(), other.score());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationResult").add("AudioAggregationEndedAt", (Object)this.audioAggregationEndedAt()).add("AudioAggregationStartedAt", (Object)this.audioAggregationStartedAt()).add("AuthenticationResultId", (Object)this.authenticationResultId()).add("Configuration", (Object)this.configuration()).add("CustomerSpeakerId", (Object)(this.customerSpeakerId() == null ? null : "*** Sensitive Data Redacted ***")).add("Decision", (Object)this.decisionAsString()).add("GeneratedSpeakerId", (Object)this.generatedSpeakerId()).add("Score", (Object)this.score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioAggregationEndedAt": {
                return Optional.ofNullable(clazz.cast(this.audioAggregationEndedAt()));
            }
            case "AudioAggregationStartedAt": {
                return Optional.ofNullable(clazz.cast(this.audioAggregationStartedAt()));
            }
            case "AuthenticationResultId": {
                return Optional.ofNullable(clazz.cast(this.authenticationResultId()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "CustomerSpeakerId": {
                return Optional.ofNullable(clazz.cast(this.customerSpeakerId()));
            }
            case "Decision": {
                return Optional.ofNullable(clazz.cast(this.decisionAsString()));
            }
            case "GeneratedSpeakerId": {
                return Optional.ofNullable(clazz.cast(this.generatedSpeakerId()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AudioAggregationEndedAt", AUDIO_AGGREGATION_ENDED_AT_FIELD);
        map.put("AudioAggregationStartedAt", AUDIO_AGGREGATION_STARTED_AT_FIELD);
        map.put("AuthenticationResultId", AUTHENTICATION_RESULT_ID_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("CustomerSpeakerId", CUSTOMER_SPEAKER_ID_FIELD);
        map.put("Decision", DECISION_FIELD);
        map.put("GeneratedSpeakerId", GENERATED_SPEAKER_ID_FIELD);
        map.put("Score", SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationResult, T> g) {
        return obj -> g.apply((AuthenticationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant audioAggregationEndedAt;
        private Instant audioAggregationStartedAt;
        private String authenticationResultId;
        private AuthenticationConfiguration configuration;
        private String customerSpeakerId;
        private String decision;
        private String generatedSpeakerId;
        private Integer score;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationResult model) {
            this.audioAggregationEndedAt(model.audioAggregationEndedAt);
            this.audioAggregationStartedAt(model.audioAggregationStartedAt);
            this.authenticationResultId(model.authenticationResultId);
            this.configuration(model.configuration);
            this.customerSpeakerId(model.customerSpeakerId);
            this.decision(model.decision);
            this.generatedSpeakerId(model.generatedSpeakerId);
            this.score(model.score);
        }

        public final Instant getAudioAggregationEndedAt() {
            return this.audioAggregationEndedAt;
        }

        public final void setAudioAggregationEndedAt(Instant audioAggregationEndedAt) {
            this.audioAggregationEndedAt = audioAggregationEndedAt;
        }

        @Override
        public final Builder audioAggregationEndedAt(Instant audioAggregationEndedAt) {
            this.audioAggregationEndedAt = audioAggregationEndedAt;
            return this;
        }

        public final Instant getAudioAggregationStartedAt() {
            return this.audioAggregationStartedAt;
        }

        public final void setAudioAggregationStartedAt(Instant audioAggregationStartedAt) {
            this.audioAggregationStartedAt = audioAggregationStartedAt;
        }

        @Override
        public final Builder audioAggregationStartedAt(Instant audioAggregationStartedAt) {
            this.audioAggregationStartedAt = audioAggregationStartedAt;
            return this;
        }

        public final String getAuthenticationResultId() {
            return this.authenticationResultId;
        }

        public final void setAuthenticationResultId(String authenticationResultId) {
            this.authenticationResultId = authenticationResultId;
        }

        @Override
        public final Builder authenticationResultId(String authenticationResultId) {
            this.authenticationResultId = authenticationResultId;
            return this;
        }

        public final AuthenticationConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AuthenticationConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AuthenticationConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getCustomerSpeakerId() {
            return this.customerSpeakerId;
        }

        public final void setCustomerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
        }

        @Override
        public final Builder customerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
            return this;
        }

        public final String getDecision() {
            return this.decision;
        }

        public final void setDecision(String decision) {
            this.decision = decision;
        }

        @Override
        public final Builder decision(String decision) {
            this.decision = decision;
            return this;
        }

        @Override
        public final Builder decision(AuthenticationDecision decision) {
            this.decision(decision == null ? null : decision.toString());
            return this;
        }

        public final String getGeneratedSpeakerId() {
            return this.generatedSpeakerId;
        }

        public final void setGeneratedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
        }

        @Override
        public final Builder generatedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
            return this;
        }

        public final Integer getScore() {
            return this.score;
        }

        public final void setScore(Integer score) {
            this.score = score;
        }

        @Override
        public final Builder score(Integer score) {
            this.score = score;
            return this;
        }

        public AuthenticationResult build() {
            return new AuthenticationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationResult> {
        public Builder audioAggregationEndedAt(Instant var1);

        public Builder audioAggregationStartedAt(Instant var1);

        public Builder authenticationResultId(String var1);

        public Builder configuration(AuthenticationConfiguration var1);

        default public Builder configuration(Consumer<AuthenticationConfiguration.Builder> configuration) {
            return this.configuration((AuthenticationConfiguration)((AuthenticationConfiguration.Builder)AuthenticationConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder customerSpeakerId(String var1);

        public Builder decision(String var1);

        public Builder decision(AuthenticationDecision var1);

        public Builder generatedSpeakerId(String var1);

        public Builder score(Integer var1);
    }
}

