/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceNetworkVpcAssociationsRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<ListServiceNetworkVpcAssociationsRequest.Builder, ListServiceNetworkVpcAssociationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListServiceNetworkVpcAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceNetworkVpcAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkIdentifier")
            .getter(getter(ListServiceNetworkVpcAssociationsRequest::serviceNetworkIdentifier))
            .setter(setter(Builder::serviceNetworkIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("serviceNetworkIdentifier")
                    .build()).build();

    private static final SdkField<String> VPC_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcIdentifier").getter(getter(ListServiceNetworkVpcAssociationsRequest::vpcIdentifier))
            .setter(setter(Builder::vpcIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, SERVICE_NETWORK_IDENTIFIER_FIELD, VPC_IDENTIFIER_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String serviceNetworkIdentifier;

    private final String vpcIdentifier;

    private ListServiceNetworkVpcAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.serviceNetworkIdentifier = builder.serviceNetworkIdentifier;
        this.vpcIdentifier = builder.vpcIdentifier;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token for the next page of results.
     * </p>
     * 
     * @return A pagination token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the service network.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the service network.
     */
    public final String serviceNetworkIdentifier() {
        return serviceNetworkIdentifier;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the VPC.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the VPC.
     */
    public final String vpcIdentifier() {
        return vpcIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(vpcIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceNetworkVpcAssociationsRequest)) {
            return false;
        }
        ListServiceNetworkVpcAssociationsRequest other = (ListServiceNetworkVpcAssociationsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(serviceNetworkIdentifier(), other.serviceNetworkIdentifier())
                && Objects.equals(vpcIdentifier(), other.vpcIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceNetworkVpcAssociationsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("ServiceNetworkIdentifier", serviceNetworkIdentifier())
                .add("VpcIdentifier", vpcIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "serviceNetworkIdentifier":
            return Optional.ofNullable(clazz.cast(serviceNetworkIdentifier()));
        case "vpcIdentifier":
            return Optional.ofNullable(clazz.cast(vpcIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceNetworkVpcAssociationsRequest, T> g) {
        return obj -> g.apply((ListServiceNetworkVpcAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceNetworkVpcAssociationsRequest> {
        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the service network.
         * </p>
         * 
         * @param serviceNetworkIdentifier
         *        The ID or Amazon Resource Name (ARN) of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkIdentifier(String serviceNetworkIdentifier);

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the VPC.
         * </p>
         * 
         * @param vpcIdentifier
         *        The ID or Amazon Resource Name (ARN) of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIdentifier(String vpcIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String serviceNetworkIdentifier;

        private String vpcIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceNetworkVpcAssociationsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            serviceNetworkIdentifier(model.serviceNetworkIdentifier);
            vpcIdentifier(model.vpcIdentifier);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServiceNetworkIdentifier() {
            return serviceNetworkIdentifier;
        }

        public final void setServiceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
        }

        @Override
        public final Builder serviceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
            return this;
        }

        public final String getVpcIdentifier() {
            return vpcIdentifier;
        }

        public final void setVpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
        }

        @Override
        public final Builder vpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceNetworkVpcAssociationsRequest build() {
            return new ListServiceNetworkVpcAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
