/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.PortRangeListCopier;
import software.amazon.awssdk.services.vpclattice.model.ProtocolType;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationDefinition;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationStatus;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationType;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceConfigurationResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, CreateResourceConfigurationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::id)).setter(CreateResourceConfigurationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::name)).setter(CreateResourceConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::arn)).setter(CreateResourceConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> RESOURCE_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGatewayId").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::resourceGatewayId)).setter(CreateResourceConfigurationResponse.setter(Builder::resourceGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayId").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationGroupId").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::resourceConfigurationGroupId)).setter(CreateResourceConfigurationResponse.setter(Builder::resourceConfigurationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationGroupId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::typeAsString)).setter(CreateResourceConfigurationResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<String>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portRanges").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::portRanges)).setter(CreateResourceConfigurationResponse.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::protocolAsString)).setter(CreateResourceConfigurationResponse.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::statusAsString)).setter(CreateResourceConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ResourceConfigurationDefinition> RESOURCE_CONFIGURATION_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfigurationDefinition").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::resourceConfigurationDefinition)).setter(CreateResourceConfigurationResponse.setter(Builder::resourceConfigurationDefinition)).constructor(ResourceConfigurationDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationDefinition").build()}).build();
    private static final SdkField<Boolean> ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowAssociationToShareableServiceNetwork").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::allowAssociationToShareableServiceNetwork)).setter(CreateResourceConfigurationResponse.setter(Builder::allowAssociationToShareableServiceNetwork)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowAssociationToShareableServiceNetwork").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::createdAt)).setter(CreateResourceConfigurationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::failureReason)).setter(CreateResourceConfigurationResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDomainName").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::customDomainName)).setter(CreateResourceConfigurationResponse.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()}).build();
    private static final SdkField<String> DOMAIN_VERIFICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainVerificationId").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::domainVerificationId)).setter(CreateResourceConfigurationResponse.setter(Builder::domainVerificationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVerificationId").build()}).build();
    private static final SdkField<String> GROUP_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupDomain").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::groupDomain)).setter(CreateResourceConfigurationResponse.setter(Builder::groupDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupDomain").build()}).build();
    private static final SdkField<String> DOMAIN_VERIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainVerificationArn").getter(CreateResourceConfigurationResponse.getter(CreateResourceConfigurationResponse::domainVerificationArn)).setter(CreateResourceConfigurationResponse.setter(Builder::domainVerificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVerificationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, RESOURCE_GATEWAY_ID_FIELD, RESOURCE_CONFIGURATION_GROUP_ID_FIELD, TYPE_FIELD, PORT_RANGES_FIELD, PROTOCOL_FIELD, STATUS_FIELD, RESOURCE_CONFIGURATION_DEFINITION_FIELD, ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD, CREATED_AT_FIELD, FAILURE_REASON_FIELD, CUSTOM_DOMAIN_NAME_FIELD, DOMAIN_VERIFICATION_ID_FIELD, GROUP_DOMAIN_FIELD, DOMAIN_VERIFICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateResourceConfigurationResponse.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final String arn;
    private final String resourceGatewayId;
    private final String resourceConfigurationGroupId;
    private final String type;
    private final List<String> portRanges;
    private final String protocol;
    private final String status;
    private final ResourceConfigurationDefinition resourceConfigurationDefinition;
    private final Boolean allowAssociationToShareableServiceNetwork;
    private final Instant createdAt;
    private final String failureReason;
    private final String customDomainName;
    private final String domainVerificationId;
    private final String groupDomain;
    private final String domainVerificationArn;

    private CreateResourceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.resourceGatewayId = builder.resourceGatewayId;
        this.resourceConfigurationGroupId = builder.resourceConfigurationGroupId;
        this.type = builder.type;
        this.portRanges = builder.portRanges;
        this.protocol = builder.protocol;
        this.status = builder.status;
        this.resourceConfigurationDefinition = builder.resourceConfigurationDefinition;
        this.allowAssociationToShareableServiceNetwork = builder.allowAssociationToShareableServiceNetwork;
        this.createdAt = builder.createdAt;
        this.failureReason = builder.failureReason;
        this.customDomainName = builder.customDomainName;
        this.domainVerificationId = builder.domainVerificationId;
        this.groupDomain = builder.groupDomain;
        this.domainVerificationArn = builder.domainVerificationArn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String resourceGatewayId() {
        return this.resourceGatewayId;
    }

    public final String resourceConfigurationGroupId() {
        return this.resourceConfigurationGroupId;
    }

    public final ResourceConfigurationType type() {
        return ResourceConfigurationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<String> portRanges() {
        return this.portRanges;
    }

    public final ProtocolType protocol() {
        return ProtocolType.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final ResourceConfigurationStatus status() {
        return ResourceConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ResourceConfigurationDefinition resourceConfigurationDefinition() {
        return this.resourceConfigurationDefinition;
    }

    public final Boolean allowAssociationToShareableServiceNetwork() {
        return this.allowAssociationToShareableServiceNetwork;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    public final String domainVerificationId() {
        return this.domainVerificationId;
    }

    public final String groupDomain() {
        return this.groupDomain;
    }

    public final String domainVerificationArn() {
        return this.domainVerificationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowAssociationToShareableServiceNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainVerificationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainVerificationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceConfigurationResponse)) {
            return false;
        }
        CreateResourceConfigurationResponse other = (CreateResourceConfigurationResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.resourceGatewayId(), other.resourceGatewayId()) && Objects.equals(this.resourceConfigurationGroupId(), other.resourceConfigurationGroupId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resourceConfigurationDefinition(), other.resourceConfigurationDefinition()) && Objects.equals(this.allowAssociationToShareableServiceNetwork(), other.allowAssociationToShareableServiceNetwork()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.customDomainName(), other.customDomainName()) && Objects.equals(this.domainVerificationId(), other.domainVerificationId()) && Objects.equals(this.groupDomain(), other.groupDomain()) && Objects.equals(this.domainVerificationArn(), other.domainVerificationArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourceConfigurationResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("ResourceGatewayId", (Object)this.resourceGatewayId()).add("ResourceConfigurationGroupId", (Object)this.resourceConfigurationGroupId()).add("Type", (Object)this.typeAsString()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).add("Protocol", (Object)this.protocolAsString()).add("Status", (Object)this.statusAsString()).add("ResourceConfigurationDefinition", (Object)this.resourceConfigurationDefinition()).add("AllowAssociationToShareableServiceNetwork", (Object)this.allowAssociationToShareableServiceNetwork()).add("CreatedAt", (Object)this.createdAt()).add("FailureReason", (Object)this.failureReason()).add("CustomDomainName", (Object)this.customDomainName()).add("DomainVerificationId", (Object)this.domainVerificationId()).add("GroupDomain", (Object)this.groupDomain()).add("DomainVerificationArn", (Object)this.domainVerificationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "resourceGatewayId": {
                return Optional.ofNullable(clazz.cast(this.resourceGatewayId()));
            }
            case "resourceConfigurationGroupId": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationGroupId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "portRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "resourceConfigurationDefinition": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationDefinition()));
            }
            case "allowAssociationToShareableServiceNetwork": {
                return Optional.ofNullable(clazz.cast(this.allowAssociationToShareableServiceNetwork()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "customDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
            case "domainVerificationId": {
                return Optional.ofNullable(clazz.cast(this.domainVerificationId()));
            }
            case "groupDomain": {
                return Optional.ofNullable(clazz.cast(this.groupDomain()));
            }
            case "domainVerificationArn": {
                return Optional.ofNullable(clazz.cast(this.domainVerificationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("resourceGatewayId", RESOURCE_GATEWAY_ID_FIELD);
        map.put("resourceConfigurationGroupId", RESOURCE_CONFIGURATION_GROUP_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("portRanges", PORT_RANGES_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resourceConfigurationDefinition", RESOURCE_CONFIGURATION_DEFINITION_FIELD);
        map.put("allowAssociationToShareableServiceNetwork", ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("domainVerificationId", DOMAIN_VERIFICATION_ID_FIELD);
        map.put("groupDomain", GROUP_DOMAIN_FIELD);
        map.put("domainVerificationArn", DOMAIN_VERIFICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceConfigurationResponse, T> g) {
        return obj -> g.apply((CreateResourceConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private String resourceGatewayId;
        private String resourceConfigurationGroupId;
        private String type;
        private List<String> portRanges = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private String status;
        private ResourceConfigurationDefinition resourceConfigurationDefinition;
        private Boolean allowAssociationToShareableServiceNetwork;
        private Instant createdAt;
        private String failureReason;
        private String customDomainName;
        private String domainVerificationId;
        private String groupDomain;
        private String domainVerificationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceConfigurationResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.resourceGatewayId(model.resourceGatewayId);
            this.resourceConfigurationGroupId(model.resourceConfigurationGroupId);
            this.type(model.type);
            this.portRanges(model.portRanges);
            this.protocol(model.protocol);
            this.status(model.status);
            this.resourceConfigurationDefinition(model.resourceConfigurationDefinition);
            this.allowAssociationToShareableServiceNetwork(model.allowAssociationToShareableServiceNetwork);
            this.createdAt(model.createdAt);
            this.failureReason(model.failureReason);
            this.customDomainName(model.customDomainName);
            this.domainVerificationId(model.domainVerificationId);
            this.groupDomain(model.groupDomain);
            this.domainVerificationArn(model.domainVerificationArn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResourceGatewayId() {
            return this.resourceGatewayId;
        }

        public final void setResourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
        }

        @Override
        public final Builder resourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
            return this;
        }

        public final String getResourceConfigurationGroupId() {
            return this.resourceConfigurationGroupId;
        }

        public final void setResourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
        }

        @Override
        public final Builder resourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getPortRanges() {
            if (this.portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.portRanges;
        }

        public final void setPortRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(String ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolType protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ResourceConfigurationDefinition.Builder getResourceConfigurationDefinition() {
            return this.resourceConfigurationDefinition != null ? this.resourceConfigurationDefinition.toBuilder() : null;
        }

        public final void setResourceConfigurationDefinition(ResourceConfigurationDefinition.BuilderImpl resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition != null ? resourceConfigurationDefinition.build() : null;
        }

        @Override
        public final Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        public final Boolean getAllowAssociationToShareableServiceNetwork() {
            return this.allowAssociationToShareableServiceNetwork;
        }

        public final void setAllowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
        }

        @Override
        public final Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getDomainVerificationId() {
            return this.domainVerificationId;
        }

        public final void setDomainVerificationId(String domainVerificationId) {
            this.domainVerificationId = domainVerificationId;
        }

        @Override
        public final Builder domainVerificationId(String domainVerificationId) {
            this.domainVerificationId = domainVerificationId;
            return this;
        }

        public final String getGroupDomain() {
            return this.groupDomain;
        }

        public final void setGroupDomain(String groupDomain) {
            this.groupDomain = groupDomain;
        }

        @Override
        public final Builder groupDomain(String groupDomain) {
            this.groupDomain = groupDomain;
            return this;
        }

        public final String getDomainVerificationArn() {
            return this.domainVerificationArn;
        }

        public final void setDomainVerificationArn(String domainVerificationArn) {
            this.domainVerificationArn = domainVerificationArn;
        }

        @Override
        public final Builder domainVerificationArn(String domainVerificationArn) {
            this.domainVerificationArn = domainVerificationArn;
            return this;
        }

        @Override
        public CreateResourceConfigurationResponse build() {
            return new CreateResourceConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceConfigurationResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder resourceGatewayId(String var1);

        public Builder resourceConfigurationGroupId(String var1);

        public Builder type(String var1);

        public Builder type(ResourceConfigurationType var1);

        public Builder portRanges(Collection<String> var1);

        public Builder portRanges(String ... var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolType var1);

        public Builder status(String var1);

        public Builder status(ResourceConfigurationStatus var1);

        public Builder resourceConfigurationDefinition(ResourceConfigurationDefinition var1);

        default public Builder resourceConfigurationDefinition(Consumer<ResourceConfigurationDefinition.Builder> resourceConfigurationDefinition) {
            return this.resourceConfigurationDefinition((ResourceConfigurationDefinition)((ResourceConfigurationDefinition.Builder)ResourceConfigurationDefinition.builder().applyMutation(resourceConfigurationDefinition)).build());
        }

        public Builder allowAssociationToShareableServiceNetwork(Boolean var1);

        public Builder createdAt(Instant var1);

        public Builder failureReason(String var1);

        public Builder customDomainName(String var1);

        public Builder domainVerificationId(String var1);

        public Builder groupDomain(String var1);

        public Builder domainVerificationArn(String var1);
    }
}

