/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.DnsOptions;
import software.amazon.awssdk.services.vpclattice.model.SecurityGroupListCopier;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkVpcAssociationStatus;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceNetworkVpcAssociationResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, CreateServiceNetworkVpcAssociationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateServiceNetworkVpcAssociationResponse.getter(CreateServiceNetworkVpcAssociationResponse::id)).setter(CreateServiceNetworkVpcAssociationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateServiceNetworkVpcAssociationResponse.getter(CreateServiceNetworkVpcAssociationResponse::statusAsString)).setter(CreateServiceNetworkVpcAssociationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateServiceNetworkVpcAssociationResponse.getter(CreateServiceNetworkVpcAssociationResponse::arn)).setter(CreateServiceNetworkVpcAssociationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(CreateServiceNetworkVpcAssociationResponse.getter(CreateServiceNetworkVpcAssociationResponse::createdBy)).setter(CreateServiceNetworkVpcAssociationResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(CreateServiceNetworkVpcAssociationResponse.getter(CreateServiceNetworkVpcAssociationResponse::securityGroupIds)).setter(CreateServiceNetworkVpcAssociationResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("privateDnsEnabled").getter(CreateServiceNetworkVpcAssociationResponse.getter(CreateServiceNetworkVpcAssociationResponse::privateDnsEnabled)).setter(CreateServiceNetworkVpcAssociationResponse.setter(Builder::privateDnsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsEnabled").build()}).build();
    private static final SdkField<DnsOptions> DNS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsOptions").getter(CreateServiceNetworkVpcAssociationResponse.getter(CreateServiceNetworkVpcAssociationResponse::dnsOptions)).setter(CreateServiceNetworkVpcAssociationResponse.setter(Builder::dnsOptions)).constructor(DnsOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD, ARN_FIELD, CREATED_BY_FIELD, SECURITY_GROUP_IDS_FIELD, PRIVATE_DNS_ENABLED_FIELD, DNS_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateServiceNetworkVpcAssociationResponse.memberNameToFieldInitializer();
    private final String id;
    private final String status;
    private final String arn;
    private final String createdBy;
    private final List<String> securityGroupIds;
    private final Boolean privateDnsEnabled;
    private final DnsOptions dnsOptions;

    private CreateServiceNetworkVpcAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.status = builder.status;
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.securityGroupIds = builder.securityGroupIds;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.dnsOptions = builder.dnsOptions;
    }

    public final String id() {
        return this.id;
    }

    public final ServiceNetworkVpcAssociationStatus status() {
        return ServiceNetworkVpcAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final Boolean privateDnsEnabled() {
        return this.privateDnsEnabled;
    }

    public final DnsOptions dnsOptions() {
        return this.dnsOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceNetworkVpcAssociationResponse)) {
            return false;
        }
        CreateServiceNetworkVpcAssociationResponse other = (CreateServiceNetworkVpcAssociationResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdBy(), other.createdBy()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.privateDnsEnabled(), other.privateDnsEnabled()) && Objects.equals(this.dnsOptions(), other.dnsOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceNetworkVpcAssociationResponse").add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("Arn", (Object)this.arn()).add("CreatedBy", (Object)this.createdBy()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("PrivateDnsEnabled", (Object)this.privateDnsEnabled()).add("DnsOptions", (Object)this.dnsOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "privateDnsEnabled": {
                return Optional.ofNullable(clazz.cast(this.privateDnsEnabled()));
            }
            case "dnsOptions": {
                return Optional.ofNullable(clazz.cast(this.dnsOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("privateDnsEnabled", PRIVATE_DNS_ENABLED_FIELD);
        map.put("dnsOptions", DNS_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceNetworkVpcAssociationResponse, T> g) {
        return obj -> g.apply((CreateServiceNetworkVpcAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private String arn;
        private String createdBy;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean privateDnsEnabled;
        private DnsOptions dnsOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceNetworkVpcAssociationResponse model) {
            super(model);
            this.id(model.id);
            this.status(model.status);
            this.arn(model.arn);
            this.createdBy(model.createdBy);
            this.securityGroupIds(model.securityGroupIds);
            this.privateDnsEnabled(model.privateDnsEnabled);
            this.dnsOptions(model.dnsOptions);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkVpcAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final DnsOptions.Builder getDnsOptions() {
            return this.dnsOptions != null ? this.dnsOptions.toBuilder() : null;
        }

        public final void setDnsOptions(DnsOptions.BuilderImpl dnsOptions) {
            this.dnsOptions = dnsOptions != null ? dnsOptions.build() : null;
        }

        @Override
        public final Builder dnsOptions(DnsOptions dnsOptions) {
            this.dnsOptions = dnsOptions;
            return this;
        }

        @Override
        public CreateServiceNetworkVpcAssociationResponse build() {
            return new CreateServiceNetworkVpcAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceNetworkVpcAssociationResponse> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ServiceNetworkVpcAssociationStatus var1);

        public Builder arn(String var1);

        public Builder createdBy(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder privateDnsEnabled(Boolean var1);

        public Builder dnsOptions(DnsOptions var1);

        default public Builder dnsOptions(Consumer<DnsOptions.Builder> dnsOptions) {
            return this.dnsOptions((DnsOptions)((DnsOptions.Builder)DnsOptions.builder().applyMutation(dnsOptions)).build());
        }
    }
}

