/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRuleRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, DeleteRuleRequest> {
    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceIdentifier").getter(DeleteRuleRequest.getter(DeleteRuleRequest::serviceIdentifier)).setter(DeleteRuleRequest.setter(Builder::serviceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()}).build();
    private static final SdkField<String> LISTENER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listenerIdentifier").getter(DeleteRuleRequest.getter(DeleteRuleRequest::listenerIdentifier)).setter(DeleteRuleRequest.setter(Builder::listenerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("listenerIdentifier").build()}).build();
    private static final SdkField<String> RULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleIdentifier").getter(DeleteRuleRequest.getter(DeleteRuleRequest::ruleIdentifier)).setter(DeleteRuleRequest.setter(Builder::ruleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ruleIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_IDENTIFIER_FIELD, LISTENER_IDENTIFIER_FIELD, RULE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteRuleRequest.memberNameToFieldInitializer();
    private final String serviceIdentifier;
    private final String listenerIdentifier;
    private final String ruleIdentifier;

    private DeleteRuleRequest(BuilderImpl builder) {
        super(builder);
        this.serviceIdentifier = builder.serviceIdentifier;
        this.listenerIdentifier = builder.listenerIdentifier;
        this.ruleIdentifier = builder.ruleIdentifier;
    }

    public final String serviceIdentifier() {
        return this.serviceIdentifier;
    }

    public final String listenerIdentifier() {
        return this.listenerIdentifier;
    }

    public final String ruleIdentifier() {
        return this.ruleIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRuleRequest)) {
            return false;
        }
        DeleteRuleRequest other = (DeleteRuleRequest)((Object)obj);
        return Objects.equals(this.serviceIdentifier(), other.serviceIdentifier()) && Objects.equals(this.listenerIdentifier(), other.listenerIdentifier()) && Objects.equals(this.ruleIdentifier(), other.ruleIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRuleRequest").add("ServiceIdentifier", (Object)this.serviceIdentifier()).add("ListenerIdentifier", (Object)this.listenerIdentifier()).add("RuleIdentifier", (Object)this.ruleIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serviceIdentifier()));
            }
            case "listenerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.listenerIdentifier()));
            }
            case "ruleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ruleIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("serviceIdentifier", SERVICE_IDENTIFIER_FIELD);
        map.put("listenerIdentifier", LISTENER_IDENTIFIER_FIELD);
        map.put("ruleIdentifier", RULE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRuleRequest, T> g) {
        return obj -> g.apply((DeleteRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private String serviceIdentifier;
        private String listenerIdentifier;
        private String ruleIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRuleRequest model) {
            super(model);
            this.serviceIdentifier(model.serviceIdentifier);
            this.listenerIdentifier(model.listenerIdentifier);
            this.ruleIdentifier(model.ruleIdentifier);
        }

        public final String getServiceIdentifier() {
            return this.serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        public final String getListenerIdentifier() {
            return this.listenerIdentifier;
        }

        public final void setListenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
        }

        @Override
        public final Builder listenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
            return this;
        }

        public final String getRuleIdentifier() {
            return this.ruleIdentifier;
        }

        public final void setRuleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
        }

        @Override
        public final Builder ruleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRuleRequest build() {
            return new DeleteRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRuleRequest> {
        public Builder serviceIdentifier(String var1);

        public Builder listenerIdentifier(String var1);

        public Builder ruleIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

