/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkVpcAssociationStatus;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteServiceNetworkVpcAssociationResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, DeleteServiceNetworkVpcAssociationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DeleteServiceNetworkVpcAssociationResponse.getter(DeleteServiceNetworkVpcAssociationResponse::id)).setter(DeleteServiceNetworkVpcAssociationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteServiceNetworkVpcAssociationResponse.getter(DeleteServiceNetworkVpcAssociationResponse::statusAsString)).setter(DeleteServiceNetworkVpcAssociationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DeleteServiceNetworkVpcAssociationResponse.getter(DeleteServiceNetworkVpcAssociationResponse::arn)).setter(DeleteServiceNetworkVpcAssociationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteServiceNetworkVpcAssociationResponse.memberNameToFieldInitializer();
    private final String id;
    private final String status;
    private final String arn;

    private DeleteServiceNetworkVpcAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.status = builder.status;
        this.arn = builder.arn;
    }

    public final String id() {
        return this.id;
    }

    public final ServiceNetworkVpcAssociationStatus status() {
        return ServiceNetworkVpcAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceNetworkVpcAssociationResponse)) {
            return false;
        }
        DeleteServiceNetworkVpcAssociationResponse other = (DeleteServiceNetworkVpcAssociationResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteServiceNetworkVpcAssociationResponse").add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteServiceNetworkVpcAssociationResponse, T> g) {
        return obj -> g.apply((DeleteServiceNetworkVpcAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceNetworkVpcAssociationResponse model) {
            super(model);
            this.id(model.id);
            this.status(model.status);
            this.arn(model.arn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkVpcAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public DeleteServiceNetworkVpcAssociationResponse build() {
            return new DeleteServiceNetworkVpcAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteServiceNetworkVpcAssociationResponse> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ServiceNetworkVpcAssociationStatus var1);

        public Builder arn(String var1);
    }
}

