/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.PrivateDnsPreference;
import software.amazon.awssdk.services.vpclattice.model.PrivateDnsSpecifiedDomainsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsOptions> {
    private static final SdkField<String> PRIVATE_DNS_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateDnsPreference").getter(DnsOptions.getter(DnsOptions::privateDnsPreferenceAsString)).setter(DnsOptions.setter(Builder::privateDnsPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsPreference").build()}).build();
    private static final SdkField<List<String>> PRIVATE_DNS_SPECIFIED_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("privateDnsSpecifiedDomains").getter(DnsOptions.getter(DnsOptions::privateDnsSpecifiedDomains)).setter(DnsOptions.setter(Builder::privateDnsSpecifiedDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsSpecifiedDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_DNS_PREFERENCE_FIELD, PRIVATE_DNS_SPECIFIED_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DnsOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String privateDnsPreference;
    private final List<String> privateDnsSpecifiedDomains;

    private DnsOptions(BuilderImpl builder) {
        this.privateDnsPreference = builder.privateDnsPreference;
        this.privateDnsSpecifiedDomains = builder.privateDnsSpecifiedDomains;
    }

    public final PrivateDnsPreference privateDnsPreference() {
        return PrivateDnsPreference.fromValue(this.privateDnsPreference);
    }

    public final String privateDnsPreferenceAsString() {
        return this.privateDnsPreference;
    }

    public final boolean hasPrivateDnsSpecifiedDomains() {
        return this.privateDnsSpecifiedDomains != null && !(this.privateDnsSpecifiedDomains instanceof SdkAutoConstructList);
    }

    public final List<String> privateDnsSpecifiedDomains() {
        return this.privateDnsSpecifiedDomains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateDnsSpecifiedDomains() ? this.privateDnsSpecifiedDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsOptions)) {
            return false;
        }
        DnsOptions other = (DnsOptions)obj;
        return Objects.equals(this.privateDnsPreferenceAsString(), other.privateDnsPreferenceAsString()) && this.hasPrivateDnsSpecifiedDomains() == other.hasPrivateDnsSpecifiedDomains() && Objects.equals(this.privateDnsSpecifiedDomains(), other.privateDnsSpecifiedDomains());
    }

    public final String toString() {
        return ToString.builder((String)"DnsOptions").add("PrivateDnsPreference", (Object)this.privateDnsPreferenceAsString()).add("PrivateDnsSpecifiedDomains", this.hasPrivateDnsSpecifiedDomains() ? this.privateDnsSpecifiedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "privateDnsPreference": {
                return Optional.ofNullable(clazz.cast(this.privateDnsPreferenceAsString()));
            }
            case "privateDnsSpecifiedDomains": {
                return Optional.ofNullable(clazz.cast(this.privateDnsSpecifiedDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("privateDnsPreference", PRIVATE_DNS_PREFERENCE_FIELD);
        map.put("privateDnsSpecifiedDomains", PRIVATE_DNS_SPECIFIED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsOptions, T> g) {
        return obj -> g.apply((DnsOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String privateDnsPreference;
        private List<String> privateDnsSpecifiedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DnsOptions model) {
            this.privateDnsPreference(model.privateDnsPreference);
            this.privateDnsSpecifiedDomains(model.privateDnsSpecifiedDomains);
        }

        public final String getPrivateDnsPreference() {
            return this.privateDnsPreference;
        }

        public final void setPrivateDnsPreference(String privateDnsPreference) {
            this.privateDnsPreference = privateDnsPreference;
        }

        @Override
        public final Builder privateDnsPreference(String privateDnsPreference) {
            this.privateDnsPreference = privateDnsPreference;
            return this;
        }

        @Override
        public final Builder privateDnsPreference(PrivateDnsPreference privateDnsPreference) {
            this.privateDnsPreference(privateDnsPreference == null ? null : privateDnsPreference.toString());
            return this;
        }

        public final Collection<String> getPrivateDnsSpecifiedDomains() {
            if (this.privateDnsSpecifiedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.privateDnsSpecifiedDomains;
        }

        public final void setPrivateDnsSpecifiedDomains(Collection<String> privateDnsSpecifiedDomains) {
            this.privateDnsSpecifiedDomains = PrivateDnsSpecifiedDomainsListCopier.copy(privateDnsSpecifiedDomains);
        }

        @Override
        public final Builder privateDnsSpecifiedDomains(Collection<String> privateDnsSpecifiedDomains) {
            this.privateDnsSpecifiedDomains = PrivateDnsSpecifiedDomainsListCopier.copy(privateDnsSpecifiedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateDnsSpecifiedDomains(String ... privateDnsSpecifiedDomains) {
            this.privateDnsSpecifiedDomains(Arrays.asList(privateDnsSpecifiedDomains));
            return this;
        }

        public DnsOptions build() {
            return new DnsOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsOptions> {
        public Builder privateDnsPreference(String var1);

        public Builder privateDnsPreference(PrivateDnsPreference var1);

        public Builder privateDnsSpecifiedDomains(Collection<String> var1);

        public Builder privateDnsSpecifiedDomains(String ... var1);
    }
}

