/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.AuthType;
import software.amazon.awssdk.services.vpclattice.model.SharingConfig;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceNetworkResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, GetServiceNetworkResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetServiceNetworkResponse.getter(GetServiceNetworkResponse::id)).setter(GetServiceNetworkResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetServiceNetworkResponse.getter(GetServiceNetworkResponse::name)).setter(GetServiceNetworkResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetServiceNetworkResponse.getter(GetServiceNetworkResponse::createdAt)).setter(GetServiceNetworkResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetServiceNetworkResponse.getter(GetServiceNetworkResponse::lastUpdatedAt)).setter(GetServiceNetworkResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetServiceNetworkResponse.getter(GetServiceNetworkResponse::arn)).setter(GetServiceNetworkResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(GetServiceNetworkResponse.getter(GetServiceNetworkResponse::authTypeAsString)).setter(GetServiceNetworkResponse.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<SharingConfig> SHARING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sharingConfig").getter(GetServiceNetworkResponse.getter(GetServiceNetworkResponse::sharingConfig)).setter(GetServiceNetworkResponse.setter(Builder::sharingConfig)).constructor(SharingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharingConfig").build()}).build();
    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_VP_CS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfAssociatedVPCs").getter(GetServiceNetworkResponse.getter(GetServiceNetworkResponse::numberOfAssociatedVPCs)).setter(GetServiceNetworkResponse.setter(Builder::numberOfAssociatedVPCs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfAssociatedVPCs").build()}).build();
    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfAssociatedServices").getter(GetServiceNetworkResponse.getter(GetServiceNetworkResponse::numberOfAssociatedServices)).setter(GetServiceNetworkResponse.setter(Builder::numberOfAssociatedServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfAssociatedServices").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, ARN_FIELD, AUTH_TYPE_FIELD, SHARING_CONFIG_FIELD, NUMBER_OF_ASSOCIATED_VP_CS_FIELD, NUMBER_OF_ASSOCIATED_SERVICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetServiceNetworkResponse.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String arn;
    private final String authType;
    private final SharingConfig sharingConfig;
    private final Long numberOfAssociatedVPCs;
    private final Long numberOfAssociatedServices;

    private GetServiceNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.arn = builder.arn;
        this.authType = builder.authType;
        this.sharingConfig = builder.sharingConfig;
        this.numberOfAssociatedVPCs = builder.numberOfAssociatedVPCs;
        this.numberOfAssociatedServices = builder.numberOfAssociatedServices;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final SharingConfig sharingConfig() {
        return this.sharingConfig;
    }

    public final Long numberOfAssociatedVPCs() {
        return this.numberOfAssociatedVPCs;
    }

    public final Long numberOfAssociatedServices() {
        return this.numberOfAssociatedServices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssociatedVPCs());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssociatedServices());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceNetworkResponse)) {
            return false;
        }
        GetServiceNetworkResponse other = (GetServiceNetworkResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.sharingConfig(), other.sharingConfig()) && Objects.equals(this.numberOfAssociatedVPCs(), other.numberOfAssociatedVPCs()) && Objects.equals(this.numberOfAssociatedServices(), other.numberOfAssociatedServices());
    }

    public final String toString() {
        return ToString.builder((String)"GetServiceNetworkResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Arn", (Object)this.arn()).add("AuthType", (Object)this.authTypeAsString()).add("SharingConfig", (Object)this.sharingConfig()).add("NumberOfAssociatedVPCs", (Object)this.numberOfAssociatedVPCs()).add("NumberOfAssociatedServices", (Object)this.numberOfAssociatedServices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "sharingConfig": {
                return Optional.ofNullable(clazz.cast(this.sharingConfig()));
            }
            case "numberOfAssociatedVPCs": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssociatedVPCs()));
            }
            case "numberOfAssociatedServices": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssociatedServices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("sharingConfig", SHARING_CONFIG_FIELD);
        map.put("numberOfAssociatedVPCs", NUMBER_OF_ASSOCIATED_VP_CS_FIELD);
        map.put("numberOfAssociatedServices", NUMBER_OF_ASSOCIATED_SERVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceNetworkResponse, T> g) {
        return obj -> g.apply((GetServiceNetworkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String arn;
        private String authType;
        private SharingConfig sharingConfig;
        private Long numberOfAssociatedVPCs;
        private Long numberOfAssociatedServices;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceNetworkResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.arn(model.arn);
            this.authType(model.authType);
            this.sharingConfig(model.sharingConfig);
            this.numberOfAssociatedVPCs(model.numberOfAssociatedVPCs);
            this.numberOfAssociatedServices(model.numberOfAssociatedServices);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final SharingConfig.Builder getSharingConfig() {
            return this.sharingConfig != null ? this.sharingConfig.toBuilder() : null;
        }

        public final void setSharingConfig(SharingConfig.BuilderImpl sharingConfig) {
            this.sharingConfig = sharingConfig != null ? sharingConfig.build() : null;
        }

        @Override
        public final Builder sharingConfig(SharingConfig sharingConfig) {
            this.sharingConfig = sharingConfig;
            return this;
        }

        public final Long getNumberOfAssociatedVPCs() {
            return this.numberOfAssociatedVPCs;
        }

        public final void setNumberOfAssociatedVPCs(Long numberOfAssociatedVPCs) {
            this.numberOfAssociatedVPCs = numberOfAssociatedVPCs;
        }

        @Override
        public final Builder numberOfAssociatedVPCs(Long numberOfAssociatedVPCs) {
            this.numberOfAssociatedVPCs = numberOfAssociatedVPCs;
            return this;
        }

        public final Long getNumberOfAssociatedServices() {
            return this.numberOfAssociatedServices;
        }

        public final void setNumberOfAssociatedServices(Long numberOfAssociatedServices) {
            this.numberOfAssociatedServices = numberOfAssociatedServices;
        }

        @Override
        public final Builder numberOfAssociatedServices(Long numberOfAssociatedServices) {
            this.numberOfAssociatedServices = numberOfAssociatedServices;
            return this;
        }

        @Override
        public GetServiceNetworkResponse build() {
            return new GetServiceNetworkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceNetworkResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder arn(String var1);

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder sharingConfig(SharingConfig var1);

        default public Builder sharingConfig(Consumer<SharingConfig.Builder> sharingConfig) {
            return this.sharingConfig((SharingConfig)((SharingConfig.Builder)SharingConfig.builder().applyMutation(sharingConfig)).build());
        }

        public Builder numberOfAssociatedVPCs(Long var1);

        public Builder numberOfAssociatedServices(Long var1);
    }
}

