/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceConfigurationIpAddressType {
    IPV4("IPV4"),
    IPV6("IPV6"),
    DUALSTACK("DUALSTACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceConfigurationIpAddressType> VALUE_MAP;
    private final String value;

    private ResourceConfigurationIpAddressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceConfigurationIpAddressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceConfigurationIpAddressType> knownValues() {
        EnumSet<ResourceConfigurationIpAddressType> knownValues = EnumSet.allOf(ResourceConfigurationIpAddressType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceConfigurationIpAddressType.class, ResourceConfigurationIpAddressType::toString);
    }
}

