/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.DnsEntry;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceNetworkServiceAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceNetworkServiceAssociationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::id)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::statusAsString)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::arn)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::createdBy)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::createdAt)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceId").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceId)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceId").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceName)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceArn)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkId").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceNetworkId)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkId").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkName").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceNetworkName)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceNetworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkName").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkArn").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::serviceNetworkArn)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::serviceNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()}).build();
    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsEntry").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::dnsEntry)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::dnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsEntry").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDomainName").getter(ServiceNetworkServiceAssociationSummary.getter(ServiceNetworkServiceAssociationSummary::customDomainName)).setter(ServiceNetworkServiceAssociationSummary.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD, ARN_FIELD, CREATED_BY_FIELD, CREATED_AT_FIELD, SERVICE_ID_FIELD, SERVICE_NAME_FIELD, SERVICE_ARN_FIELD, SERVICE_NETWORK_ID_FIELD, SERVICE_NETWORK_NAME_FIELD, SERVICE_NETWORK_ARN_FIELD, DNS_ENTRY_FIELD, CUSTOM_DOMAIN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceNetworkServiceAssociationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String status;
    private final String arn;
    private final String createdBy;
    private final Instant createdAt;
    private final String serviceId;
    private final String serviceName;
    private final String serviceArn;
    private final String serviceNetworkId;
    private final String serviceNetworkName;
    private final String serviceNetworkArn;
    private final DnsEntry dnsEntry;
    private final String customDomainName;

    private ServiceNetworkServiceAssociationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.serviceId = builder.serviceId;
        this.serviceName = builder.serviceName;
        this.serviceArn = builder.serviceArn;
        this.serviceNetworkId = builder.serviceNetworkId;
        this.serviceNetworkName = builder.serviceNetworkName;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.dnsEntry = builder.dnsEntry;
        this.customDomainName = builder.customDomainName;
    }

    public final String id() {
        return this.id;
    }

    public final ServiceNetworkServiceAssociationStatus status() {
        return ServiceNetworkServiceAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String serviceNetworkId() {
        return this.serviceNetworkId;
    }

    public final String serviceNetworkName() {
        return this.serviceNetworkName;
    }

    public final String serviceNetworkArn() {
        return this.serviceNetworkArn;
    }

    public final DnsEntry dnsEntry() {
        return this.dnsEntry;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNetworkServiceAssociationSummary)) {
            return false;
        }
        ServiceNetworkServiceAssociationSummary other = (ServiceNetworkServiceAssociationSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.serviceNetworkId(), other.serviceNetworkId()) && Objects.equals(this.serviceNetworkName(), other.serviceNetworkName()) && Objects.equals(this.serviceNetworkArn(), other.serviceNetworkArn()) && Objects.equals(this.dnsEntry(), other.dnsEntry()) && Objects.equals(this.customDomainName(), other.customDomainName());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceNetworkServiceAssociationSummary").add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("Arn", (Object)this.arn()).add("CreatedBy", (Object)this.createdBy()).add("CreatedAt", (Object)this.createdAt()).add("ServiceId", (Object)this.serviceId()).add("ServiceName", (Object)this.serviceName()).add("ServiceArn", (Object)this.serviceArn()).add("ServiceNetworkId", (Object)this.serviceNetworkId()).add("ServiceNetworkName", (Object)this.serviceNetworkName()).add("ServiceNetworkArn", (Object)this.serviceNetworkArn()).add("DnsEntry", (Object)this.dnsEntry()).add("CustomDomainName", (Object)this.customDomainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "serviceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "serviceNetworkId": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkId()));
            }
            case "serviceNetworkName": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkName()));
            }
            case "serviceNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkArn()));
            }
            case "dnsEntry": {
                return Optional.ofNullable(clazz.cast(this.dnsEntry()));
            }
            case "customDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("serviceId", SERVICE_ID_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("serviceNetworkId", SERVICE_NETWORK_ID_FIELD);
        map.put("serviceNetworkName", SERVICE_NETWORK_NAME_FIELD);
        map.put("serviceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("dnsEntry", DNS_ENTRY_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceNetworkServiceAssociationSummary, T> g) {
        return obj -> g.apply((ServiceNetworkServiceAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private String arn;
        private String createdBy;
        private Instant createdAt;
        private String serviceId;
        private String serviceName;
        private String serviceArn;
        private String serviceNetworkId;
        private String serviceNetworkName;
        private String serviceNetworkArn;
        private DnsEntry dnsEntry;
        private String customDomainName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNetworkServiceAssociationSummary model) {
            this.id(model.id);
            this.status(model.status);
            this.arn(model.arn);
            this.createdBy(model.createdBy);
            this.createdAt(model.createdAt);
            this.serviceId(model.serviceId);
            this.serviceName(model.serviceName);
            this.serviceArn(model.serviceArn);
            this.serviceNetworkId(model.serviceNetworkId);
            this.serviceNetworkName(model.serviceNetworkName);
            this.serviceNetworkArn(model.serviceNetworkArn);
            this.dnsEntry(model.dnsEntry);
            this.customDomainName(model.customDomainName);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkServiceAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getServiceNetworkId() {
            return this.serviceNetworkId;
        }

        public final void setServiceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
        }

        @Override
        public final Builder serviceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
            return this;
        }

        public final String getServiceNetworkName() {
            return this.serviceNetworkName;
        }

        public final void setServiceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
        }

        @Override
        public final Builder serviceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
            return this;
        }

        public final String getServiceNetworkArn() {
            return this.serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return this.dnsEntry != null ? this.dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public ServiceNetworkServiceAssociationSummary build() {
            return new ServiceNetworkServiceAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceNetworkServiceAssociationSummary> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ServiceNetworkServiceAssociationStatus var1);

        public Builder arn(String var1);

        public Builder createdBy(String var1);

        public Builder createdAt(Instant var1);

        public Builder serviceId(String var1);

        public Builder serviceName(String var1);

        public Builder serviceArn(String var1);

        public Builder serviceNetworkId(String var1);

        public Builder serviceNetworkName(String var1);

        public Builder serviceNetworkArn(String var1);

        public Builder dnsEntry(DnsEntry var1);

        default public Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return this.dnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(dnsEntry)).build());
        }

        public Builder customDomainName(String var1);
    }
}

