/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.ListenerProtocol;
import software.amazon.awssdk.services.vpclattice.model.RuleAction;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateListenerResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, UpdateListenerResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateListenerResponse.getter(UpdateListenerResponse::arn)).setter(UpdateListenerResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateListenerResponse.getter(UpdateListenerResponse::id)).setter(UpdateListenerResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateListenerResponse.getter(UpdateListenerResponse::name)).setter(UpdateListenerResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(UpdateListenerResponse.getter(UpdateListenerResponse::protocolAsString)).setter(UpdateListenerResponse.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(UpdateListenerResponse.getter(UpdateListenerResponse::port)).setter(UpdateListenerResponse.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(UpdateListenerResponse.getter(UpdateListenerResponse::serviceArn)).setter(UpdateListenerResponse.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceId").getter(UpdateListenerResponse.getter(UpdateListenerResponse::serviceId)).setter(UpdateListenerResponse.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceId").build()}).build();
    private static final SdkField<RuleAction> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultAction").getter(UpdateListenerResponse.getter(UpdateListenerResponse::defaultAction)).setter(UpdateListenerResponse.setter(Builder::defaultAction)).constructor(RuleAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, PROTOCOL_FIELD, PORT_FIELD, SERVICE_ARN_FIELD, SERVICE_ID_FIELD, DEFAULT_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateListenerResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String id;
    private final String name;
    private final String protocol;
    private final Integer port;
    private final String serviceArn;
    private final String serviceId;
    private final RuleAction defaultAction;

    private UpdateListenerResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.serviceArn = builder.serviceArn;
        this.serviceId = builder.serviceId;
        this.defaultAction = builder.defaultAction;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final ListenerProtocol protocol() {
        return ListenerProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer port() {
        return this.port;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final RuleAction defaultAction() {
        return this.defaultAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateListenerResponse)) {
            return false;
        }
        UpdateListenerResponse other = (UpdateListenerResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.defaultAction(), other.defaultAction());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateListenerResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Protocol", (Object)this.protocolAsString()).add("Port", (Object)this.port()).add("ServiceArn", (Object)this.serviceArn()).add("ServiceId", (Object)this.serviceId()).add("DefaultAction", (Object)this.defaultAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "serviceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "defaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("port", PORT_FIELD);
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("serviceId", SERVICE_ID_FIELD);
        map.put("defaultAction", DEFAULT_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateListenerResponse, T> g) {
        return obj -> g.apply((UpdateListenerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private String protocol;
        private Integer port;
        private String serviceArn;
        private String serviceId;
        private RuleAction defaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateListenerResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.protocol(model.protocol);
            this.port(model.port);
            this.serviceArn(model.serviceArn);
            this.serviceId(model.serviceId);
            this.defaultAction(model.defaultAction);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ListenerProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final RuleAction.Builder getDefaultAction() {
            return this.defaultAction != null ? this.defaultAction.toBuilder() : null;
        }

        public final void setDefaultAction(RuleAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        @Override
        public final Builder defaultAction(RuleAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public UpdateListenerResponse build() {
            return new UpdateListenerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateListenerResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ListenerProtocol var1);

        public Builder port(Integer var1);

        public Builder serviceArn(String var1);

        public Builder serviceId(String var1);

        public Builder defaultAction(RuleAction var1);

        default public Builder defaultAction(Consumer<RuleAction.Builder> defaultAction) {
            return this.defaultAction((RuleAction)((RuleAction.Builder)RuleAction.builder().applyMutation(defaultAction)).build());
        }
    }
}

