/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.DomainVerificationSummary;
import software.amazon.awssdk.services.vpclattice.model.ListDomainVerificationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListDomainVerificationsResponse;

public class ListDomainVerificationsIterable
implements SdkIterable<ListDomainVerificationsResponse> {
    private final VpcLatticeClient client;
    private final ListDomainVerificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainVerificationsIterable(VpcLatticeClient client, ListDomainVerificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainVerificationsResponseFetcher();
    }

    public Iterator<ListDomainVerificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainVerificationSummary> items() {
        Function<ListDomainVerificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainVerificationsResponseFetcher
    implements SyncPageFetcher<ListDomainVerificationsResponse> {
        private ListDomainVerificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainVerificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDomainVerificationsResponse nextPage(ListDomainVerificationsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainVerificationsIterable.this.client.listDomainVerifications(ListDomainVerificationsIterable.this.firstRequest);
            }
            return ListDomainVerificationsIterable.this.client.listDomainVerifications((ListDomainVerificationsRequest)((Object)ListDomainVerificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

