/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse;
import software.amazon.awssdk.services.vpclattice.model.ResourceGatewaySummary;

public class ListResourceGatewaysIterable
implements SdkIterable<ListResourceGatewaysResponse> {
    private final VpcLatticeClient client;
    private final ListResourceGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceGatewaysIterable(VpcLatticeClient client, ListResourceGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceGatewaysResponseFetcher();
    }

    public Iterator<ListResourceGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceGatewaySummary> items() {
        Function<ListResourceGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceGatewaysResponseFetcher
    implements SyncPageFetcher<ListResourceGatewaysResponse> {
        private ListResourceGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceGatewaysResponse nextPage(ListResourceGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListResourceGatewaysIterable.this.client.listResourceGateways(ListResourceGatewaysIterable.this.firstRequest);
            }
            return ListResourceGatewaysIterable.this.client.listResourceGateways((ListResourceGatewaysRequest)((Object)ListResourceGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

