/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkEndpointAssociation;

public class ListServiceNetworkVpcEndpointAssociationsIterable
implements SdkIterable<ListServiceNetworkVpcEndpointAssociationsResponse> {
    private final VpcLatticeClient client;
    private final ListServiceNetworkVpcEndpointAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceNetworkVpcEndpointAssociationsIterable(VpcLatticeClient client, ListServiceNetworkVpcEndpointAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceNetworkVpcEndpointAssociationsResponseFetcher();
    }

    public Iterator<ListServiceNetworkVpcEndpointAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceNetworkEndpointAssociation> items() {
        Function<ListServiceNetworkVpcEndpointAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceNetworkVpcEndpointAssociationsResponseFetcher
    implements SyncPageFetcher<ListServiceNetworkVpcEndpointAssociationsResponse> {
        private ListServiceNetworkVpcEndpointAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceNetworkVpcEndpointAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceNetworkVpcEndpointAssociationsResponse nextPage(ListServiceNetworkVpcEndpointAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceNetworkVpcEndpointAssociationsIterable.this.client.listServiceNetworkVpcEndpointAssociations(ListServiceNetworkVpcEndpointAssociationsIterable.this.firstRequest);
            }
            return ListServiceNetworkVpcEndpointAssociationsIterable.this.client.listServiceNetworkVpcEndpointAssociations((ListServiceNetworkVpcEndpointAssociationsRequest)((Object)ListServiceNetworkVpcEndpointAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

