/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation failed because AWS WAF didn't recognize a parameter in the request. For example:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You specified an invalid parameter name.
 * </p>
 * </li>
 * <li>
 * <p>
 * You specified an invalid value.
 * </p>
 * </li>
 * <li>
 * <p>
 * You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or
 * <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than
 * <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than
 * <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER,
 * METHOD, QUERY_STRING, URI, or BODY.
 * </p>
 * </li>
 * <li>
 * <p>
 * You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for
 * <code>Data</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be
 * associated.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WafInvalidParameterException extends WafException implements
        ToCopyableBuilder<WafInvalidParameterException.Builder, WafInvalidParameterException> {
    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("field")
            .getter(getter(WafInvalidParameterException::fieldAsString)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final SdkField<String> PARAMETER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameter").getter(getter(WafInvalidParameterException::parameter)).setter(setter(Builder::parameter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameter").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(WafInvalidParameterException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, PARAMETER_FIELD,
            REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String field;

    private final String parameter;

    private final String reason;

    private WafInvalidParameterException(BuilderImpl builder) {
        super(builder);
        this.field = builder.field;
        this.parameter = builder.parameter;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Field property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #field} will return
     * {@link ParameterExceptionField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldAsString}.
     * </p>
     * 
     * @return The value of the Field property for this object.
     * @see ParameterExceptionField
     */
    public ParameterExceptionField field() {
        return ParameterExceptionField.fromValue(field);
    }

    /**
     * Returns the value of the Field property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #field} will return
     * {@link ParameterExceptionField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldAsString}.
     * </p>
     * 
     * @return The value of the Field property for this object.
     * @see ParameterExceptionField
     */
    public String fieldAsString() {
        return field;
    }

    /**
     * Returns the value of the Parameter property for this object.
     * 
     * @return The value of the Parameter property for this object.
     */
    public String parameter() {
        return parameter;
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ParameterExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see ParameterExceptionReason
     */
    public ParameterExceptionReason reason() {
        return ParameterExceptionReason.fromValue(reason);
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ParameterExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see ParameterExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WafInvalidParameterException, T> g) {
        return obj -> g.apply((WafInvalidParameterException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WafInvalidParameterException>, WafException.Builder {
        /**
         * Sets the value of the Field property for this object.
         *
         * @param field
         *        The new value for the Field property for this object.
         * @see ParameterExceptionField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterExceptionField
         */
        Builder field(String field);

        /**
         * Sets the value of the Field property for this object.
         *
         * @param field
         *        The new value for the Field property for this object.
         * @see ParameterExceptionField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterExceptionField
         */
        Builder field(ParameterExceptionField field);

        /**
         * Sets the value of the Parameter property for this object.
         *
         * @param parameter
         *        The new value for the Parameter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameter(String parameter);

        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see ParameterExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterExceptionReason
         */
        Builder reason(String reason);

        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see ParameterExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterExceptionReason
         */
        Builder reason(ParameterExceptionReason reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends WafException.BuilderImpl implements Builder {
        private String field;

        private String parameter;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(WafInvalidParameterException model) {
            super(model);
            field(model.field);
            parameter(model.parameter);
            reason(model.reason);
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(ParameterExceptionField field) {
            this.field(field == null ? null : field.toString());
            return this;
        }

        public final String getParameter() {
            return parameter;
        }

        public final void setParameter(String parameter) {
            this.parameter = parameter;
        }

        @Override
        public final Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ParameterExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public WafInvalidParameterException build() {
            return new WafInvalidParameterException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
