/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inspect the cookies in the web request. You can specify the parts of the cookies to inspect and you can narrow the
 * set of cookies to inspect by including or excluding specific keys.
 * </p>
 * <p>
 * This is used to indicate the web request component to inspect, in the <a>FieldToMatch</a> specification.
 * </p>
 * <p>
 * Example JSON:
 * <code>"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cookies implements SdkPojo, Serializable, ToCopyableBuilder<Cookies.Builder, Cookies> {
    private static final SdkField<CookieMatchPattern> MATCH_PATTERN_FIELD = SdkField
            .<CookieMatchPattern> builder(MarshallingType.SDK_POJO).memberName("MatchPattern")
            .getter(getter(Cookies::matchPattern)).setter(setter(Builder::matchPattern)).constructor(CookieMatchPattern::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchPattern").build()).build();

    private static final SdkField<String> MATCH_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchScope").getter(getter(Cookies::matchScopeAsString)).setter(setter(Builder::matchScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchScope").build()).build();

    private static final SdkField<String> OVERSIZE_HANDLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OversizeHandling").getter(getter(Cookies::oversizeHandlingAsString))
            .setter(setter(Builder::oversizeHandling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OversizeHandling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_PATTERN_FIELD,
            MATCH_SCOPE_FIELD, OVERSIZE_HANDLING_FIELD));

    private static final long serialVersionUID = 1L;

    private final CookieMatchPattern matchPattern;

    private final String matchScope;

    private final String oversizeHandling;

    private Cookies(BuilderImpl builder) {
        this.matchPattern = builder.matchPattern;
        this.matchScope = builder.matchScope;
        this.oversizeHandling = builder.oversizeHandling;
    }

    /**
     * <p>
     * The filter to use to identify the subset of cookies to inspect in a web request.
     * </p>
     * <p>
     * You must specify exactly one setting: either <code>All</code>, <code>IncludedCookies</code>, or
     * <code>ExcludedCookies</code>.
     * </p>
     * <p>
     * Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
     * </p>
     * 
     * @return The filter to use to identify the subset of cookies to inspect in a web request. </p>
     *         <p>
     *         You must specify exactly one setting: either <code>All</code>, <code>IncludedCookies</code>, or
     *         <code>ExcludedCookies</code>.
     *         </p>
     *         <p>
     *         Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
     */
    public final CookieMatchPattern matchPattern() {
        return matchPattern;
    }

    /**
     * <p>
     * The parts of the cookies to inspect with the rule inspection criteria. If you specify <code>All</code>, WAF
     * inspects both keys and values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchScope} will
     * return {@link MapMatchScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #matchScopeAsString}.
     * </p>
     * 
     * @return The parts of the cookies to inspect with the rule inspection criteria. If you specify <code>All</code>,
     *         WAF inspects both keys and values.
     * @see MapMatchScope
     */
    public final MapMatchScope matchScope() {
        return MapMatchScope.fromValue(matchScope);
    }

    /**
     * <p>
     * The parts of the cookies to inspect with the rule inspection criteria. If you specify <code>All</code>, WAF
     * inspects both keys and values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchScope} will
     * return {@link MapMatchScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #matchScopeAsString}.
     * </p>
     * 
     * @return The parts of the cookies to inspect with the rule inspection criteria. If you specify <code>All</code>,
     *         WAF inspects both keys and values.
     * @see MapMatchScope
     */
    public final String matchScopeAsString() {
        return matchScope;
    }

    /**
     * <p>
     * What WAF should do if the cookies of the request are more numerous or larger than WAF can inspect. WAF does not
     * support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total
     * cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to
     * WAF.
     * </p>
     * <p>
     * The options for oversize handling are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oversizeHandling}
     * will return {@link OversizeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oversizeHandlingAsString}.
     * </p>
     * 
     * @return What WAF should do if the cookies of the request are more numerous or larger than WAF can inspect. WAF
     *         does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or
     *         200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of
     *         cookie contents to WAF. </p>
     *         <p>
     *         The options for oversize handling are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection
     *         criteria.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see OversizeHandling
     */
    public final OversizeHandling oversizeHandling() {
        return OversizeHandling.fromValue(oversizeHandling);
    }

    /**
     * <p>
     * What WAF should do if the cookies of the request are more numerous or larger than WAF can inspect. WAF does not
     * support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total
     * cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to
     * WAF.
     * </p>
     * <p>
     * The options for oversize handling are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oversizeHandling}
     * will return {@link OversizeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oversizeHandlingAsString}.
     * </p>
     * 
     * @return What WAF should do if the cookies of the request are more numerous or larger than WAF can inspect. WAF
     *         does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or
     *         200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of
     *         cookie contents to WAF. </p>
     *         <p>
     *         The options for oversize handling are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection
     *         criteria.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see OversizeHandling
     */
    public final String oversizeHandlingAsString() {
        return oversizeHandling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchPattern());
        hashCode = 31 * hashCode + Objects.hashCode(matchScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oversizeHandlingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cookies)) {
            return false;
        }
        Cookies other = (Cookies) obj;
        return Objects.equals(matchPattern(), other.matchPattern())
                && Objects.equals(matchScopeAsString(), other.matchScopeAsString())
                && Objects.equals(oversizeHandlingAsString(), other.oversizeHandlingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cookies").add("MatchPattern", matchPattern()).add("MatchScope", matchScopeAsString())
                .add("OversizeHandling", oversizeHandlingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchPattern":
            return Optional.ofNullable(clazz.cast(matchPattern()));
        case "MatchScope":
            return Optional.ofNullable(clazz.cast(matchScopeAsString()));
        case "OversizeHandling":
            return Optional.ofNullable(clazz.cast(oversizeHandlingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cookies, T> g) {
        return obj -> g.apply((Cookies) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cookies> {
        /**
         * <p>
         * The filter to use to identify the subset of cookies to inspect in a web request.
         * </p>
         * <p>
         * You must specify exactly one setting: either <code>All</code>, <code>IncludedCookies</code>, or
         * <code>ExcludedCookies</code>.
         * </p>
         * <p>
         * Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
         * </p>
         * 
         * @param matchPattern
         *        The filter to use to identify the subset of cookies to inspect in a web request. </p>
         *        <p>
         *        You must specify exactly one setting: either <code>All</code>, <code>IncludedCookies</code>, or
         *        <code>ExcludedCookies</code>.
         *        </p>
         *        <p>
         *        Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchPattern(CookieMatchPattern matchPattern);

        /**
         * <p>
         * The filter to use to identify the subset of cookies to inspect in a web request.
         * </p>
         * <p>
         * You must specify exactly one setting: either <code>All</code>, <code>IncludedCookies</code>, or
         * <code>ExcludedCookies</code>.
         * </p>
         * <p>
         * Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link CookieMatchPattern.Builder} avoiding the
         * need to create one manually via {@link CookieMatchPattern#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CookieMatchPattern.Builder#build()} is called immediately and its
         * result is passed to {@link #matchPattern(CookieMatchPattern)}.
         * 
         * @param matchPattern
         *        a consumer that will call methods on {@link CookieMatchPattern.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchPattern(CookieMatchPattern)
         */
        default Builder matchPattern(Consumer<CookieMatchPattern.Builder> matchPattern) {
            return matchPattern(CookieMatchPattern.builder().applyMutation(matchPattern).build());
        }

        /**
         * <p>
         * The parts of the cookies to inspect with the rule inspection criteria. If you specify <code>All</code>, WAF
         * inspects both keys and values.
         * </p>
         * 
         * @param matchScope
         *        The parts of the cookies to inspect with the rule inspection criteria. If you specify <code>All</code>
         *        , WAF inspects both keys and values.
         * @see MapMatchScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapMatchScope
         */
        Builder matchScope(String matchScope);

        /**
         * <p>
         * The parts of the cookies to inspect with the rule inspection criteria. If you specify <code>All</code>, WAF
         * inspects both keys and values.
         * </p>
         * 
         * @param matchScope
         *        The parts of the cookies to inspect with the rule inspection criteria. If you specify <code>All</code>
         *        , WAF inspects both keys and values.
         * @see MapMatchScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapMatchScope
         */
        Builder matchScope(MapMatchScope matchScope);

        /**
         * <p>
         * What WAF should do if the cookies of the request are more numerous or larger than WAF can inspect. WAF does
         * not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total
         * cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to
         * WAF.
         * </p>
         * <p>
         * The options for oversize handling are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection criteria.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param oversizeHandling
         *        What WAF should do if the cookies of the request are more numerous or larger than WAF can inspect. WAF
         *        does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes)
         *        or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB
         *        of cookie contents to WAF. </p>
         *        <p>
         *        The options for oversize handling are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection
         *        criteria.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see OversizeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OversizeHandling
         */
        Builder oversizeHandling(String oversizeHandling);

        /**
         * <p>
         * What WAF should do if the cookies of the request are more numerous or larger than WAF can inspect. WAF does
         * not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total
         * cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to
         * WAF.
         * </p>
         * <p>
         * The options for oversize handling are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection criteria.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param oversizeHandling
         *        What WAF should do if the cookies of the request are more numerous or larger than WAF can inspect. WAF
         *        does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes)
         *        or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB
         *        of cookie contents to WAF. </p>
         *        <p>
         *        The options for oversize handling are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection
         *        criteria.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see OversizeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OversizeHandling
         */
        Builder oversizeHandling(OversizeHandling oversizeHandling);
    }

    static final class BuilderImpl implements Builder {
        private CookieMatchPattern matchPattern;

        private String matchScope;

        private String oversizeHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(Cookies model) {
            matchPattern(model.matchPattern);
            matchScope(model.matchScope);
            oversizeHandling(model.oversizeHandling);
        }

        public final CookieMatchPattern.Builder getMatchPattern() {
            return matchPattern != null ? matchPattern.toBuilder() : null;
        }

        public final void setMatchPattern(CookieMatchPattern.BuilderImpl matchPattern) {
            this.matchPattern = matchPattern != null ? matchPattern.build() : null;
        }

        @Override
        public final Builder matchPattern(CookieMatchPattern matchPattern) {
            this.matchPattern = matchPattern;
            return this;
        }

        public final String getMatchScope() {
            return matchScope;
        }

        public final void setMatchScope(String matchScope) {
            this.matchScope = matchScope;
        }

        @Override
        public final Builder matchScope(String matchScope) {
            this.matchScope = matchScope;
            return this;
        }

        @Override
        public final Builder matchScope(MapMatchScope matchScope) {
            this.matchScope(matchScope == null ? null : matchScope.toString());
            return this;
        }

        public final String getOversizeHandling() {
            return oversizeHandling;
        }

        public final void setOversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
        }

        @Override
        public final Builder oversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
            return this;
        }

        @Override
        public final Builder oversizeHandling(OversizeHandling oversizeHandling) {
            this.oversizeHandling(oversizeHandling == null ? null : oversizeHandling.toString());
            return this;
        }

        @Override
        public Cookies build() {
            return new Cookies(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
