/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This provides
 * information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that you
 * provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupSummary.Builder, RuleGroupSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RuleGroupSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RuleGroupSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RuleGroupSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockToken").getter(getter(RuleGroupSummary::lockToken)).setter(setter(Builder::lockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(RuleGroupSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            DESCRIPTION_FIELD, LOCK_TOKEN_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String description;

    private final String lockToken;

    private final String arn;

    private RuleGroupSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.description = builder.description;
        this.lockToken = builder.lockToken;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The name of the data type instance. You cannot change the name after you create the instance.
     * </p>
     * 
     * @return The name of the data type instance. You cannot change the name after you create the instance.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You
     * provide it to operations like update and delete.
     * </p>
     * 
     * @return A unique identifier for the rule group. This ID is returned in the responses to create and list commands.
     *         You provide it to operations like update and delete.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A description of the rule group that helps with identification.
     * </p>
     * 
     * @return A description of the rule group that helps with identification.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests,
     * to mark the state of the entity at the time of the request. To make changes to the entity associated with the
     * token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token
     * to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made,
     * the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another
     * <code>get</code>, and use the new token returned by that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
     *         requests, to mark the state of the entity at the time of the request. To make changes to the entity
     *         associated with the token, you provide the token to operations like <code>update</code> and
     *         <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you
     *         last retrieved it. If a change has been made, the update fails with a
     *         <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the
     *         new token returned by that operation.
     */
    public final String lockToken() {
        return lockToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entity.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lockToken());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSummary)) {
            return false;
        }
        RuleGroupSummary other = (RuleGroupSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(description(), other.description()) && Objects.equals(lockToken(), other.lockToken())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSummary").add("Name", name()).add("Id", id()).add("Description", description())
                .add("LockToken", lockToken()).add("ARN", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LockToken":
            return Optional.ofNullable(clazz.cast(lockToken()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSummary, T> g) {
        return obj -> g.apply((RuleGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSummary> {
        /**
         * <p>
         * The name of the data type instance. You cannot change the name after you create the instance.
         * </p>
         * 
         * @param name
         *        The name of the data type instance. You cannot change the name after you create the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You
         * provide it to operations like update and delete.
         * </p>
         * 
         * @param id
         *        A unique identifier for the rule group. This ID is returned in the responses to create and list
         *        commands. You provide it to operations like update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A description of the rule group that helps with identification.
         * </p>
         * 
         * @param description
         *        A description of the rule group that helps with identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
         * requests, to mark the state of the entity at the time of the request. To make changes to the entity
         * associated with the token, you provide the token to operations like <code>update</code> and
         * <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last
         * retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If
         * this happens, perform another <code>get</code>, and use the new token returned by that operation.
         * </p>
         * 
         * @param lockToken
         *        A token used for optimistic locking. WAF returns a token to your <code>get</code> and
         *        <code>list</code> requests, to mark the state of the entity at the time of the request. To make
         *        changes to the entity associated with the token, you provide the token to operations like
         *        <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been
         *        made to the entity since you last retrieved it. If a change has been made, the update fails with a
         *        <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use
         *        the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockToken(String lockToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the entity.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String description;

        private String lockToken;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSummary model) {
            name(model.name);
            id(model.id);
            description(model.description);
            lockToken(model.lockToken);
            arn(model.arn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLockToken() {
            return lockToken;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public RuleGroupSummary build() {
            return new RuleGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
