/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.Regex;
import software.amazon.awssdk.services.wafv2.model.RegularExpressionListCopier;
import software.amazon.awssdk.services.wafv2.model.SensitivityToAct;
import software.amazon.awssdk.services.wafv2.model.UsageOfAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientSideAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientSideAction> {
    private static final SdkField<String> USAGE_OF_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageOfAction").getter(ClientSideAction.getter(ClientSideAction::usageOfActionAsString)).setter(ClientSideAction.setter(Builder::usageOfAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOfAction").build()}).build();
    private static final SdkField<String> SENSITIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sensitivity").getter(ClientSideAction.getter(ClientSideAction::sensitivityAsString)).setter(ClientSideAction.setter(Builder::sensitivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sensitivity").build()}).build();
    private static final SdkField<List<Regex>> EXEMPT_URI_REGULAR_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExemptUriRegularExpressions").getter(ClientSideAction.getter(ClientSideAction::exemptUriRegularExpressions)).setter(ClientSideAction.setter(Builder::exemptUriRegularExpressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExemptUriRegularExpressions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Regex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_OF_ACTION_FIELD, SENSITIVITY_FIELD, EXEMPT_URI_REGULAR_EXPRESSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClientSideAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String usageOfAction;
    private final String sensitivity;
    private final List<Regex> exemptUriRegularExpressions;

    private ClientSideAction(BuilderImpl builder) {
        this.usageOfAction = builder.usageOfAction;
        this.sensitivity = builder.sensitivity;
        this.exemptUriRegularExpressions = builder.exemptUriRegularExpressions;
    }

    public final UsageOfAction usageOfAction() {
        return UsageOfAction.fromValue(this.usageOfAction);
    }

    public final String usageOfActionAsString() {
        return this.usageOfAction;
    }

    public final SensitivityToAct sensitivity() {
        return SensitivityToAct.fromValue(this.sensitivity);
    }

    public final String sensitivityAsString() {
        return this.sensitivity;
    }

    public final boolean hasExemptUriRegularExpressions() {
        return this.exemptUriRegularExpressions != null && !(this.exemptUriRegularExpressions instanceof SdkAutoConstructList);
    }

    public final List<Regex> exemptUriRegularExpressions() {
        return this.exemptUriRegularExpressions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usageOfActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitivityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExemptUriRegularExpressions() ? this.exemptUriRegularExpressions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientSideAction)) {
            return false;
        }
        ClientSideAction other = (ClientSideAction)obj;
        return Objects.equals(this.usageOfActionAsString(), other.usageOfActionAsString()) && Objects.equals(this.sensitivityAsString(), other.sensitivityAsString()) && this.hasExemptUriRegularExpressions() == other.hasExemptUriRegularExpressions() && Objects.equals(this.exemptUriRegularExpressions(), other.exemptUriRegularExpressions());
    }

    public final String toString() {
        return ToString.builder((String)"ClientSideAction").add("UsageOfAction", (Object)this.usageOfActionAsString()).add("Sensitivity", (Object)this.sensitivityAsString()).add("ExemptUriRegularExpressions", this.hasExemptUriRegularExpressions() ? this.exemptUriRegularExpressions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsageOfAction": {
                return Optional.ofNullable(clazz.cast(this.usageOfActionAsString()));
            }
            case "Sensitivity": {
                return Optional.ofNullable(clazz.cast(this.sensitivityAsString()));
            }
            case "ExemptUriRegularExpressions": {
                return Optional.ofNullable(clazz.cast(this.exemptUriRegularExpressions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UsageOfAction", USAGE_OF_ACTION_FIELD);
        map.put("Sensitivity", SENSITIVITY_FIELD);
        map.put("ExemptUriRegularExpressions", EXEMPT_URI_REGULAR_EXPRESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientSideAction, T> g) {
        return obj -> g.apply((ClientSideAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String usageOfAction;
        private String sensitivity;
        private List<Regex> exemptUriRegularExpressions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClientSideAction model) {
            this.usageOfAction(model.usageOfAction);
            this.sensitivity(model.sensitivity);
            this.exemptUriRegularExpressions(model.exemptUriRegularExpressions);
        }

        public final String getUsageOfAction() {
            return this.usageOfAction;
        }

        public final void setUsageOfAction(String usageOfAction) {
            this.usageOfAction = usageOfAction;
        }

        @Override
        public final Builder usageOfAction(String usageOfAction) {
            this.usageOfAction = usageOfAction;
            return this;
        }

        @Override
        public final Builder usageOfAction(UsageOfAction usageOfAction) {
            this.usageOfAction(usageOfAction == null ? null : usageOfAction.toString());
            return this;
        }

        public final String getSensitivity() {
            return this.sensitivity;
        }

        public final void setSensitivity(String sensitivity) {
            this.sensitivity = sensitivity;
        }

        @Override
        public final Builder sensitivity(String sensitivity) {
            this.sensitivity = sensitivity;
            return this;
        }

        @Override
        public final Builder sensitivity(SensitivityToAct sensitivity) {
            this.sensitivity(sensitivity == null ? null : sensitivity.toString());
            return this;
        }

        public final List<Regex.Builder> getExemptUriRegularExpressions() {
            List<Regex.Builder> result = RegularExpressionListCopier.copyToBuilder(this.exemptUriRegularExpressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExemptUriRegularExpressions(Collection<Regex.BuilderImpl> exemptUriRegularExpressions) {
            this.exemptUriRegularExpressions = RegularExpressionListCopier.copyFromBuilder(exemptUriRegularExpressions);
        }

        @Override
        public final Builder exemptUriRegularExpressions(Collection<Regex> exemptUriRegularExpressions) {
            this.exemptUriRegularExpressions = RegularExpressionListCopier.copy(exemptUriRegularExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exemptUriRegularExpressions(Regex ... exemptUriRegularExpressions) {
            this.exemptUriRegularExpressions(Arrays.asList(exemptUriRegularExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exemptUriRegularExpressions(Consumer<Regex.Builder> ... exemptUriRegularExpressions) {
            this.exemptUriRegularExpressions(Stream.of(exemptUriRegularExpressions).map(c -> (Regex)((Regex.Builder)Regex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ClientSideAction build() {
            return new ClientSideAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientSideAction> {
        public Builder usageOfAction(String var1);

        public Builder usageOfAction(UsageOfAction var1);

        public Builder sensitivity(String var1);

        public Builder sensitivity(SensitivityToAct var1);

        public Builder exemptUriRegularExpressions(Collection<Regex> var1);

        public Builder exemptUriRegularExpressions(Regex ... var1);

        public Builder exemptUriRegularExpressions(Consumer<Regex.Builder> ... var1);
    }
}

