/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.DataProtectionAction;
import software.amazon.awssdk.services.wafv2.model.FieldToProtect;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProtection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProtection> {
    private static final SdkField<FieldToProtect> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Field").getter(DataProtection.getter(DataProtection::field)).setter(DataProtection.setter(Builder::field)).constructor(FieldToProtect::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(DataProtection.getter(DataProtection::actionAsString)).setter(DataProtection.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_RULE_MATCH_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeRuleMatchDetails").getter(DataProtection.getter(DataProtection::excludeRuleMatchDetails)).setter(DataProtection.setter(Builder::excludeRuleMatchDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeRuleMatchDetails").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_RATE_BASED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeRateBasedDetails").getter(DataProtection.getter(DataProtection::excludeRateBasedDetails)).setter(DataProtection.setter(Builder::excludeRateBasedDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeRateBasedDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, ACTION_FIELD, EXCLUDE_RULE_MATCH_DETAILS_FIELD, EXCLUDE_RATE_BASED_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataProtection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FieldToProtect field;
    private final String action;
    private final Boolean excludeRuleMatchDetails;
    private final Boolean excludeRateBasedDetails;

    private DataProtection(BuilderImpl builder) {
        this.field = builder.field;
        this.action = builder.action;
        this.excludeRuleMatchDetails = builder.excludeRuleMatchDetails;
        this.excludeRateBasedDetails = builder.excludeRateBasedDetails;
    }

    public final FieldToProtect field() {
        return this.field;
    }

    public final DataProtectionAction action() {
        return DataProtectionAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final Boolean excludeRuleMatchDetails() {
        return this.excludeRuleMatchDetails;
    }

    public final Boolean excludeRateBasedDetails() {
        return this.excludeRateBasedDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.field());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeRuleMatchDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeRateBasedDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProtection)) {
            return false;
        }
        DataProtection other = (DataProtection)obj;
        return Objects.equals(this.field(), other.field()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.excludeRuleMatchDetails(), other.excludeRuleMatchDetails()) && Objects.equals(this.excludeRateBasedDetails(), other.excludeRateBasedDetails());
    }

    public final String toString() {
        return ToString.builder((String)"DataProtection").add("Field", (Object)this.field()).add("Action", (Object)this.actionAsString()).add("ExcludeRuleMatchDetails", (Object)this.excludeRuleMatchDetails()).add("ExcludeRateBasedDetails", (Object)this.excludeRateBasedDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Field": {
                return Optional.ofNullable(clazz.cast(this.field()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "ExcludeRuleMatchDetails": {
                return Optional.ofNullable(clazz.cast(this.excludeRuleMatchDetails()));
            }
            case "ExcludeRateBasedDetails": {
                return Optional.ofNullable(clazz.cast(this.excludeRateBasedDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Field", FIELD_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("ExcludeRuleMatchDetails", EXCLUDE_RULE_MATCH_DETAILS_FIELD);
        map.put("ExcludeRateBasedDetails", EXCLUDE_RATE_BASED_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProtection, T> g) {
        return obj -> g.apply((DataProtection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldToProtect field;
        private String action;
        private Boolean excludeRuleMatchDetails;
        private Boolean excludeRateBasedDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProtection model) {
            this.field(model.field);
            this.action(model.action);
            this.excludeRuleMatchDetails(model.excludeRuleMatchDetails);
            this.excludeRateBasedDetails(model.excludeRateBasedDetails);
        }

        public final FieldToProtect.Builder getField() {
            return this.field != null ? this.field.toBuilder() : null;
        }

        public final void setField(FieldToProtect.BuilderImpl field) {
            this.field = field != null ? field.build() : null;
        }

        @Override
        public final Builder field(FieldToProtect field) {
            this.field = field;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(DataProtectionAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Boolean getExcludeRuleMatchDetails() {
            return this.excludeRuleMatchDetails;
        }

        public final void setExcludeRuleMatchDetails(Boolean excludeRuleMatchDetails) {
            this.excludeRuleMatchDetails = excludeRuleMatchDetails;
        }

        @Override
        public final Builder excludeRuleMatchDetails(Boolean excludeRuleMatchDetails) {
            this.excludeRuleMatchDetails = excludeRuleMatchDetails;
            return this;
        }

        public final Boolean getExcludeRateBasedDetails() {
            return this.excludeRateBasedDetails;
        }

        public final void setExcludeRateBasedDetails(Boolean excludeRateBasedDetails) {
            this.excludeRateBasedDetails = excludeRateBasedDetails;
        }

        @Override
        public final Builder excludeRateBasedDetails(Boolean excludeRateBasedDetails) {
            this.excludeRateBasedDetails = excludeRateBasedDetails;
            return this;
        }

        public DataProtection build() {
            return new DataProtection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProtection> {
        public Builder field(FieldToProtect var1);

        default public Builder field(Consumer<FieldToProtect.Builder> field) {
            return this.field((FieldToProtect)((FieldToProtect.Builder)FieldToProtect.builder().applyMutation(field)).build());
        }

        public Builder action(String var1);

        public Builder action(DataProtectionAction var1);

        public Builder excludeRuleMatchDetails(Boolean var1);

        public Builder excludeRateBasedDetails(Boolean var1);
    }
}

