/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.PasswordField;
import software.amazon.awssdk.services.wafv2.model.PayloadType;
import software.amazon.awssdk.services.wafv2.model.UsernameField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestInspection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestInspection> {
    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PayloadType").getter(RequestInspection.getter(RequestInspection::payloadTypeAsString)).setter(RequestInspection.setter(Builder::payloadType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()}).build();
    private static final SdkField<UsernameField> USERNAME_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UsernameField").getter(RequestInspection.getter(RequestInspection::usernameField)).setter(RequestInspection.setter(Builder::usernameField)).constructor(UsernameField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameField").build()}).build();
    private static final SdkField<PasswordField> PASSWORD_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PasswordField").getter(RequestInspection.getter(RequestInspection::passwordField)).setter(RequestInspection.setter(Builder::passwordField)).constructor(PasswordField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_TYPE_FIELD, USERNAME_FIELD_FIELD, PASSWORD_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RequestInspection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String payloadType;
    private final UsernameField usernameField;
    private final PasswordField passwordField;

    private RequestInspection(BuilderImpl builder) {
        this.payloadType = builder.payloadType;
        this.usernameField = builder.usernameField;
        this.passwordField = builder.passwordField;
    }

    public final PayloadType payloadType() {
        return PayloadType.fromValue(this.payloadType);
    }

    public final String payloadTypeAsString() {
        return this.payloadType;
    }

    public final UsernameField usernameField() {
        return this.usernameField;
    }

    public final PasswordField passwordField() {
        return this.passwordField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernameField());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestInspection)) {
            return false;
        }
        RequestInspection other = (RequestInspection)obj;
        return Objects.equals(this.payloadTypeAsString(), other.payloadTypeAsString()) && Objects.equals(this.usernameField(), other.usernameField()) && Objects.equals(this.passwordField(), other.passwordField());
    }

    public final String toString() {
        return ToString.builder((String)"RequestInspection").add("PayloadType", (Object)this.payloadTypeAsString()).add("UsernameField", (Object)this.usernameField()).add("PasswordField", (Object)this.passwordField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PayloadType": {
                return Optional.ofNullable(clazz.cast(this.payloadTypeAsString()));
            }
            case "UsernameField": {
                return Optional.ofNullable(clazz.cast(this.usernameField()));
            }
            case "PasswordField": {
                return Optional.ofNullable(clazz.cast(this.passwordField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PayloadType", PAYLOAD_TYPE_FIELD);
        map.put("UsernameField", USERNAME_FIELD_FIELD);
        map.put("PasswordField", PASSWORD_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestInspection, T> g) {
        return obj -> g.apply((RequestInspection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String payloadType;
        private UsernameField usernameField;
        private PasswordField passwordField;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestInspection model) {
            this.payloadType(model.payloadType);
            this.usernameField(model.usernameField);
            this.passwordField(model.passwordField);
        }

        public final String getPayloadType() {
            return this.payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(PayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        public final UsernameField.Builder getUsernameField() {
            return this.usernameField != null ? this.usernameField.toBuilder() : null;
        }

        public final void setUsernameField(UsernameField.BuilderImpl usernameField) {
            this.usernameField = usernameField != null ? usernameField.build() : null;
        }

        @Override
        public final Builder usernameField(UsernameField usernameField) {
            this.usernameField = usernameField;
            return this;
        }

        public final PasswordField.Builder getPasswordField() {
            return this.passwordField != null ? this.passwordField.toBuilder() : null;
        }

        public final void setPasswordField(PasswordField.BuilderImpl passwordField) {
            this.passwordField = passwordField != null ? passwordField.build() : null;
        }

        @Override
        public final Builder passwordField(PasswordField passwordField) {
            this.passwordField = passwordField;
            return this;
        }

        public RequestInspection build() {
            return new RequestInspection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestInspection> {
        public Builder payloadType(String var1);

        public Builder payloadType(PayloadType var1);

        public Builder usernameField(UsernameField var1);

        default public Builder usernameField(Consumer<UsernameField.Builder> usernameField) {
            return this.usernameField((UsernameField)((UsernameField.Builder)UsernameField.builder().applyMutation(usernameField)).build());
        }

        public Builder passwordField(PasswordField var1);

        default public Builder passwordField(Consumer<PasswordField.Builder> passwordField) {
            return this.passwordField((PasswordField)((PasswordField.Builder)PasswordField.builder().applyMutation(passwordField)).build());
        }
    }
}

