/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A metric that contributes to the consolidated report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsolidatedReportMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsolidatedReportMetric.Builder, ConsolidatedReportMetric> {
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricType").getter(getter(ConsolidatedReportMetric::metricTypeAsString))
            .setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()).build();

    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("RiskCounts")
            .getter(getter(ConsolidatedReportMetric::riskCountsAsStrings))
            .setter(setter(Builder::riskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(ConsolidatedReportMetric::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(ConsolidatedReportMetric::workloadName))
            .setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> WORKLOAD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadArn").getter(getter(ConsolidatedReportMetric::workloadArn)).setter(setter(Builder::workloadArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadArn").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(ConsolidatedReportMetric::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<List<LensMetric>> LENSES_FIELD = SdkField
            .<List<LensMetric>> builder(MarshallingType.LIST)
            .memberName("Lenses")
            .getter(getter(ConsolidatedReportMetric::lenses))
            .setter(setter(Builder::lenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LensMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(LensMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LENSES_APPLIED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LensesAppliedCount").getter(getter(ConsolidatedReportMetric::lensesAppliedCount))
            .setter(setter(Builder::lensesAppliedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensesAppliedCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_TYPE_FIELD,
            RISK_COUNTS_FIELD, WORKLOAD_ID_FIELD, WORKLOAD_NAME_FIELD, WORKLOAD_ARN_FIELD, UPDATED_AT_FIELD, LENSES_FIELD,
            LENSES_APPLIED_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricType;

    private final Map<String, Integer> riskCounts;

    private final String workloadId;

    private final String workloadName;

    private final String workloadArn;

    private final Instant updatedAt;

    private final List<LensMetric> lenses;

    private final Integer lensesAppliedCount;

    private ConsolidatedReportMetric(BuilderImpl builder) {
        this.metricType = builder.metricType;
        this.riskCounts = builder.riskCounts;
        this.workloadId = builder.workloadId;
        this.workloadName = builder.workloadName;
        this.workloadArn = builder.workloadArn;
        this.updatedAt = builder.updatedAt;
        this.lenses = builder.lenses;
        this.lensesAppliedCount = builder.lensesAppliedCount;
    }

    /**
     * <p>
     * The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are
     *         supported.
     * @see MetricType
     */
    public final MetricType metricType() {
        return MetricType.fromValue(metricType);
    }

    /**
     * <p>
     * The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are
     *         supported.
     * @see MetricType
     */
    public final String metricTypeAsString() {
        return metricType;
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(riskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the RiskCounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRiskCounts() {
        return riskCounts != null && !(riskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<String, Integer> riskCountsAsStrings() {
        return riskCounts;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the WorkloadName property for this object.
     * 
     * @return The value of the WorkloadName property for this object.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * Returns the value of the WorkloadArn property for this object.
     * 
     * @return The value of the WorkloadArn property for this object.
     */
    public final String workloadArn() {
        return workloadArn;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Lenses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLenses() {
        return lenses != null && !(lenses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics for the lenses in the workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLenses} method.
     * </p>
     * 
     * @return The metrics for the lenses in the workload.
     */
    public final List<LensMetric> lenses() {
        return lenses;
    }

    /**
     * <p>
     * The total number of lenses applied to the workload.
     * </p>
     * 
     * @return The total number of lenses applied to the workload.
     */
    public final Integer lensesAppliedCount() {
        return lensesAppliedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRiskCounts() ? riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(workloadArn());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasLenses() ? lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lensesAppliedCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidatedReportMetric)) {
            return false;
        }
        ConsolidatedReportMetric other = (ConsolidatedReportMetric) obj;
        return Objects.equals(metricTypeAsString(), other.metricTypeAsString()) && hasRiskCounts() == other.hasRiskCounts()
                && Objects.equals(riskCountsAsStrings(), other.riskCountsAsStrings())
                && Objects.equals(workloadId(), other.workloadId()) && Objects.equals(workloadName(), other.workloadName())
                && Objects.equals(workloadArn(), other.workloadArn()) && Objects.equals(updatedAt(), other.updatedAt())
                && hasLenses() == other.hasLenses() && Objects.equals(lenses(), other.lenses())
                && Objects.equals(lensesAppliedCount(), other.lensesAppliedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsolidatedReportMetric").add("MetricType", metricTypeAsString())
                .add("RiskCounts", hasRiskCounts() ? riskCountsAsStrings() : null).add("WorkloadId", workloadId())
                .add("WorkloadName", workloadName()).add("WorkloadArn", workloadArn()).add("UpdatedAt", updatedAt())
                .add("Lenses", hasLenses() ? lenses() : null).add("LensesAppliedCount", lensesAppliedCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricType":
            return Optional.ofNullable(clazz.cast(metricTypeAsString()));
        case "RiskCounts":
            return Optional.ofNullable(clazz.cast(riskCountsAsStrings()));
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "WorkloadArn":
            return Optional.ofNullable(clazz.cast(workloadArn()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Lenses":
            return Optional.ofNullable(clazz.cast(lenses()));
        case "LensesAppliedCount":
            return Optional.ofNullable(clazz.cast(lensesAppliedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConsolidatedReportMetric, T> g) {
        return obj -> g.apply((ConsolidatedReportMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsolidatedReportMetric> {
        /**
         * <p>
         * The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are supported.
         * </p>
         * 
         * @param metricType
         *        The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are
         *        supported.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metricType(String metricType);

        /**
         * <p>
         * The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are supported.
         * </p>
         * 
         * @param metricType
         *        The metric type of a metric in the consolidated report. Currently only WORKLOAD metric types are
         *        supported.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metricType(MetricType metricType);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCountsWithStrings(Map<String, Integer> riskCounts);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCounts(Map<Risk, Integer> riskCounts);

        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the WorkloadName property for this object.
         *
         * @param workloadName
         *        The new value for the WorkloadName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * Sets the value of the WorkloadArn property for this object.
         *
         * @param workloadArn
         *        The new value for the WorkloadArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadArn(String workloadArn);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The metrics for the lenses in the workload.
         * </p>
         * 
         * @param lenses
         *        The metrics for the lenses in the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(Collection<LensMetric> lenses);

        /**
         * <p>
         * The metrics for the lenses in the workload.
         * </p>
         * 
         * @param lenses
         *        The metrics for the lenses in the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(LensMetric... lenses);

        /**
         * <p>
         * The metrics for the lenses in the workload.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.LensMetric.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.wellarchitected.model.LensMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.LensMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #lenses(List<LensMetric>)}.
         * 
         * @param lenses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.LensMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lenses(java.util.Collection<LensMetric>)
         */
        Builder lenses(Consumer<LensMetric.Builder>... lenses);

        /**
         * <p>
         * The total number of lenses applied to the workload.
         * </p>
         * 
         * @param lensesAppliedCount
         *        The total number of lenses applied to the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensesAppliedCount(Integer lensesAppliedCount);
    }

    static final class BuilderImpl implements Builder {
        private String metricType;

        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();

        private String workloadId;

        private String workloadName;

        private String workloadArn;

        private Instant updatedAt;

        private List<LensMetric> lenses = DefaultSdkAutoConstructList.getInstance();

        private Integer lensesAppliedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsolidatedReportMetric model) {
            metricType(model.metricType);
            riskCountsWithStrings(model.riskCounts);
            workloadId(model.workloadId);
            workloadName(model.workloadName);
            workloadArn(model.workloadArn);
            updatedAt(model.updatedAt);
            lenses(model.lenses);
            lensesAppliedCount(model.lensesAppliedCount);
        }

        public final String getMetricType() {
            return metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(MetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getWorkloadArn() {
            return workloadArn;
        }

        public final void setWorkloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
        }

        @Override
        public final Builder workloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<LensMetric.Builder> getLenses() {
            List<LensMetric.Builder> result = LensMetricsCopier.copyToBuilder(this.lenses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLenses(Collection<LensMetric.BuilderImpl> lenses) {
            this.lenses = LensMetricsCopier.copyFromBuilder(lenses);
        }

        @Override
        public final Builder lenses(Collection<LensMetric> lenses) {
            this.lenses = LensMetricsCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(LensMetric... lenses) {
            lenses(Arrays.asList(lenses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(Consumer<LensMetric.Builder>... lenses) {
            lenses(Stream.of(lenses).map(c -> LensMetric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getLensesAppliedCount() {
            return lensesAppliedCount;
        }

        public final void setLensesAppliedCount(Integer lensesAppliedCount) {
            this.lensesAppliedCount = lensesAppliedCount;
        }

        @Override
        public final Builder lensesAppliedCount(Integer lensesAppliedCount) {
            this.lensesAppliedCount = lensesAppliedCount;
            return this;
        }

        @Override
        public ConsolidatedReportMetric build() {
            return new ConsolidatedReportMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
