/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A profile question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileQuestion implements SdkPojo, Serializable, ToCopyableBuilder<ProfileQuestion.Builder, ProfileQuestion> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(ProfileQuestion::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionTitle").getter(getter(ProfileQuestion::questionTitle)).setter(setter(Builder::questionTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()).build();

    private static final SdkField<String> QUESTION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionDescription").getter(getter(ProfileQuestion::questionDescription))
            .setter(setter(Builder::questionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionDescription").build())
            .build();

    private static final SdkField<List<ProfileChoice>> QUESTION_CHOICES_FIELD = SdkField
            .<List<ProfileChoice>> builder(MarshallingType.LIST)
            .memberName("QuestionChoices")
            .getter(getter(ProfileQuestion::questionChoices))
            .setter(setter(Builder::questionChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileChoice> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileChoice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SELECTED_CHOICE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedChoiceIds")
            .getter(getter(ProfileQuestion::selectedChoiceIds))
            .setter(setter(Builder::selectedChoiceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoiceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MIN_SELECTED_CHOICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSelectedChoices").getter(getter(ProfileQuestion::minSelectedChoices))
            .setter(setter(Builder::minSelectedChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSelectedChoices").build())
            .build();

    private static final SdkField<Integer> MAX_SELECTED_CHOICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSelectedChoices").getter(getter(ProfileQuestion::maxSelectedChoices))
            .setter(setter(Builder::maxSelectedChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSelectedChoices").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD,
            QUESTION_TITLE_FIELD, QUESTION_DESCRIPTION_FIELD, QUESTION_CHOICES_FIELD, SELECTED_CHOICE_IDS_FIELD,
            MIN_SELECTED_CHOICES_FIELD, MAX_SELECTED_CHOICES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String questionId;

    private final String questionTitle;

    private final String questionDescription;

    private final List<ProfileChoice> questionChoices;

    private final List<String> selectedChoiceIds;

    private final Integer minSelectedChoices;

    private final Integer maxSelectedChoices;

    private ProfileQuestion(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.questionTitle = builder.questionTitle;
        this.questionDescription = builder.questionDescription;
        this.questionChoices = builder.questionChoices;
        this.selectedChoiceIds = builder.selectedChoiceIds;
        this.minSelectedChoices = builder.minSelectedChoices;
        this.maxSelectedChoices = builder.maxSelectedChoices;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns the value of the QuestionTitle property for this object.
     * 
     * @return The value of the QuestionTitle property for this object.
     */
    public final String questionTitle() {
        return questionTitle;
    }

    /**
     * Returns the value of the QuestionDescription property for this object.
     * 
     * @return The value of the QuestionDescription property for this object.
     */
    public final String questionDescription() {
        return questionDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the QuestionChoices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQuestionChoices() {
        return questionChoices != null && !(questionChoices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The question choices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuestionChoices} method.
     * </p>
     * 
     * @return The question choices.
     */
    public final List<ProfileChoice> questionChoices() {
        return questionChoices;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedChoiceIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedChoiceIds() {
        return selectedChoiceIds != null && !(selectedChoiceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selected choices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedChoiceIds} method.
     * </p>
     * 
     * @return The selected choices.
     */
    public final List<String> selectedChoiceIds() {
        return selectedChoiceIds;
    }

    /**
     * <p>
     * The minimum number of selected choices.
     * </p>
     * 
     * @return The minimum number of selected choices.
     */
    public final Integer minSelectedChoices() {
        return minSelectedChoices;
    }

    /**
     * <p>
     * The maximum number of selected choices.
     * </p>
     * 
     * @return The maximum number of selected choices.
     */
    public final Integer maxSelectedChoices() {
        return maxSelectedChoices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(questionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuestionChoices() ? questionChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedChoiceIds() ? selectedChoiceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minSelectedChoices());
        hashCode = 31 * hashCode + Objects.hashCode(maxSelectedChoices());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileQuestion)) {
            return false;
        }
        ProfileQuestion other = (ProfileQuestion) obj;
        return Objects.equals(questionId(), other.questionId()) && Objects.equals(questionTitle(), other.questionTitle())
                && Objects.equals(questionDescription(), other.questionDescription())
                && hasQuestionChoices() == other.hasQuestionChoices()
                && Objects.equals(questionChoices(), other.questionChoices())
                && hasSelectedChoiceIds() == other.hasSelectedChoiceIds()
                && Objects.equals(selectedChoiceIds(), other.selectedChoiceIds())
                && Objects.equals(minSelectedChoices(), other.minSelectedChoices())
                && Objects.equals(maxSelectedChoices(), other.maxSelectedChoices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileQuestion").add("QuestionId", questionId()).add("QuestionTitle", questionTitle())
                .add("QuestionDescription", questionDescription())
                .add("QuestionChoices", hasQuestionChoices() ? questionChoices() : null)
                .add("SelectedChoiceIds", hasSelectedChoiceIds() ? selectedChoiceIds() : null)
                .add("MinSelectedChoices", minSelectedChoices()).add("MaxSelectedChoices", maxSelectedChoices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "QuestionTitle":
            return Optional.ofNullable(clazz.cast(questionTitle()));
        case "QuestionDescription":
            return Optional.ofNullable(clazz.cast(questionDescription()));
        case "QuestionChoices":
            return Optional.ofNullable(clazz.cast(questionChoices()));
        case "SelectedChoiceIds":
            return Optional.ofNullable(clazz.cast(selectedChoiceIds()));
        case "MinSelectedChoices":
            return Optional.ofNullable(clazz.cast(minSelectedChoices()));
        case "MaxSelectedChoices":
            return Optional.ofNullable(clazz.cast(maxSelectedChoices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileQuestion, T> g) {
        return obj -> g.apply((ProfileQuestion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileQuestion> {
        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the QuestionTitle property for this object.
         *
         * @param questionTitle
         *        The new value for the QuestionTitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionTitle(String questionTitle);

        /**
         * Sets the value of the QuestionDescription property for this object.
         *
         * @param questionDescription
         *        The new value for the QuestionDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionDescription(String questionDescription);

        /**
         * <p>
         * The question choices.
         * </p>
         * 
         * @param questionChoices
         *        The question choices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionChoices(Collection<ProfileChoice> questionChoices);

        /**
         * <p>
         * The question choices.
         * </p>
         * 
         * @param questionChoices
         *        The question choices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionChoices(ProfileChoice... questionChoices);

        /**
         * <p>
         * The question choices.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileChoice.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.wellarchitected.model.ProfileChoice#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileChoice.Builder#build()} is called
         * immediately and its result is passed to {@link #questionChoices(List<ProfileChoice>)}.
         * 
         * @param questionChoices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ProfileChoice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #questionChoices(java.util.Collection<ProfileChoice>)
         */
        Builder questionChoices(Consumer<ProfileChoice.Builder>... questionChoices);

        /**
         * <p>
         * The selected choices.
         * </p>
         * 
         * @param selectedChoiceIds
         *        The selected choices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoiceIds(Collection<String> selectedChoiceIds);

        /**
         * <p>
         * The selected choices.
         * </p>
         * 
         * @param selectedChoiceIds
         *        The selected choices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoiceIds(String... selectedChoiceIds);

        /**
         * <p>
         * The minimum number of selected choices.
         * </p>
         * 
         * @param minSelectedChoices
         *        The minimum number of selected choices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSelectedChoices(Integer minSelectedChoices);

        /**
         * <p>
         * The maximum number of selected choices.
         * </p>
         * 
         * @param maxSelectedChoices
         *        The maximum number of selected choices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSelectedChoices(Integer maxSelectedChoices);
    }

    static final class BuilderImpl implements Builder {
        private String questionId;

        private String questionTitle;

        private String questionDescription;

        private List<ProfileChoice> questionChoices = DefaultSdkAutoConstructList.getInstance();

        private List<String> selectedChoiceIds = DefaultSdkAutoConstructList.getInstance();

        private Integer minSelectedChoices;

        private Integer maxSelectedChoices;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileQuestion model) {
            questionId(model.questionId);
            questionTitle(model.questionTitle);
            questionDescription(model.questionDescription);
            questionChoices(model.questionChoices);
            selectedChoiceIds(model.selectedChoiceIds);
            minSelectedChoices(model.minSelectedChoices);
            maxSelectedChoices(model.maxSelectedChoices);
        }

        public final String getQuestionId() {
            return questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getQuestionTitle() {
            return questionTitle;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final String getQuestionDescription() {
            return questionDescription;
        }

        public final void setQuestionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
        }

        @Override
        public final Builder questionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
            return this;
        }

        public final List<ProfileChoice.Builder> getQuestionChoices() {
            List<ProfileChoice.Builder> result = ProfileQuestionChoicesCopier.copyToBuilder(this.questionChoices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuestionChoices(Collection<ProfileChoice.BuilderImpl> questionChoices) {
            this.questionChoices = ProfileQuestionChoicesCopier.copyFromBuilder(questionChoices);
        }

        @Override
        public final Builder questionChoices(Collection<ProfileChoice> questionChoices) {
            this.questionChoices = ProfileQuestionChoicesCopier.copy(questionChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questionChoices(ProfileChoice... questionChoices) {
            questionChoices(Arrays.asList(questionChoices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questionChoices(Consumer<ProfileChoice.Builder>... questionChoices) {
            questionChoices(Stream.of(questionChoices).map(c -> ProfileChoice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSelectedChoiceIds() {
            if (selectedChoiceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedChoiceIds;
        }

        public final void setSelectedChoiceIds(Collection<String> selectedChoiceIds) {
            this.selectedChoiceIds = SelectedChoiceIdsCopier.copy(selectedChoiceIds);
        }

        @Override
        public final Builder selectedChoiceIds(Collection<String> selectedChoiceIds) {
            this.selectedChoiceIds = SelectedChoiceIdsCopier.copy(selectedChoiceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoiceIds(String... selectedChoiceIds) {
            selectedChoiceIds(Arrays.asList(selectedChoiceIds));
            return this;
        }

        public final Integer getMinSelectedChoices() {
            return minSelectedChoices;
        }

        public final void setMinSelectedChoices(Integer minSelectedChoices) {
            this.minSelectedChoices = minSelectedChoices;
        }

        @Override
        public final Builder minSelectedChoices(Integer minSelectedChoices) {
            this.minSelectedChoices = minSelectedChoices;
            return this;
        }

        public final Integer getMaxSelectedChoices() {
            return maxSelectedChoices;
        }

        public final void setMaxSelectedChoices(Integer maxSelectedChoices) {
            this.maxSelectedChoices = maxSelectedChoices;
        }

        @Override
        public final Builder maxSelectedChoices(Integer maxSelectedChoices) {
            this.maxSelectedChoices = maxSelectedChoices;
            return this;
        }

        @Override
        public ProfileQuestion build() {
            return new ProfileQuestion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
