/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CheckFailureReason {
    ASSUME_ROLE_ERROR("ASSUME_ROLE_ERROR"),
    ACCESS_DENIED("ACCESS_DENIED"),
    UNKNOWN_ERROR("UNKNOWN_ERROR"),
    PREMIUM_SUPPORT_REQUIRED("PREMIUM_SUPPORT_REQUIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CheckFailureReason> VALUE_MAP;
    private final String value;

    private CheckFailureReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CheckFailureReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CheckFailureReason> knownValues() {
        EnumSet<CheckFailureReason> knownValues = EnumSet.allOf(CheckFailureReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CheckFailureReason.class, CheckFailureReason::toString);
    }
}

