/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.PillarMetric;
import software.amazon.awssdk.services.wellarchitected.model.PillarMetricsCopier;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.RiskCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LensMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LensMetric> {
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(LensMetric.getter(LensMetric::lensArn)).setter(LensMetric.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<List<PillarMetric>> PILLARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pillars").getter(LensMetric.getter(LensMetric::pillars)).setter(LensMetric.setter(Builder::pillars)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pillars").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PillarMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RiskCounts").getter(LensMetric.getter(LensMetric::riskCountsAsStrings)).setter(LensMetric.setter(Builder::riskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ARN_FIELD, PILLARS_FIELD, RISK_COUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lensArn;
    private final List<PillarMetric> pillars;
    private final Map<String, Integer> riskCounts;

    private LensMetric(BuilderImpl builder) {
        this.lensArn = builder.lensArn;
        this.pillars = builder.pillars;
        this.riskCounts = builder.riskCounts;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final boolean hasPillars() {
        return this.pillars != null && !(this.pillars instanceof SdkAutoConstructList);
    }

    public final List<PillarMetric> pillars() {
        return this.pillars;
    }

    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.riskCounts);
    }

    public final boolean hasRiskCounts() {
        return this.riskCounts != null && !(this.riskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> riskCountsAsStrings() {
        return this.riskCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillars() ? this.pillars() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskCounts() ? this.riskCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensMetric)) {
            return false;
        }
        LensMetric other = (LensMetric)obj;
        return Objects.equals(this.lensArn(), other.lensArn()) && this.hasPillars() == other.hasPillars() && Objects.equals(this.pillars(), other.pillars()) && this.hasRiskCounts() == other.hasRiskCounts() && Objects.equals(this.riskCountsAsStrings(), other.riskCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"LensMetric").add("LensArn", (Object)this.lensArn()).add("Pillars", this.hasPillars() ? this.pillars() : null).add("RiskCounts", this.hasRiskCounts() ? this.riskCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "Pillars": {
                return Optional.ofNullable(clazz.cast(this.pillars()));
            }
            case "RiskCounts": {
                return Optional.ofNullable(clazz.cast(this.riskCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LensMetric, T> g) {
        return obj -> g.apply((LensMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lensArn;
        private List<PillarMetric> pillars = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LensMetric model) {
            this.lensArn(model.lensArn);
            this.pillars(model.pillars);
            this.riskCountsWithStrings(model.riskCounts);
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final List<PillarMetric.Builder> getPillars() {
            List<PillarMetric.Builder> result = PillarMetricsCopier.copyToBuilder(this.pillars);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPillars(Collection<PillarMetric.BuilderImpl> pillars) {
            this.pillars = PillarMetricsCopier.copyFromBuilder(pillars);
        }

        @Override
        public final Builder pillars(Collection<PillarMetric> pillars) {
            this.pillars = PillarMetricsCopier.copy(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillars(PillarMetric ... pillars) {
            this.pillars(Arrays.asList(pillars));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillars(Consumer<PillarMetric.Builder> ... pillars) {
            this.pillars(Stream.of(pillars).map(c -> (PillarMetric)((PillarMetric.Builder)PillarMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (this.riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public LensMetric build() {
            return new LensMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LensMetric> {
        public Builder lensArn(String var1);

        public Builder pillars(Collection<PillarMetric> var1);

        public Builder pillars(PillarMetric ... var1);

        public Builder pillars(Consumer<PillarMetric.Builder> ... var1);

        public Builder riskCountsWithStrings(Map<String, Integer> var1);

        public Builder riskCounts(Map<Risk, Integer> var1);
    }
}

