/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Question {
    UNANSWERED("UNANSWERED"),
    ANSWERED("ANSWERED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Question> VALUE_MAP;
    private final String value;

    private Question(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Question fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Question> knownValues() {
        EnumSet<Question> knownValues = EnumSet.allOf(Question.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Question.class, Question::toString);
    }
}

