/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse;

public class ListLensSharesIterable
implements SdkIterable<ListLensSharesResponse> {
    private final WellArchitectedClient client;
    private final ListLensSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLensSharesIterable(WellArchitectedClient client, ListLensSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLensSharesResponseFetcher();
    }

    public Iterator<ListLensSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLensSharesResponseFetcher
    implements SyncPageFetcher<ListLensSharesResponse> {
        private ListLensSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListLensSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLensSharesResponse nextPage(ListLensSharesResponse previousPage) {
            if (previousPage == null) {
                return ListLensSharesIterable.this.client.listLensShares(ListLensSharesIterable.this.firstRequest);
            }
            return ListLensSharesIterable.this.client.listLensShares((ListLensSharesRequest)((Object)ListLensSharesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

