/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.IssueManagementType;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadIssueManagementStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkloadJiraConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkloadJiraConfigurationInput> {
    private static final SdkField<String> ISSUE_MANAGEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssueManagementStatus").getter(WorkloadJiraConfigurationInput.getter(WorkloadJiraConfigurationInput::issueManagementStatusAsString)).setter(WorkloadJiraConfigurationInput.setter(Builder::issueManagementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueManagementStatus").build()}).build();
    private static final SdkField<String> ISSUE_MANAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssueManagementType").getter(WorkloadJiraConfigurationInput.getter(WorkloadJiraConfigurationInput::issueManagementTypeAsString)).setter(WorkloadJiraConfigurationInput.setter(Builder::issueManagementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueManagementType").build()}).build();
    private static final SdkField<String> JIRA_PROJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JiraProjectKey").getter(WorkloadJiraConfigurationInput.getter(WorkloadJiraConfigurationInput::jiraProjectKey)).setter(WorkloadJiraConfigurationInput.setter(Builder::jiraProjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraProjectKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUE_MANAGEMENT_STATUS_FIELD, ISSUE_MANAGEMENT_TYPE_FIELD, JIRA_PROJECT_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkloadJiraConfigurationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String issueManagementStatus;
    private final String issueManagementType;
    private final String jiraProjectKey;

    private WorkloadJiraConfigurationInput(BuilderImpl builder) {
        this.issueManagementStatus = builder.issueManagementStatus;
        this.issueManagementType = builder.issueManagementType;
        this.jiraProjectKey = builder.jiraProjectKey;
    }

    public final WorkloadIssueManagementStatus issueManagementStatus() {
        return WorkloadIssueManagementStatus.fromValue(this.issueManagementStatus);
    }

    public final String issueManagementStatusAsString() {
        return this.issueManagementStatus;
    }

    public final IssueManagementType issueManagementType() {
        return IssueManagementType.fromValue(this.issueManagementType);
    }

    public final String issueManagementTypeAsString() {
        return this.issueManagementType;
    }

    public final String jiraProjectKey() {
        return this.jiraProjectKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issueManagementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issueManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jiraProjectKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadJiraConfigurationInput)) {
            return false;
        }
        WorkloadJiraConfigurationInput other = (WorkloadJiraConfigurationInput)obj;
        return Objects.equals(this.issueManagementStatusAsString(), other.issueManagementStatusAsString()) && Objects.equals(this.issueManagementTypeAsString(), other.issueManagementTypeAsString()) && Objects.equals(this.jiraProjectKey(), other.jiraProjectKey());
    }

    public final String toString() {
        return ToString.builder((String)"WorkloadJiraConfigurationInput").add("IssueManagementStatus", (Object)this.issueManagementStatusAsString()).add("IssueManagementType", (Object)this.issueManagementTypeAsString()).add("JiraProjectKey", (Object)this.jiraProjectKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IssueManagementStatus": {
                return Optional.ofNullable(clazz.cast(this.issueManagementStatusAsString()));
            }
            case "IssueManagementType": {
                return Optional.ofNullable(clazz.cast(this.issueManagementTypeAsString()));
            }
            case "JiraProjectKey": {
                return Optional.ofNullable(clazz.cast(this.jiraProjectKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IssueManagementStatus", ISSUE_MANAGEMENT_STATUS_FIELD);
        map.put("IssueManagementType", ISSUE_MANAGEMENT_TYPE_FIELD);
        map.put("JiraProjectKey", JIRA_PROJECT_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadJiraConfigurationInput, T> g) {
        return obj -> g.apply((WorkloadJiraConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issueManagementStatus;
        private String issueManagementType;
        private String jiraProjectKey;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadJiraConfigurationInput model) {
            this.issueManagementStatus(model.issueManagementStatus);
            this.issueManagementType(model.issueManagementType);
            this.jiraProjectKey(model.jiraProjectKey);
        }

        public final String getIssueManagementStatus() {
            return this.issueManagementStatus;
        }

        public final void setIssueManagementStatus(String issueManagementStatus) {
            this.issueManagementStatus = issueManagementStatus;
        }

        @Override
        public final Builder issueManagementStatus(String issueManagementStatus) {
            this.issueManagementStatus = issueManagementStatus;
            return this;
        }

        @Override
        public final Builder issueManagementStatus(WorkloadIssueManagementStatus issueManagementStatus) {
            this.issueManagementStatus(issueManagementStatus == null ? null : issueManagementStatus.toString());
            return this;
        }

        public final String getIssueManagementType() {
            return this.issueManagementType;
        }

        public final void setIssueManagementType(String issueManagementType) {
            this.issueManagementType = issueManagementType;
        }

        @Override
        public final Builder issueManagementType(String issueManagementType) {
            this.issueManagementType = issueManagementType;
            return this;
        }

        @Override
        public final Builder issueManagementType(IssueManagementType issueManagementType) {
            this.issueManagementType(issueManagementType == null ? null : issueManagementType.toString());
            return this;
        }

        public final String getJiraProjectKey() {
            return this.jiraProjectKey;
        }

        public final void setJiraProjectKey(String jiraProjectKey) {
            this.jiraProjectKey = jiraProjectKey;
        }

        @Override
        public final Builder jiraProjectKey(String jiraProjectKey) {
            this.jiraProjectKey = jiraProjectKey;
            return this;
        }

        public WorkloadJiraConfigurationInput build() {
            return new WorkloadJiraConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkloadJiraConfigurationInput> {
        public Builder issueManagementStatus(String var1);

        public Builder issueManagementStatus(WorkloadIssueManagementStatus var1);

        public Builder issueManagementType(String var1);

        public Builder issueManagementType(IssueManagementType var1);

        public Builder jiraProjectKey(String var1);
    }
}

