/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUsersResponse extends WorkDocsResponse implements
        ToCopyableBuilder<DescribeUsersResponse.Builder, DescribeUsersResponse> {
    private static final SdkField<List<User>> USERS_FIELD = SdkField
            .<List<User>> builder(MarshallingType.LIST)
            .memberName("Users")
            .getter(getter(DescribeUsersResponse::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<User> builder(MarshallingType.SDK_POJO)
                                            .constructor(User::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TOTAL_NUMBER_OF_USERS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumberOfUsers").getter(getter(DescribeUsersResponse::totalNumberOfUsers))
            .setter(setter(Builder::totalNumberOfUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfUsers").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeUsersResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERS_FIELD,
            TOTAL_NUMBER_OF_USERS_FIELD, MARKER_FIELD));

    private final List<User> users;

    private final Long totalNumberOfUsers;

    private final String marker;

    private DescribeUsersResponse(BuilderImpl builder) {
        super(builder);
        this.users = builder.users;
        this.totalNumberOfUsers = builder.totalNumberOfUsers;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return The users.
     */
    public final List<User> users() {
        return users;
    }

    /**
     * <p>
     * The total number of users included in the results.
     * </p>
     * 
     * @return The total number of users included in the results.
     * @deprecated
     */
    @Deprecated
    public final Long totalNumberOfUsers() {
        return totalNumberOfUsers;
    }

    /**
     * <p>
     * The marker to use when requesting the next set of results. If there are no additional results, the string is
     * empty.
     * </p>
     * 
     * @return The marker to use when requesting the next set of results. If there are no additional results, the string
     *         is empty.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfUsers());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUsersResponse)) {
            return false;
        }
        DescribeUsersResponse other = (DescribeUsersResponse) obj;
        return hasUsers() == other.hasUsers() && Objects.equals(users(), other.users())
                && Objects.equals(totalNumberOfUsers(), other.totalNumberOfUsers()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUsersResponse").add("Users", hasUsers() ? users() : null)
                .add("TotalNumberOfUsers", totalNumberOfUsers()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        case "TotalNumberOfUsers":
            return Optional.ofNullable(clazz.cast(totalNumberOfUsers()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUsersResponse, T> g) {
        return obj -> g.apply((DescribeUsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUsersResponse> {
        /**
         * <p>
         * The users.
         * </p>
         * 
         * @param users
         *        The users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<User> users);

        /**
         * <p>
         * The users.
         * </p>
         * 
         * @param users
         *        The users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(User... users);

        /**
         * <p>
         * The users.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workdocs.model.User.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.workdocs.model.User#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workdocs.model.User.Builder#build()} is called immediately and its
         * result is passed to {@link #users(List<User>)}.
         * 
         * @param users
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workdocs.model.User.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<User>)
         */
        Builder users(Consumer<User.Builder>... users);

        /**
         * <p>
         * The total number of users included in the results.
         * </p>
         * 
         * @param totalNumberOfUsers
         *        The total number of users included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder totalNumberOfUsers(Long totalNumberOfUsers);

        /**
         * <p>
         * The marker to use when requesting the next set of results. If there are no additional results, the string is
         * empty.
         * </p>
         * 
         * @param marker
         *        The marker to use when requesting the next set of results. If there are no additional results, the
         *        string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private List<User> users = DefaultSdkAutoConstructList.getInstance();

        private Long totalNumberOfUsers;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUsersResponse model) {
            super(model);
            users(model.users);
            totalNumberOfUsers(model.totalNumberOfUsers);
            marker(model.marker);
        }

        public final List<User.Builder> getUsers() {
            List<User.Builder> result = OrganizationUserListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = OrganizationUserListCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = OrganizationUserListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<User.Builder>... users) {
            users(Stream.of(users).map(c -> User.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final Long getTotalNumberOfUsers() {
            return totalNumberOfUsers;
        }

        @Deprecated
        public final void setTotalNumberOfUsers(Long totalNumberOfUsers) {
            this.totalNumberOfUsers = totalNumberOfUsers;
        }

        @Override
        @Deprecated
        public final Builder totalNumberOfUsers(Long totalNumberOfUsers) {
            this.totalNumberOfUsers = totalNumberOfUsers;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeUsersResponse build() {
            return new DescribeUsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
