/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filtering options for <i>ListUsers</i> operation. This is only used as input to Operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsersFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ListUsersFilters.Builder, ListUsersFilters> {
    private static final SdkField<String> USERNAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsernamePrefix").getter(getter(ListUsersFilters::usernamePrefix))
            .setter(setter(Builder::usernamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernamePrefix").build()).build();

    private static final SdkField<String> DISPLAY_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayNamePrefix").getter(getter(ListUsersFilters::displayNamePrefix))
            .setter(setter(Builder::displayNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayNamePrefix").build()).build();

    private static final SdkField<String> PRIMARY_EMAIL_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryEmailPrefix").getter(getter(ListUsersFilters::primaryEmailPrefix))
            .setter(setter(Builder::primaryEmailPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryEmailPrefix").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListUsersFilters::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_PREFIX_FIELD,
            DISPLAY_NAME_PREFIX_FIELD, PRIMARY_EMAIL_PREFIX_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String usernamePrefix;

    private final String displayNamePrefix;

    private final String primaryEmailPrefix;

    private final String state;

    private ListUsersFilters(BuilderImpl builder) {
        this.usernamePrefix = builder.usernamePrefix;
        this.displayNamePrefix = builder.displayNamePrefix;
        this.primaryEmailPrefix = builder.primaryEmailPrefix;
        this.state = builder.state;
    }

    /**
     * <p>
     * Filters only users with the provided username prefix.
     * </p>
     * 
     * @return Filters only users with the provided username prefix.
     */
    public final String usernamePrefix() {
        return usernamePrefix;
    }

    /**
     * <p>
     * Filters only users with the provided display name prefix.
     * </p>
     * 
     * @return Filters only users with the provided display name prefix.
     */
    public final String displayNamePrefix() {
        return displayNamePrefix;
    }

    /**
     * <p>
     * Filters only users with the provided email prefix.
     * </p>
     * 
     * @return Filters only users with the provided email prefix.
     */
    public final String primaryEmailPrefix() {
        return primaryEmailPrefix;
    }

    /**
     * <p>
     * Filters only users with the provided state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Filters only users with the provided state.
     * @see EntityState
     */
    public final EntityState state() {
        return EntityState.fromValue(state);
    }

    /**
     * <p>
     * Filters only users with the provided state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Filters only users with the provided state.
     * @see EntityState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usernamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(displayNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(primaryEmailPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersFilters)) {
            return false;
        }
        ListUsersFilters other = (ListUsersFilters) obj;
        return Objects.equals(usernamePrefix(), other.usernamePrefix())
                && Objects.equals(displayNamePrefix(), other.displayNamePrefix())
                && Objects.equals(primaryEmailPrefix(), other.primaryEmailPrefix())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUsersFilters").add("UsernamePrefix", usernamePrefix())
                .add("DisplayNamePrefix", displayNamePrefix() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PrimaryEmailPrefix", primaryEmailPrefix()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsernamePrefix":
            return Optional.ofNullable(clazz.cast(usernamePrefix()));
        case "DisplayNamePrefix":
            return Optional.ofNullable(clazz.cast(displayNamePrefix()));
        case "PrimaryEmailPrefix":
            return Optional.ofNullable(clazz.cast(primaryEmailPrefix()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUsersFilters, T> g) {
        return obj -> g.apply((ListUsersFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListUsersFilters> {
        /**
         * <p>
         * Filters only users with the provided username prefix.
         * </p>
         * 
         * @param usernamePrefix
         *        Filters only users with the provided username prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernamePrefix(String usernamePrefix);

        /**
         * <p>
         * Filters only users with the provided display name prefix.
         * </p>
         * 
         * @param displayNamePrefix
         *        Filters only users with the provided display name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayNamePrefix(String displayNamePrefix);

        /**
         * <p>
         * Filters only users with the provided email prefix.
         * </p>
         * 
         * @param primaryEmailPrefix
         *        Filters only users with the provided email prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryEmailPrefix(String primaryEmailPrefix);

        /**
         * <p>
         * Filters only users with the provided state.
         * </p>
         * 
         * @param state
         *        Filters only users with the provided state.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(String state);

        /**
         * <p>
         * Filters only users with the provided state.
         * </p>
         * 
         * @param state
         *        Filters only users with the provided state.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(EntityState state);
    }

    static final class BuilderImpl implements Builder {
        private String usernamePrefix;

        private String displayNamePrefix;

        private String primaryEmailPrefix;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersFilters model) {
            usernamePrefix(model.usernamePrefix);
            displayNamePrefix(model.displayNamePrefix);
            primaryEmailPrefix(model.primaryEmailPrefix);
            state(model.state);
        }

        public final String getUsernamePrefix() {
            return usernamePrefix;
        }

        public final void setUsernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
        }

        @Override
        public final Builder usernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
            return this;
        }

        public final String getDisplayNamePrefix() {
            return displayNamePrefix;
        }

        public final void setDisplayNamePrefix(String displayNamePrefix) {
            this.displayNamePrefix = displayNamePrefix;
        }

        @Override
        public final Builder displayNamePrefix(String displayNamePrefix) {
            this.displayNamePrefix = displayNamePrefix;
            return this;
        }

        public final String getPrimaryEmailPrefix() {
            return primaryEmailPrefix;
        }

        public final void setPrimaryEmailPrefix(String primaryEmailPrefix) {
            this.primaryEmailPrefix = primaryEmailPrefix;
        }

        @Override
        public final Builder primaryEmailPrefix(String primaryEmailPrefix) {
            this.primaryEmailPrefix = primaryEmailPrefix;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public ListUsersFilters build() {
            return new ListUsersFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
