/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationResponse;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.CreateTagsRequest;
import software.amazon.awssdk.services.workspaces.model.CreateTagsResponse;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest;
import software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsResponse;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationResponse;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateResponse;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionResponse;
import software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsPublisher;
import software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsPublisher;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesPublisher;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesPublisher;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesPublisher;

/**
 * Service client for accessing Amazon WorkSpaces asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Amazon WorkSpaces Service</fullname>
 * <p>
 * Amazon WorkSpaces enables you to provision virtual, cloud-based Microsoft Windows or Amazon Linux desktops for your
 * users, known as <i>WorkSpaces</i>. WorkSpaces eliminates the need to procure and deploy hardware or install complex
 * software. You can quickly add or remove users as your needs change. Users can access their virtual desktops from
 * multiple devices or web browsers.
 * </p>
 * <p>
 * This API Reference provides detailed information about the actions, data types, parameters, and errors of the
 * WorkSpaces service. For more information about the supported Amazon Web Services Regions, endpoints, and service
 * quotas of the Amazon WorkSpaces service, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/wsp.html">WorkSpaces endpoints and quotas</a> in the <i>Amazon
 * Web Services General Reference</i>.
 * </p>
 * <p>
 * You can also manage your WorkSpaces resources using the WorkSpaces console, Command Line Interface (CLI), and SDKs.
 * For more information about administering WorkSpaces, see the <a
 * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/">Amazon WorkSpaces Administration Guide</a>. For more
 * information about using the Amazon WorkSpaces client application or web browser to access provisioned WorkSpaces, see
 * the <a href="https://docs.aws.amazon.com/workspaces/latest/userguide/">Amazon WorkSpaces User Guide</a>. For more
 * information about using the CLI to manage your WorkSpaces resources, see the <a
 * href="https://docs.aws.amazon.com/cli/latest/reference/workspaces/index.html">WorkSpaces section of the CLI
 * Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkSpacesAsyncClient extends AwsClient {
    String SERVICE_NAME = "workspaces";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workspaces";

    /**
     * <p>
     * Associates the specified connection alias with the specified directory to enable cross-Region redirection. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note>
     *
     * @param associateConnectionAliasRequest
     * @return A Java Future containing the result of the AssociateConnectionAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.AssociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateConnectionAliasResponse> associateConnectionAlias(
            AssociateConnectionAliasRequest associateConnectionAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified connection alias with the specified directory to enable cross-Region redirection. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateConnectionAliasRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateConnectionAliasRequest#builder()}
     * </p>
     *
     * @param associateConnectionAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateConnectionAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.AssociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateConnectionAliasResponse> associateConnectionAlias(
            Consumer<AssociateConnectionAliasRequest.Builder> associateConnectionAliasRequest) {
        return associateConnectionAlias(AssociateConnectionAliasRequest.builder().applyMutation(associateConnectionAliasRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified IP access control group with the specified directory.
     * </p>
     *
     * @param associateIpGroupsRequest
     * @return A Java Future containing the result of the AssociateIpGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.AssociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateIpGroupsResponse> associateIpGroups(AssociateIpGroupsRequest associateIpGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified IP access control group with the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIpGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateIpGroupsRequest#builder()}
     * </p>
     *
     * @param associateIpGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateIpGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.AssociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateIpGroupsResponse> associateIpGroups(
            Consumer<AssociateIpGroupsRequest.Builder> associateIpGroupsRequest) {
        return associateIpGroups(AssociateIpGroupsRequest.builder().applyMutation(associateIpGroupsRequest).build());
    }

    /**
     * <p>
     * Associates the specified application to the specified WorkSpace.
     * </p>
     *
     * @param associateWorkspaceApplicationRequest
     * @return A Java Future containing the result of the AssociateWorkspaceApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceInUseException The specified resource is currently in use.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ComputeNotCompatibleException The compute type of the WorkSpace is not compatible with the
     *         application.</li>
     *         <li>OperatingSystemNotCompatibleException The operating system of the WorkSpace is not compatible with
     *         the application.</li>
     *         <li>ApplicationNotSupportedException The specified application is not supported.</li>
     *         <li>IncompatibleApplicationsException The specified application is not compatible with the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.AssociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWorkspaceApplicationResponse> associateWorkspaceApplication(
            AssociateWorkspaceApplicationRequest associateWorkspaceApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified application to the specified WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWorkspaceApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateWorkspaceApplicationRequest#builder()}
     * </p>
     *
     * @param associateWorkspaceApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateWorkspaceApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceInUseException The specified resource is currently in use.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ComputeNotCompatibleException The compute type of the WorkSpace is not compatible with the
     *         application.</li>
     *         <li>OperatingSystemNotCompatibleException The operating system of the WorkSpace is not compatible with
     *         the application.</li>
     *         <li>ApplicationNotSupportedException The specified application is not supported.</li>
     *         <li>IncompatibleApplicationsException The specified application is not compatible with the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.AssociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateWorkspaceApplicationResponse> associateWorkspaceApplication(
            Consumer<AssociateWorkspaceApplicationRequest.Builder> associateWorkspaceApplicationRequest) {
        return associateWorkspaceApplication(AssociateWorkspaceApplicationRequest.builder()
                .applyMutation(associateWorkspaceApplicationRequest).build());
    }

    /**
     * <p>
     * Adds one or more rules to the specified IP access control group.
     * </p>
     * <p>
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the
     * rules.
     * </p>
     *
     * @param authorizeIpRulesRequest
     * @return A Java Future containing the result of the AuthorizeIpRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.AuthorizeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AuthorizeIpRulesResponse> authorizeIpRules(AuthorizeIpRulesRequest authorizeIpRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more rules to the specified IP access control group.
     * </p>
     * <p>
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the
     * rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeIpRulesRequest.Builder} avoiding the need
     * to create one manually via {@link AuthorizeIpRulesRequest#builder()}
     * </p>
     *
     * @param authorizeIpRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AuthorizeIpRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.AuthorizeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AuthorizeIpRulesResponse> authorizeIpRules(
            Consumer<AuthorizeIpRulesRequest.Builder> authorizeIpRulesRequest) {
        return authorizeIpRules(AuthorizeIpRulesRequest.builder().applyMutation(authorizeIpRulesRequest).build());
    }

    /**
     * <p>
     * Copies the specified image from the specified Region to the current Region. For more information about copying
     * images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html"> Copy a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services
     * Support.
     * </p>
     * <important>
     * <p>
     * Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services
     * account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns
     * an image, use the <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkSpaceImages</a> and <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html"
     * >DescribeWorkspaceImagePermissions</a> API operations.
     * </p>
     * </important>
     *
     * @param copyWorkspaceImageRequest
     * @return A Java Future containing the result of the CopyWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CopyWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyWorkspaceImageResponse> copyWorkspaceImage(CopyWorkspaceImageRequest copyWorkspaceImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified image from the specified Region to the current Region. For more information about copying
     * images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html"> Copy a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services
     * Support.
     * </p>
     * <important>
     * <p>
     * Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services
     * account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns
     * an image, use the <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkSpaceImages</a> and <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html"
     * >DescribeWorkspaceImagePermissions</a> API operations.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link CopyWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param copyWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CopyWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyWorkspaceImageResponse> copyWorkspaceImage(
            Consumer<CopyWorkspaceImageRequest.Builder> copyWorkspaceImageRequest) {
        return copyWorkspaceImage(CopyWorkspaceImageRequest.builder().applyMutation(copyWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client
     * add-in within a directory.
     * </p>
     * <p>
     * This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.
     * </p>
     *
     * @param createConnectClientAddInRequest
     * @return A Java Future containing the result of the CreateConnectClientAddIn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceCreationFailedException The resource could not be created.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectClientAddInResponse> createConnectClientAddIn(
            CreateConnectClientAddInRequest createConnectClientAddInRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client
     * add-in within a directory.
     * </p>
     * <p>
     * This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectClientAddInRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConnectClientAddInRequest#builder()}
     * </p>
     *
     * @param createConnectClientAddInRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateConnectClientAddIn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceCreationFailedException The resource could not be created.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectClientAddInResponse> createConnectClientAddIn(
            Consumer<CreateConnectClientAddInRequest.Builder> createConnectClientAddInRequest) {
        return createConnectClientAddIn(CreateConnectClientAddInRequest.builder().applyMutation(createConnectClientAddInRequest)
                .build());
    }

    /**
     * <p>
     * Creates the specified connection alias for use with cross-Region redirection. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param createConnectionAliasRequest
     * @return A Java Future containing the result of the CreateConnectionAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectionAliasResponse> createConnectionAlias(
            CreateConnectionAliasRequest createConnectionAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified connection alias for use with cross-Region redirection. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionAliasRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConnectionAliasRequest#builder()}
     * </p>
     *
     * @param createConnectionAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConnectionAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectionAliasResponse> createConnectionAlias(
            Consumer<CreateConnectionAliasRequest.Builder> createConnectionAliasRequest) {
        return createConnectionAlias(CreateConnectionAliasRequest.builder().applyMutation(createConnectionAliasRequest).build());
    }

    /**
     * <p>
     * Creates an IP access control group.
     * </p>
     * <p>
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed
     * to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and
     * then associate the group with your directory. You can add rules when you create the group or at any time using
     * <a>AuthorizeIpRules</a>.
     * </p>
     * <p>
     * There is a default IP access control group associated with your directory. If you don't associate an IP access
     * control group with your directory, the default group is used. The default group includes a default rule that
     * allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for
     * your directory.
     * </p>
     *
     * @param createIpGroupRequest
     * @return A Java Future containing the result of the CreateIpGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceCreationFailedException The resource could not be created.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpGroupResponse> createIpGroup(CreateIpGroupRequest createIpGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IP access control group.
     * </p>
     * <p>
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed
     * to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and
     * then associate the group with your directory. You can add rules when you create the group or at any time using
     * <a>AuthorizeIpRules</a>.
     * </p>
     * <p>
     * There is a default IP access control group associated with your directory. If you don't associate an IP access
     * control group with your directory, the default group is used. The default group includes a default rule that
     * allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for
     * your directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpGroupRequest#builder()}
     * </p>
     *
     * @param createIpGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIpGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceCreationFailedException The resource could not be created.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpGroupResponse> createIpGroup(Consumer<CreateIpGroupRequest.Builder> createIpGroupRequest) {
        return createIpGroup(CreateIpGroupRequest.builder().applyMutation(createIpGroupRequest).build());
    }

    /**
     * <p>
     * Creates a standby WorkSpace in a secondary Region.
     * </p>
     *
     * @param createStandbyWorkspacesRequest
     * @return A Java Future containing the result of the CreateStandbyWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateStandbyWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateStandbyWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStandbyWorkspacesResponse> createStandbyWorkspaces(
            CreateStandbyWorkspacesRequest createStandbyWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a standby WorkSpace in a secondary Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStandbyWorkspacesRequest.Builder} avoiding
     * the need to create one manually via {@link CreateStandbyWorkspacesRequest#builder()}
     * </p>
     *
     * @param createStandbyWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateStandbyWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateStandbyWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateStandbyWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStandbyWorkspacesResponse> createStandbyWorkspaces(
            Consumer<CreateStandbyWorkspacesRequest.Builder> createStandbyWorkspacesRequest) {
        return createStandbyWorkspaces(CreateStandbyWorkspacesRequest.builder().applyMutation(createStandbyWorkspacesRequest)
                .build());
    }

    /**
     * <p>
     * Creates the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param createTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified tags for the specified WorkSpaces resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has
     * the latest drivers and other updates required by the Amazon WorkSpaces components.
     * </p>
     * <p>
     * To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkspaceImages</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at
     * this time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Microsoft Windows updates and other application updates are not included in the update process.
     * </p>
     * </li>
     * <li>
     * <p>
     * The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated
     * image and created a new bundle.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUpdatedWorkspaceImageRequest
     * @return A Java Future containing the result of the CreateUpdatedWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateUpdatedWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUpdatedWorkspaceImageResponse> createUpdatedWorkspaceImage(
            CreateUpdatedWorkspaceImageRequest createUpdatedWorkspaceImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has
     * the latest drivers and other updates required by the Amazon WorkSpaces components.
     * </p>
     * <p>
     * To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkspaceImages</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at
     * this time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Microsoft Windows updates and other application updates are not included in the update process.
     * </p>
     * </li>
     * <li>
     * <p>
     * The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated
     * image and created a new bundle.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUpdatedWorkspaceImageRequest.Builder}
     * avoiding the need to create one manually via {@link CreateUpdatedWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param createUpdatedWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateUpdatedWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateUpdatedWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUpdatedWorkspaceImageResponse> createUpdatedWorkspaceImage(
            Consumer<CreateUpdatedWorkspaceImageRequest.Builder> createUpdatedWorkspaceImageRequest) {
        return createUpdatedWorkspaceImage(CreateUpdatedWorkspaceImageRequest.builder()
                .applyMutation(createUpdatedWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html"> Create a Custom
     * WorkSpaces Image and Bundle</a>.
     * </p>
     *
     * @param createWorkspaceBundleRequest
     * @return A Java Future containing the result of the CreateWorkspaceBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceBundleResponse> createWorkspaceBundle(
            CreateWorkspaceBundleRequest createWorkspaceBundleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html"> Create a Custom
     * WorkSpaces Image and Bundle</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceBundleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkspaceBundleRequest#builder()}
     * </p>
     *
     * @param createWorkspaceBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkspaceBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceBundleResponse> createWorkspaceBundle(
            Consumer<CreateWorkspaceBundleRequest.Builder> createWorkspaceBundleRequest) {
        return createWorkspaceBundle(CreateWorkspaceBundleRequest.builder().applyMutation(createWorkspaceBundleRequest).build());
    }

    /**
     * <p>
     * Creates a new WorkSpace image from an existing WorkSpace.
     * </p>
     *
     * @param createWorkspaceImageRequest
     * @return A Java Future containing the result of the CreateWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceImageResponse> createWorkspaceImage(
            CreateWorkspaceImageRequest createWorkspaceImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new WorkSpace image from an existing WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param createWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceImageResponse> createWorkspaceImage(
            Consumer<CreateWorkspaceImageRequest.Builder> createWorkspaceImageRequest) {
        return createWorkspaceImage(CreateWorkspaceImageRequest.builder().applyMutation(createWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Creates one or more WorkSpaces.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces are created.
     * </p>
     * <note>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </note>
     *
     * @param createWorkspacesRequest
     * @return A Java Future containing the result of the CreateWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkspacesResponse> createWorkspaces(CreateWorkspacesRequest createWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more WorkSpaces.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces are created.
     * </p>
     * <note>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkspacesRequest#builder()}
     * </p>
     *
     * @param createWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.CreateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkspacesResponse> createWorkspaces(
            Consumer<CreateWorkspacesRequest.Builder> createWorkspacesRequest) {
        return createWorkspaces(CreateWorkspacesRequest.builder().applyMutation(createWorkspacesRequest).build());
    }

    /**
     * <p>
     * Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal.
     * You can tailor your login portal company logo, the support email address, support link, link to reset password,
     * and a custom message for users trying to sign in.
     * </p>
     * <p>
     * After you delete your customized client branding, your login portal reverts to the default client branding.
     * </p>
     *
     * @param deleteClientBrandingRequest
     * @return A Java Future containing the result of the DeleteClientBranding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClientBrandingResponse> deleteClientBranding(
            DeleteClientBrandingRequest deleteClientBrandingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal.
     * You can tailor your login portal company logo, the support email address, support link, link to reset password,
     * and a custom message for users trying to sign in.
     * </p>
     * <p>
     * After you delete your customized client branding, your login portal reverts to the default client branding.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClientBrandingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClientBrandingRequest#builder()}
     * </p>
     *
     * @param deleteClientBrandingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteClientBranding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClientBrandingResponse> deleteClientBranding(
            Consumer<DeleteClientBrandingRequest.Builder> deleteClientBrandingRequest) {
        return deleteClientBranding(DeleteClientBrandingRequest.builder().applyMutation(deleteClientBrandingRequest).build());
    }

    /**
     * <p>
     * Deletes a client-add-in for Amazon Connect that is configured within a directory.
     * </p>
     *
     * @param deleteConnectClientAddInRequest
     * @return A Java Future containing the result of the DeleteConnectClientAddIn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectClientAddInResponse> deleteConnectClientAddIn(
            DeleteConnectClientAddInRequest deleteConnectClientAddInRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a client-add-in for Amazon Connect that is configured within a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectClientAddInRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConnectClientAddInRequest#builder()}
     * </p>
     *
     * @param deleteConnectClientAddInRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteConnectClientAddIn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectClientAddInResponse> deleteConnectClientAddIn(
            Consumer<DeleteConnectClientAddInRequest.Builder> deleteConnectClientAddInRequest) {
        return deleteConnectClientAddIn(DeleteConnectClientAddInRequest.builder().applyMutation(deleteConnectClientAddInRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <important>
     * <p>
     * <b>If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your
     * WorkSpaces users, you must take certain precautions to prevent potential security issues.</b> For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations"
     * > Security Considerations if You Stop Using Cross-Region Redirection</a>.
     * </p>
     * </important> <note>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </note>
     *
     * @param deleteConnectionAliasRequest
     * @return A Java Future containing the result of the DeleteConnectionAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionAliasResponse> deleteConnectionAlias(
            DeleteConnectionAliasRequest deleteConnectionAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <important>
     * <p>
     * <b>If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your
     * WorkSpaces users, you must take certain precautions to prevent potential security issues.</b> For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations"
     * > Security Considerations if You Stop Using Cross-Region Redirection</a>.
     * </p>
     * </important> <note>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConnectionAliasRequest#builder()}
     * </p>
     *
     * @param deleteConnectionAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConnectionAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionAliasResponse> deleteConnectionAlias(
            Consumer<DeleteConnectionAliasRequest.Builder> deleteConnectionAliasRequest) {
        return deleteConnectionAlias(DeleteConnectionAliasRequest.builder().applyMutation(deleteConnectionAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the specified IP access control group.
     * </p>
     * <p>
     * You cannot delete an IP access control group that is associated with a directory.
     * </p>
     *
     * @param deleteIpGroupRequest
     * @return A Java Future containing the result of the DeleteIpGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpGroupResponse> deleteIpGroup(DeleteIpGroupRequest deleteIpGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified IP access control group.
     * </p>
     * <p>
     * You cannot delete an IP access control group that is associated with a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpGroupRequest#builder()}
     * </p>
     *
     * @param deleteIpGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIpGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpGroupResponse> deleteIpGroup(Consumer<DeleteIpGroupRequest.Builder> deleteIpGroupRequest) {
        return deleteIpGroup(DeleteIpGroupRequest.builder().applyMutation(deleteIpGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags from the specified WorkSpaces resource.
     * </p>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags from the specified WorkSpaces resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html"> Delete a Custom WorkSpaces
     * Bundle or Image</a>.
     * </p>
     *
     * @param deleteWorkspaceBundleRequest
     * @return A Java Future containing the result of the DeleteWorkspaceBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceBundleResponse> deleteWorkspaceBundle(
            DeleteWorkspaceBundleRequest deleteWorkspaceBundleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html"> Delete a Custom WorkSpaces
     * Bundle or Image</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceBundleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkspaceBundleRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkspaceBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceBundleResponse> deleteWorkspaceBundle(
            Consumer<DeleteWorkspaceBundleRequest.Builder> deleteWorkspaceBundleRequest) {
        return deleteWorkspaceBundle(DeleteWorkspaceBundleRequest.builder().applyMutation(deleteWorkspaceBundleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are
     * associated with the image and unshare the image if it is shared with other accounts.
     * </p>
     *
     * @param deleteWorkspaceImageRequest
     * @return A Java Future containing the result of the DeleteWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceImageResponse> deleteWorkspaceImage(
            DeleteWorkspaceImageRequest deleteWorkspaceImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are
     * associated with the image and unshare the image if it is shared with other accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeleteWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceImageResponse> deleteWorkspaceImage(
            Consumer<DeleteWorkspaceImageRequest.Builder> deleteWorkspaceImageRequest) {
        return deleteWorkspaceImage(DeleteWorkspaceImageRequest.builder().applyMutation(deleteWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Deploys associated applications to the specified WorkSpace
     * </p>
     *
     * @param deployWorkspaceApplicationsRequest
     * @return A Java Future containing the result of the DeployWorkspaceApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceInUseException The specified resource is currently in use.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>IncompatibleApplicationsException The specified application is not compatible with the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeployWorkspaceApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeployWorkspaceApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeployWorkspaceApplicationsResponse> deployWorkspaceApplications(
            DeployWorkspaceApplicationsRequest deployWorkspaceApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys associated applications to the specified WorkSpace
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeployWorkspaceApplicationsRequest.Builder}
     * avoiding the need to create one manually via {@link DeployWorkspaceApplicationsRequest#builder()}
     * </p>
     *
     * @param deployWorkspaceApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeployWorkspaceApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceInUseException The specified resource is currently in use.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>IncompatibleApplicationsException The specified application is not compatible with the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeployWorkspaceApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeployWorkspaceApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeployWorkspaceApplicationsResponse> deployWorkspaceApplications(
            Consumer<DeployWorkspaceApplicationsRequest.Builder> deployWorkspaceApplicationsRequest) {
        return deployWorkspaceApplications(DeployWorkspaceApplicationsRequest.builder()
                .applyMutation(deployWorkspaceApplicationsRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister
     * the directory.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note>
     *
     * @param deregisterWorkspaceDirectoryRequest
     * @return A Java Future containing the result of the DeregisterWorkspaceDirectory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeregisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterWorkspaceDirectoryResponse> deregisterWorkspaceDirectory(
            DeregisterWorkspaceDirectoryRequest deregisterWorkspaceDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister
     * the directory.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterWorkspaceDirectoryRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterWorkspaceDirectoryRequest#builder()}
     * </p>
     *
     * @param deregisterWorkspaceDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeregisterWorkspaceDirectory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DeregisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterWorkspaceDirectoryResponse> deregisterWorkspaceDirectory(
            Consumer<DeregisterWorkspaceDirectoryRequest.Builder> deregisterWorkspaceDirectoryRequest) {
        return deregisterWorkspaceDirectory(DeregisterWorkspaceDirectoryRequest.builder()
                .applyMutation(deregisterWorkspaceDirectoryRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param describeAccountRequest
     * @return A Java Future containing the result of the DescribeAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountResponse> describeAccount(DescribeAccountRequest describeAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAccountRequest#builder()}
     * </p>
     *
     * @param describeAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountResponse> describeAccount(
            Consumer<DescribeAccountRequest.Builder> describeAccountRequest) {
        return describeAccount(DescribeAccountRequest.builder().applyMutation(describeAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the
     * specified account.
     * </p>
     *
     * @param describeAccountModificationsRequest
     * @return A Java Future containing the result of the DescribeAccountModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeAccountModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountModificationsResponse> describeAccountModifications(
            DescribeAccountModificationsRequest describeAccountModificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the
     * specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountModificationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAccountModificationsRequest#builder()}
     * </p>
     *
     * @param describeAccountModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAccountModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeAccountModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountModificationsResponse> describeAccountModifications(
            Consumer<DescribeAccountModificationsRequest.Builder> describeAccountModificationsRequest) {
        return describeAccountModifications(DescribeAccountModificationsRequest.builder()
                .applyMutation(describeAccountModificationsRequest).build());
    }

    /**
     * <p>
     * Describes the associations between the application and the specified associated resources.
     * </p>
     *
     * @param describeApplicationAssociationsRequest
     * @return A Java Future containing the result of the DescribeApplicationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeApplicationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationAssociationsResponse> describeApplicationAssociations(
            DescribeApplicationAssociationsRequest describeApplicationAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the associations between the application and the specified associated resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationAssociationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeApplicationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeApplicationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationAssociationsResponse> describeApplicationAssociations(
            Consumer<DescribeApplicationAssociationsRequest.Builder> describeApplicationAssociationsRequest) {
        return describeApplicationAssociations(DescribeApplicationAssociationsRequest.builder()
                .applyMutation(describeApplicationAssociationsRequest).build());
    }

    /**
     * <p>
     * Describes the associations between the application and the specified associated resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeApplicationAssociations(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsPublisher publisher = client.describeApplicationAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsPublisher publisher = client.describeApplicationAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicationAssociations(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeApplicationAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeApplicationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationAssociationsPublisher describeApplicationAssociationsPaginator(
            DescribeApplicationAssociationsRequest describeApplicationAssociationsRequest) {
        return new DescribeApplicationAssociationsPublisher(this, describeApplicationAssociationsRequest);
    }

    /**
     * <p>
     * Describes the associations between the application and the specified associated resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeApplicationAssociations(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsPublisher publisher = client.describeApplicationAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationAssociationsPublisher publisher = client.describeApplicationAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicationAssociations(software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationAssociationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeApplicationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationAssociationsPublisher describeApplicationAssociationsPaginator(
            Consumer<DescribeApplicationAssociationsRequest.Builder> describeApplicationAssociationsRequest) {
        return describeApplicationAssociationsPaginator(DescribeApplicationAssociationsRequest.builder()
                .applyMutation(describeApplicationAssociationsRequest).build());
    }

    /**
     * <p>
     * Describes the specified applications by filtering based on their compute types, license availability, operating
     * systems, and owners.
     * </p>
     *
     * @param describeApplicationsRequest
     * @return A Java Future containing the result of the DescribeApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationsResponse> describeApplications(
            DescribeApplicationsRequest describeApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified applications by filtering based on their compute types, license availability, operating
     * systems, and owners.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationsResponse> describeApplications(
            Consumer<DescribeApplicationsRequest.Builder> describeApplicationsRequest) {
        return describeApplications(DescribeApplicationsRequest.builder().applyMutation(describeApplicationsRequest).build());
    }

    /**
     * <p>
     * Describes the specified applications by filtering based on their compute types, license availability, operating
     * systems, and owners.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeApplications(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsPublisher publisher = client.describeApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsPublisher publisher = client.describeApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplications(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsPublisher describeApplicationsPaginator(DescribeApplicationsRequest describeApplicationsRequest) {
        return new DescribeApplicationsPublisher(this, describeApplicationsRequest);
    }

    /**
     * <p>
     * Describes the specified applications by filtering based on their compute types, license availability, operating
     * systems, and owners.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeApplications(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsPublisher publisher = client.describeApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeApplicationsPublisher publisher = client.describeApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplications(software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsPublisher describeApplicationsPaginator(
            Consumer<DescribeApplicationsRequest.Builder> describeApplicationsRequest) {
        return describeApplicationsPaginator(DescribeApplicationsRequest.builder().applyMutation(describeApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified bundle.
     * </p>
     *
     * @param describeBundleAssociationsRequest
     * @return A Java Future containing the result of the DescribeBundleAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeBundleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeBundleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBundleAssociationsResponse> describeBundleAssociations(
            DescribeBundleAssociationsRequest describeBundleAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBundleAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBundleAssociationsRequest#builder()}
     * </p>
     *
     * @param describeBundleAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeBundleAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeBundleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeBundleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBundleAssociationsResponse> describeBundleAssociations(
            Consumer<DescribeBundleAssociationsRequest.Builder> describeBundleAssociationsRequest) {
        return describeBundleAssociations(DescribeBundleAssociationsRequest.builder()
                .applyMutation(describeBundleAssociationsRequest).build());
    }

    /**
     * <p>
     * Describes the specified client branding. Client branding allows you to customize the log in page of various
     * device types for your users. You can add your company logo, the support email address, support link, link to
     * reset password, and a custom message for users trying to sign in.
     * </p>
     * <note>
     * <p>
     * Only device types that have branding information configured will be shown in the response.
     * </p>
     * </note>
     *
     * @param describeClientBrandingRequest
     * @return A Java Future containing the result of the DescribeClientBranding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClientBrandingResponse> describeClientBranding(
            DescribeClientBrandingRequest describeClientBrandingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified client branding. Client branding allows you to customize the log in page of various
     * device types for your users. You can add your company logo, the support email address, support link, link to
     * reset password, and a custom message for users trying to sign in.
     * </p>
     * <note>
     * <p>
     * Only device types that have branding information configured will be shown in the response.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClientBrandingRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeClientBrandingRequest#builder()}
     * </p>
     *
     * @param describeClientBrandingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClientBranding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClientBrandingResponse> describeClientBranding(
            Consumer<DescribeClientBrandingRequest.Builder> describeClientBrandingRequest) {
        return describeClientBranding(DescribeClientBrandingRequest.builder().applyMutation(describeClientBrandingRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param describeClientPropertiesRequest
     * @return A Java Future containing the result of the DescribeClientProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClientPropertiesResponse> describeClientProperties(
            DescribeClientPropertiesRequest describeClientPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClientPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClientPropertiesRequest#builder()}
     * </p>
     *
     * @param describeClientPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeClientProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClientPropertiesResponse> describeClientProperties(
            Consumer<DescribeClientPropertiesRequest.Builder> describeClientPropertiesRequest) {
        return describeClientProperties(DescribeClientPropertiesRequest.builder().applyMutation(describeClientPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of Amazon Connect client add-ins that have been created.
     * </p>
     *
     * @param describeConnectClientAddInsRequest
     * @return A Java Future containing the result of the DescribeConnectClientAddIns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeConnectClientAddIns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectClientAddInsResponse> describeConnectClientAddIns(
            DescribeConnectClientAddInsRequest describeConnectClientAddInsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of Amazon Connect client add-ins that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectClientAddInsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConnectClientAddInsRequest#builder()}
     * </p>
     *
     * @param describeConnectClientAddInsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConnectClientAddIns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeConnectClientAddIns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectClientAddInsResponse> describeConnectClientAddIns(
            Consumer<DescribeConnectClientAddInsRequest.Builder> describeConnectClientAddInsRequest) {
        return describeConnectClientAddIns(DescribeConnectClientAddInsRequest.builder()
                .applyMutation(describeConnectClientAddInsRequest).build());
    }

    /**
     * <p>
     * Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account
     * for the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param describeConnectionAliasPermissionsRequest
     * @return A Java Future containing the result of the DescribeConnectionAliasPermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeConnectionAliasPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectionAliasPermissionsResponse> describeConnectionAliasPermissions(
            DescribeConnectionAliasPermissionsRequest describeConnectionAliasPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account
     * for the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionAliasPermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConnectionAliasPermissionsRequest#builder()}
     * </p>
     *
     * @param describeConnectionAliasPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeConnectionAliasPermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeConnectionAliasPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectionAliasPermissionsResponse> describeConnectionAliasPermissions(
            Consumer<DescribeConnectionAliasPermissionsRequest.Builder> describeConnectionAliasPermissionsRequest) {
        return describeConnectionAliasPermissions(DescribeConnectionAliasPermissionsRequest.builder()
                .applyMutation(describeConnectionAliasPermissionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information,
     * see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
     * Cross-Region Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param describeConnectionAliasesRequest
     * @return A Java Future containing the result of the DescribeConnectionAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeConnectionAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectionAliasesResponse> describeConnectionAliases(
            DescribeConnectionAliasesRequest describeConnectionAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information,
     * see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
     * Cross-Region Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionAliasesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConnectionAliasesRequest#builder()}
     * </p>
     *
     * @param describeConnectionAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConnectionAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeConnectionAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectionAliasesResponse> describeConnectionAliases(
            Consumer<DescribeConnectionAliasesRequest.Builder> describeConnectionAliasesRequest) {
        return describeConnectionAliases(DescribeConnectionAliasesRequest.builder()
                .applyMutation(describeConnectionAliasesRequest).build());
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified image.
     * </p>
     *
     * @param describeImageAssociationsRequest
     * @return A Java Future containing the result of the DescribeImageAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeImageAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeImageAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeImageAssociationsResponse> describeImageAssociations(
            DescribeImageAssociationsRequest describeImageAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeImageAssociationsRequest#builder()}
     * </p>
     *
     * @param describeImageAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeImageAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeImageAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeImageAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeImageAssociationsResponse> describeImageAssociations(
            Consumer<DescribeImageAssociationsRequest.Builder> describeImageAssociationsRequest) {
        return describeImageAssociations(DescribeImageAssociationsRequest.builder()
                .applyMutation(describeImageAssociationsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     *
     * @param describeIpGroupsRequest
     * @return A Java Future containing the result of the DescribeIpGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIpGroupsResponse> describeIpGroups(DescribeIpGroupsRequest describeIpGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIpGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeIpGroupsRequest#builder()}
     * </p>
     *
     * @param describeIpGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeIpGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIpGroupsResponse> describeIpGroups(
            Consumer<DescribeIpGroupsRequest.Builder> describeIpGroupsRequest) {
        return describeIpGroups(DescribeIpGroupsRequest.builder().applyMutation(describeIpGroupsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeIpGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIpGroupsResponse> describeIpGroups() {
        return describeIpGroups(DescribeIpGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified tags for the specified WorkSpaces resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Describes the associations betweens applications and the specified WorkSpace.
     * </p>
     *
     * @param describeWorkspaceAssociationsRequest
     * @return A Java Future containing the result of the DescribeWorkspaceAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceAssociationsResponse> describeWorkspaceAssociations(
            DescribeWorkspaceAssociationsRequest describeWorkspaceAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the associations betweens applications and the specified WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceAssociationsRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeWorkspaceAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceAssociationsResponse> describeWorkspaceAssociations(
            Consumer<DescribeWorkspaceAssociationsRequest.Builder> describeWorkspaceAssociationsRequest) {
        return describeWorkspaceAssociations(DescribeWorkspaceAssociationsRequest.builder()
                .applyMutation(describeWorkspaceAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     * @return A Java Future containing the result of the DescribeWorkspaceBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceBundlesResponse> describeWorkspaceBundles(
            DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceBundlesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceBundlesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeWorkspaceBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceBundlesResponse> describeWorkspaceBundles(
            Consumer<DescribeWorkspaceBundlesRequest.Builder> describeWorkspaceBundlesRequest) {
        return describeWorkspaceBundles(DescribeWorkspaceBundlesRequest.builder().applyMutation(describeWorkspaceBundlesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeWorkspaceBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceBundlesResponse> describeWorkspaceBundles() {
        return describeWorkspaceBundles(DescribeWorkspaceBundlesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesPublisher publisher = client.describeWorkspaceBundlesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesPublisher publisher = client.describeWorkspaceBundlesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesPublisher describeWorkspaceBundlesPaginator() {
        return describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesPublisher publisher = client.describeWorkspaceBundlesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesPublisher publisher = client.describeWorkspaceBundlesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesPublisher describeWorkspaceBundlesPaginator(
            DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) {
        return new DescribeWorkspaceBundlesPublisher(this, describeWorkspaceBundlesRequest);
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesPublisher publisher = client.describeWorkspaceBundlesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesPublisher publisher = client.describeWorkspaceBundlesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceBundlesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceBundlesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceBundlesPublisher describeWorkspaceBundlesPaginator(
            Consumer<DescribeWorkspaceBundlesRequest.Builder> describeWorkspaceBundlesRequest) {
        return describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest.builder()
                .applyMutation(describeWorkspaceBundlesRequest).build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     * @return A Java Future containing the result of the DescribeWorkspaceDirectories operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceDirectoriesResponse> describeWorkspaceDirectories(
            DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceDirectoriesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeWorkspaceDirectories operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceDirectoriesResponse> describeWorkspaceDirectories(
            Consumer<DescribeWorkspaceDirectoriesRequest.Builder> describeWorkspaceDirectoriesRequest) {
        return describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest.builder()
                .applyMutation(describeWorkspaceDirectoriesRequest).build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeWorkspaceDirectories operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceDirectoriesResponse> describeWorkspaceDirectories() {
        return describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesPublisher publisher = client.describeWorkspaceDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesPublisher publisher = client.describeWorkspaceDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesPublisher describeWorkspaceDirectoriesPaginator() {
        return describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesPublisher publisher = client.describeWorkspaceDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesPublisher publisher = client.describeWorkspaceDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesPublisher describeWorkspaceDirectoriesPaginator(
            DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) {
        return new DescribeWorkspaceDirectoriesPublisher(this, describeWorkspaceDirectoriesRequest);
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesPublisher publisher = client.describeWorkspaceDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesPublisher publisher = client.describeWorkspaceDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceDirectoriesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceDirectoriesPublisher describeWorkspaceDirectoriesPaginator(
            Consumer<DescribeWorkspaceDirectoriesRequest.Builder> describeWorkspaceDirectoriesRequest) {
        return describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest.builder()
                .applyMutation(describeWorkspaceDirectoriesRequest).build());
    }

    /**
     * <p>
     * Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an
     * image.
     * </p>
     *
     * @param describeWorkspaceImagePermissionsRequest
     * @return A Java Future containing the result of the DescribeWorkspaceImagePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceImagePermissionsResponse> describeWorkspaceImagePermissions(
            DescribeWorkspaceImagePermissionsRequest describeWorkspaceImagePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an
     * image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceImagePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceImagePermissionsRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceImagePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeWorkspaceImagePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceImagePermissionsResponse> describeWorkspaceImagePermissions(
            Consumer<DescribeWorkspaceImagePermissionsRequest.Builder> describeWorkspaceImagePermissionsRequest) {
        return describeWorkspaceImagePermissions(DescribeWorkspaceImagePermissionsRequest.builder()
                .applyMutation(describeWorkspaceImagePermissionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     *
     * @param describeWorkspaceImagesRequest
     * @return A Java Future containing the result of the DescribeWorkspaceImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceImagesResponse> describeWorkspaceImages(
            DescribeWorkspaceImagesRequest describeWorkspaceImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceImagesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceImagesRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeWorkspaceImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceImagesResponse> describeWorkspaceImages(
            Consumer<DescribeWorkspaceImagesRequest.Builder> describeWorkspaceImagesRequest) {
        return describeWorkspaceImages(DescribeWorkspaceImagesRequest.builder().applyMutation(describeWorkspaceImagesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeWorkspaceImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceImagesResponse> describeWorkspaceImages() {
        return describeWorkspaceImages(DescribeWorkspaceImagesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the snapshots for the specified WorkSpace.
     * </p>
     *
     * @param describeWorkspaceSnapshotsRequest
     * @return A Java Future containing the result of the DescribeWorkspaceSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceSnapshotsResponse> describeWorkspaceSnapshots(
            DescribeWorkspaceSnapshotsRequest describeWorkspaceSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the snapshots for the specified WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorkspaceSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeWorkspaceSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceSnapshotsResponse> describeWorkspaceSnapshots(
            Consumer<DescribeWorkspaceSnapshotsRequest.Builder> describeWorkspaceSnapshotsRequest) {
        return describeWorkspaceSnapshots(DescribeWorkspaceSnapshotsRequest.builder()
                .applyMutation(describeWorkspaceSnapshotsRequest).build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     *
     * @param describeWorkspacesRequest
     * @return A Java Future containing the result of the DescribeWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspacesResponse> describeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspacesResponse> describeWorkspaces(
            Consumer<DescribeWorkspacesRequest.Builder> describeWorkspacesRequest) {
        return describeWorkspaces(DescribeWorkspacesRequest.builder().applyMutation(describeWorkspacesRequest).build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspacesResponse> describeWorkspaces() {
        return describeWorkspaces(DescribeWorkspacesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     *
     * @param describeWorkspacesConnectionStatusRequest
     * @return A Java Future containing the result of the DescribeWorkspacesConnectionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspacesConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspacesConnectionStatusResponse> describeWorkspacesConnectionStatus(
            DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesConnectionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspacesConnectionStatusRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesConnectionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeWorkspacesConnectionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspacesConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspacesConnectionStatusResponse> describeWorkspacesConnectionStatus(
            Consumer<DescribeWorkspacesConnectionStatusRequest.Builder> describeWorkspacesConnectionStatusRequest) {
        return describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest.builder()
                .applyMutation(describeWorkspacesConnectionStatusRequest).build());
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeWorkspacesConnectionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspacesConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspacesConnectionStatusResponse> describeWorkspacesConnectionStatus() {
        return describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesPublisher publisher = client.describeWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesPublisher publisher = client.describeWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesPublisher describeWorkspacesPaginator() {
        return describeWorkspacesPaginator(DescribeWorkspacesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesPublisher publisher = client.describeWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesPublisher publisher = client.describeWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesPublisher describeWorkspacesPaginator(DescribeWorkspacesRequest describeWorkspacesRequest) {
        return new DescribeWorkspacesPublisher(this, describeWorkspacesRequest);
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesPublisher publisher = client.describeWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesPublisher publisher = client.describeWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspacesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkspacesPublisher describeWorkspacesPaginator(
            Consumer<DescribeWorkspacesRequest.Builder> describeWorkspacesRequest) {
        return describeWorkspacesPaginator(DescribeWorkspacesRequest.builder().applyMutation(describeWorkspacesRequest).build());
    }

    /**
     * <p>
     * Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region
     * redirection between two directories in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note>
     *
     * @param disassociateConnectionAliasRequest
     * @return A Java Future containing the result of the DisassociateConnectionAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DisassociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateConnectionAliasResponse> disassociateConnectionAlias(
            DisassociateConnectionAliasRequest disassociateConnectionAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region
     * redirection between two directories in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateConnectionAliasRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateConnectionAliasRequest#builder()}
     * </p>
     *
     * @param disassociateConnectionAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateConnectionAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DisassociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateConnectionAliasResponse> disassociateConnectionAlias(
            Consumer<DisassociateConnectionAliasRequest.Builder> disassociateConnectionAliasRequest) {
        return disassociateConnectionAlias(DisassociateConnectionAliasRequest.builder()
                .applyMutation(disassociateConnectionAliasRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified IP access control group from the specified directory.
     * </p>
     *
     * @param disassociateIpGroupsRequest
     * @return A Java Future containing the result of the DisassociateIpGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DisassociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateIpGroupsResponse> disassociateIpGroups(
            DisassociateIpGroupsRequest disassociateIpGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified IP access control group from the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateIpGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateIpGroupsRequest#builder()}
     * </p>
     *
     * @param disassociateIpGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateIpGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DisassociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateIpGroupsResponse> disassociateIpGroups(
            Consumer<DisassociateIpGroupsRequest.Builder> disassociateIpGroupsRequest) {
        return disassociateIpGroups(DisassociateIpGroupsRequest.builder().applyMutation(disassociateIpGroupsRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified application from a WorkSpace.
     * </p>
     *
     * @param disassociateWorkspaceApplicationRequest
     * @return A Java Future containing the result of the DisassociateWorkspaceApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceInUseException The specified resource is currently in use.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DisassociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWorkspaceApplicationResponse> disassociateWorkspaceApplication(
            DisassociateWorkspaceApplicationRequest disassociateWorkspaceApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified application from a WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWorkspaceApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateWorkspaceApplicationRequest#builder()}
     * </p>
     *
     * @param disassociateWorkspaceApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateWorkspaceApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceInUseException The specified resource is currently in use.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.DisassociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateWorkspaceApplicationResponse> disassociateWorkspaceApplication(
            Consumer<DisassociateWorkspaceApplicationRequest.Builder> disassociateWorkspaceApplicationRequest) {
        return disassociateWorkspaceApplication(DisassociateWorkspaceApplicationRequest.builder()
                .applyMutation(disassociateWorkspaceApplicationRequest).build());
    }

    /**
     * <p>
     * Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can
     * tailor your login portal company logo, the support email address, support link, link to reset password, and a
     * custom message for users trying to sign in.
     * </p>
     * <p>
     * After you import client branding, the default branding experience for the specified platform type is replaced
     * with the imported experience
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must specify at least one platform type when importing client branding.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client
     * branding for different platform types using separate requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify only one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Imported data can take up to a minute to appear in the WorkSpaces client.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param importClientBrandingRequest
     * @return A Java Future containing the result of the ImportClientBranding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ImportClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportClientBrandingResponse> importClientBranding(
            ImportClientBrandingRequest importClientBrandingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can
     * tailor your login portal company logo, the support email address, support link, link to reset password, and a
     * custom message for users trying to sign in.
     * </p>
     * <p>
     * After you import client branding, the default branding experience for the specified platform type is replaced
     * with the imported experience
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must specify at least one platform type when importing client branding.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client
     * branding for different platform types using separate requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify only one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Imported data can take up to a minute to appear in the WorkSpaces client.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportClientBrandingRequest.Builder} avoiding the
     * need to create one manually via {@link ImportClientBrandingRequest#builder()}
     * </p>
     *
     * @param importClientBrandingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportClientBranding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ImportClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportClientBrandingResponse> importClientBranding(
            Consumer<ImportClientBrandingRequest.Builder> importClientBrandingRequest) {
        return importClientBranding(ImportClientBrandingRequest.builder().applyMutation(importClientBrandingRequest).build());
    }

    /**
     * <p>
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must
     * be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image.
     * For more information about creating BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows
     * Desktop Licenses</a>.
     * </p>
     *
     * @param importWorkspaceImageRequest
     * @return A Java Future containing the result of the ImportWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ImportWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportWorkspaceImageResponse> importWorkspaceImage(
            ImportWorkspaceImageRequest importWorkspaceImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must
     * be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image.
     * For more information about creating BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows
     * Desktop Licenses</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportWorkspaceImageRequest.Builder} avoiding the
     * need to create one manually via {@link ImportWorkspaceImageRequest#builder()}
     * </p>
     *
     * @param importWorkspaceImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportWorkspaceImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ImportWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportWorkspaceImageResponse> importWorkspaceImage(
            Consumer<ImportWorkspaceImageRequest.Builder> importWorkspaceImageRequest) {
        return importWorkspaceImage(ImportWorkspaceImageRequest.builder().applyMutation(importWorkspaceImageRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management
     * interface when you enable Bring Your Own License (BYOL).
     * </p>
     * <p>
     * This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't
     * enabled for BYOL, you'll receive an <code>AccessDeniedException</code> error.
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     *
     * @param listAvailableManagementCidrRangesRequest
     * @return A Java Future containing the result of the ListAvailableManagementCidrRanges operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ListAvailableManagementCidrRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableManagementCidrRangesResponse> listAvailableManagementCidrRanges(
            ListAvailableManagementCidrRangesRequest listAvailableManagementCidrRangesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management
     * interface when you enable Bring Your Own License (BYOL).
     * </p>
     * <p>
     * This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't
     * enabled for BYOL, you'll receive an <code>AccessDeniedException</code> error.
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableManagementCidrRangesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableManagementCidrRangesRequest#builder()}
     * </p>
     *
     * @param listAvailableManagementCidrRangesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAvailableManagementCidrRanges operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ListAvailableManagementCidrRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableManagementCidrRangesResponse> listAvailableManagementCidrRanges(
            Consumer<ListAvailableManagementCidrRangesRequest.Builder> listAvailableManagementCidrRangesRequest) {
        return listAvailableManagementCidrRanges(ListAvailableManagementCidrRangesRequest.builder()
                .applyMutation(listAvailableManagementCidrRangesRequest).build());
    }

    /**
     * <p>
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user
     * volume.
     * </p>
     * <p>
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the
     * user volume from the last available snapshot of the original WorkSpace. During migration, the original
     * <code>D:\Users\%USERNAME%</code> user profile folder is renamed to
     * <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is
     * generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     * </p>
     * <p>
     * For available migration scenarios, details about what happens during migration, and best practices, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.
     * </p>
     *
     * @param migrateWorkspaceRequest
     * @return A Java Future containing the result of the MigrateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>OperationInProgressException The properties of this WorkSpace are currently being modified. Try again
     *         in a moment.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.MigrateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<MigrateWorkspaceResponse> migrateWorkspace(MigrateWorkspaceRequest migrateWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user
     * volume.
     * </p>
     * <p>
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the
     * user volume from the last available snapshot of the original WorkSpace. During migration, the original
     * <code>D:\Users\%USERNAME%</code> user profile folder is renamed to
     * <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is
     * generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     * </p>
     * <p>
     * For available migration scenarios, details about what happens during migration, and best practices, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MigrateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link MigrateWorkspaceRequest#builder()}
     * </p>
     *
     * @param migrateWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the MigrateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>OperationInProgressException The properties of this WorkSpace are currently being modified. Try again
     *         in a moment.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.MigrateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<MigrateWorkspaceResponse> migrateWorkspace(
            Consumer<MigrateWorkspaceRequest.Builder> migrateWorkspaceRequest) {
        return migrateWorkspace(MigrateWorkspaceRequest.builder().applyMutation(migrateWorkspaceRequest).build());
    }

    /**
     * <p>
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param modifyAccountRequest
     * @return A Java Future containing the result of the ModifyAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyAccountResponse> modifyAccount(ModifyAccountRequest modifyAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyAccountRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyAccountRequest#builder()}
     * </p>
     *
     * @param modifyAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyAccountResponse> modifyAccount(Consumer<ModifyAccountRequest.Builder> modifyAccountRequest) {
        return modifyAccount(ModifyAccountRequest.builder().applyMutation(modifyAccountRequest).build());
    }

    /**
     * <p>
     * Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
     * </p>
     *
     * @param modifyCertificateBasedAuthPropertiesRequest
     * @return A Java Future containing the result of the ModifyCertificateBasedAuthProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyCertificateBasedAuthProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyCertificateBasedAuthProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCertificateBasedAuthPropertiesResponse> modifyCertificateBasedAuthProperties(
            ModifyCertificateBasedAuthPropertiesRequest modifyCertificateBasedAuthPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ModifyCertificateBasedAuthPropertiesRequest.Builder} avoiding the need to create one manually via
     * {@link ModifyCertificateBasedAuthPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyCertificateBasedAuthPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ModifyCertificateBasedAuthProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyCertificateBasedAuthProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyCertificateBasedAuthProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCertificateBasedAuthPropertiesResponse> modifyCertificateBasedAuthProperties(
            Consumer<ModifyCertificateBasedAuthPropertiesRequest.Builder> modifyCertificateBasedAuthPropertiesRequest) {
        return modifyCertificateBasedAuthProperties(ModifyCertificateBasedAuthPropertiesRequest.builder()
                .applyMutation(modifyCertificateBasedAuthPropertiesRequest).build());
    }

    /**
     * <p>
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param modifyClientPropertiesRequest
     * @return A Java Future containing the result of the ModifyClientProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClientPropertiesResponse> modifyClientProperties(
            ModifyClientPropertiesRequest modifyClientPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClientPropertiesRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyClientPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyClientPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyClientProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClientPropertiesResponse> modifyClientProperties(
            Consumer<ModifyClientPropertiesRequest.Builder> modifyClientPropertiesRequest) {
        return modifyClientProperties(ModifyClientPropertiesRequest.builder().applyMutation(modifyClientPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access
     * URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
     * </p>
     *
     * @param modifySamlPropertiesRequest
     * @return A Java Future containing the result of the ModifySamlProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifySamlProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySamlProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifySamlPropertiesResponse> modifySamlProperties(
            ModifySamlPropertiesRequest modifySamlPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access
     * URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifySamlPropertiesRequest.Builder} avoiding the
     * need to create one manually via {@link ModifySamlPropertiesRequest#builder()}
     * </p>
     *
     * @param modifySamlPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifySamlProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifySamlProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySamlProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifySamlPropertiesResponse> modifySamlProperties(
            Consumer<ModifySamlPropertiesRequest.Builder> modifySamlPropertiesRequest) {
        return modifySamlProperties(ModifySamlPropertiesRequest.builder().applyMutation(modifySamlPropertiesRequest).build());
    }

    /**
     * <p>
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html"
     * >Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.
     * </p>
     *
     * @param modifySelfservicePermissionsRequest
     * @return A Java Future containing the result of the ModifySelfservicePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifySelfservicePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifySelfservicePermissionsResponse> modifySelfservicePermissions(
            ModifySelfservicePermissionsRequest modifySelfservicePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html"
     * >Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifySelfservicePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link ModifySelfservicePermissionsRequest#builder()}
     * </p>
     *
     * @param modifySelfservicePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifySelfservicePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifySelfservicePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifySelfservicePermissionsResponse> modifySelfservicePermissions(
            Consumer<ModifySelfservicePermissionsRequest.Builder> modifySelfservicePermissionsRequest) {
        return modifySelfservicePermissions(ModifySelfservicePermissionsRequest.builder()
                .applyMutation(modifySelfservicePermissionsRequest).build());
    }

    /**
     * <p>
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access">
     * Control Device Access</a>.
     * </p>
     *
     * @param modifyWorkspaceAccessPropertiesRequest
     * @return A Java Future containing the result of the ModifyWorkspaceAccessProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyWorkspaceAccessProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyWorkspaceAccessPropertiesResponse> modifyWorkspaceAccessProperties(
            ModifyWorkspaceAccessPropertiesRequest modifyWorkspaceAccessPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access">
     * Control Device Access</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspaceAccessPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyWorkspaceAccessPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyWorkspaceAccessPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyWorkspaceAccessProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyWorkspaceAccessProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyWorkspaceAccessPropertiesResponse> modifyWorkspaceAccessProperties(
            Consumer<ModifyWorkspaceAccessPropertiesRequest.Builder> modifyWorkspaceAccessPropertiesRequest) {
        return modifyWorkspaceAccessProperties(ModifyWorkspaceAccessPropertiesRequest.builder()
                .applyMutation(modifyWorkspaceAccessPropertiesRequest).build());
    }

    /**
     * <p>
     * Modify the default properties used to create WorkSpaces.
     * </p>
     *
     * @param modifyWorkspaceCreationPropertiesRequest
     * @return A Java Future containing the result of the ModifyWorkspaceCreationProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyWorkspaceCreationProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyWorkspaceCreationPropertiesResponse> modifyWorkspaceCreationProperties(
            ModifyWorkspaceCreationPropertiesRequest modifyWorkspaceCreationPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modify the default properties used to create WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspaceCreationPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyWorkspaceCreationPropertiesRequest#builder()}
     * </p>
     *
     * @param modifyWorkspaceCreationPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ModifyWorkspaceCreationProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyWorkspaceCreationProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyWorkspaceCreationPropertiesResponse> modifyWorkspaceCreationProperties(
            Consumer<ModifyWorkspaceCreationPropertiesRequest.Builder> modifyWorkspaceCreationPropertiesRequest) {
        return modifyWorkspaceCreationProperties(ModifyWorkspaceCreationPropertiesRequest.builder()
                .applyMutation(modifyWorkspaceCreationPropertiesRequest).build());
    }

    /**
     * <p>
     * Modifies the specified WorkSpace properties. For important information about how to modify the size of the root
     * and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">
     * Modify a WorkSpace</a>.
     * </p>
     * <note>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </note>
     *
     * @param modifyWorkspacePropertiesRequest
     * @return A Java Future containing the result of the ModifyWorkspaceProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationInProgressException The properties of this WorkSpace are currently being modified. Try again
     *         in a moment.</li>
     *         <li>UnsupportedWorkspaceConfigurationException The configuration of this WorkSpace is not supported for
     *         this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required
     *         Configuration and Service Components for WorkSpaces </a>.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyWorkspaceProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyWorkspacePropertiesResponse> modifyWorkspaceProperties(
            ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified WorkSpace properties. For important information about how to modify the size of the root
     * and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">
     * Modify a WorkSpace</a>.
     * </p>
     * <note>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspacePropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyWorkspacePropertiesRequest#builder()}
     * </p>
     *
     * @param modifyWorkspacePropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyWorkspaceProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationInProgressException The properties of this WorkSpace are currently being modified. Try again
     *         in a moment.</li>
     *         <li>UnsupportedWorkspaceConfigurationException The configuration of this WorkSpace is not supported for
     *         this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required
     *         Configuration and Service Components for WorkSpaces </a>.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyWorkspaceProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyWorkspacePropertiesResponse> modifyWorkspaceProperties(
            Consumer<ModifyWorkspacePropertiesRequest.Builder> modifyWorkspacePropertiesRequest) {
        return modifyWorkspaceProperties(ModifyWorkspacePropertiesRequest.builder()
                .applyMutation(modifyWorkspacePropertiesRequest).build());
    }

    /**
     * <p>
     * Sets the state of the specified WorkSpace.
     * </p>
     * <p>
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>.
     * WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop
     * WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code>
     * state.
     * </p>
     *
     * @param modifyWorkspaceStateRequest
     * @return A Java Future containing the result of the ModifyWorkspaceState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyWorkspaceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyWorkspaceStateResponse> modifyWorkspaceState(
            ModifyWorkspaceStateRequest modifyWorkspaceStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the state of the specified WorkSpace.
     * </p>
     * <p>
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>.
     * WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop
     * WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code>
     * state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyWorkspaceStateRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyWorkspaceStateRequest#builder()}
     * </p>
     *
     * @param modifyWorkspaceStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyWorkspaceState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.ModifyWorkspaceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyWorkspaceStateResponse> modifyWorkspaceState(
            Consumer<ModifyWorkspaceStateRequest.Builder> modifyWorkspaceStateRequest) {
        return modifyWorkspaceState(ModifyWorkspaceStateRequest.builder().applyMutation(modifyWorkspaceStateRequest).build());
    }

    /**
     * <p>
     * Reboots the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code> or <code>UNHEALTHY</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     * </p>
     *
     * @param rebootWorkspacesRequest
     * @return A Java Future containing the result of the RebootWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RebootWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RebootWorkspacesResponse> rebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code> or <code>UNHEALTHY</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link RebootWorkspacesRequest#builder()}
     * </p>
     *
     * @param rebootWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RebootWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RebootWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RebootWorkspacesResponse> rebootWorkspaces(
            Consumer<RebootWorkspacesRequest.Builder> rebootWorkspacesRequest) {
        return rebootWorkspaces(RebootWorkspacesRequest.builder().applyMutation(rebootWorkspacesRequest).build());
    }

    /**
     * <p>
     * Rebuilds the specified WorkSpace.
     * </p>
     * <p>
     * You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, <code>STOPPED</code>, or <code>REBOOTING</code>.
     * </p>
     * <p>
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild
     * a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     * </p>
     *
     * @param rebuildWorkspacesRequest
     * @return A Java Future containing the result of the RebuildWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RebuildWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RebuildWorkspacesResponse> rebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rebuilds the specified WorkSpace.
     * </p>
     * <p>
     * You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, <code>STOPPED</code>, or <code>REBOOTING</code>.
     * </p>
     * <p>
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild
     * a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebuildWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link RebuildWorkspacesRequest#builder()}
     * </p>
     *
     * @param rebuildWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RebuildWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RebuildWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RebuildWorkspacesResponse> rebuildWorkspaces(
            Consumer<RebuildWorkspacesRequest.Builder> rebuildWorkspacesRequest) {
        return rebuildWorkspaces(RebuildWorkspacesRequest.builder().applyMutation(rebuildWorkspacesRequest).build());
    }

    /**
     * <p>
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * registered. If this is the first time you are registering a directory, you will need to create the
     * workspaces_DefaultRole role before you can register a directory. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">
     * Creating the workspaces_DefaultRole Role</a>.
     * </p>
     *
     * @param registerWorkspaceDirectoryRequest
     * @return A Java Future containing the result of the RegisterWorkspaceDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>WorkspacesDefaultRoleNotFoundException The workspaces_DefaultRole role could not be found. If this is
     *         the first time you are registering a directory, you will need to create the workspaces_DefaultRole role
     *         before you can register a directory. For more information, see <a href=
     *         "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"
     *         >Creating the workspaces_DefaultRole Role</a>.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>UnsupportedNetworkConfigurationException The configuration of this network is not supported for this
     *         operation, or your network configuration conflicts with the Amazon WorkSpaces management network IP
     *         range. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a
     *         VPC for Amazon WorkSpaces</a>.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RegisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterWorkspaceDirectoryResponse> registerWorkspaceDirectory(
            RegisterWorkspaceDirectoryRequest registerWorkspaceDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * registered. If this is the first time you are registering a directory, you will need to create the
     * workspaces_DefaultRole role before you can register a directory. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">
     * Creating the workspaces_DefaultRole Role</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterWorkspaceDirectoryRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterWorkspaceDirectoryRequest#builder()}
     * </p>
     *
     * @param registerWorkspaceDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RegisterWorkspaceDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>WorkspacesDefaultRoleNotFoundException The workspaces_DefaultRole role could not be found. If this is
     *         the first time you are registering a directory, you will need to create the workspaces_DefaultRole role
     *         before you can register a directory. For more information, see <a href=
     *         "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"
     *         >Creating the workspaces_DefaultRole Role</a>.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>UnsupportedNetworkConfigurationException The configuration of this network is not supported for this
     *         operation, or your network configuration conflicts with the Amazon WorkSpaces management network IP
     *         range. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a
     *         VPC for Amazon WorkSpaces</a>.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RegisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterWorkspaceDirectoryResponse> registerWorkspaceDirectory(
            Consumer<RegisterWorkspaceDirectoryRequest.Builder> registerWorkspaceDirectoryRequest) {
        return registerWorkspaceDirectory(RegisterWorkspaceDirectoryRequest.builder()
                .applyMutation(registerWorkspaceDirectoryRequest).build());
    }

    /**
     * <p>
     * Restores the specified WorkSpace to its last known healthy state.
     * </p>
     * <p>
     * You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     * </p>
     *
     * @param restoreWorkspaceRequest
     * @return A Java Future containing the result of the RestoreWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RestoreWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RestoreWorkspaceResponse> restoreWorkspace(RestoreWorkspaceRequest restoreWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores the specified WorkSpace to its last known healthy state.
     * </p>
     * <p>
     * You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link RestoreWorkspaceRequest#builder()}
     * </p>
     *
     * @param restoreWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestoreWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RestoreWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RestoreWorkspaceResponse> restoreWorkspace(
            Consumer<RestoreWorkspaceRequest.Builder> restoreWorkspaceRequest) {
        return restoreWorkspace(RestoreWorkspaceRequest.builder().applyMutation(restoreWorkspaceRequest).build());
    }

    /**
     * <p>
     * Removes one or more rules from the specified IP access control group.
     * </p>
     *
     * @param revokeIpRulesRequest
     * @return A Java Future containing the result of the RevokeIpRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RevokeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RevokeIpRulesResponse> revokeIpRules(RevokeIpRulesRequest revokeIpRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more rules from the specified IP access control group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeIpRulesRequest.Builder} avoiding the need to
     * create one manually via {@link RevokeIpRulesRequest#builder()}
     * </p>
     *
     * @param revokeIpRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RevokeIpRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.RevokeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RevokeIpRulesResponse> revokeIpRules(Consumer<RevokeIpRulesRequest.Builder> revokeIpRulesRequest) {
        return revokeIpRules(RevokeIpRulesRequest.builder().applyMutation(revokeIpRulesRequest).build());
    }

    /**
     * <p>
     * Starts the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>STOPPED</code>.
     * </p>
     *
     * @param startWorkspacesRequest
     * @return A Java Future containing the result of the StartWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.StartWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartWorkspacesResponse> startWorkspaces(StartWorkspacesRequest startWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>STOPPED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWorkspacesRequest.Builder} avoiding the need
     * to create one manually via {@link StartWorkspacesRequest#builder()}
     * </p>
     *
     * @param startWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.StartWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartWorkspacesResponse> startWorkspaces(
            Consumer<StartWorkspacesRequest.Builder> startWorkspacesRequest) {
        return startWorkspaces(StartWorkspacesRequest.builder().applyMutation(startWorkspacesRequest).build());
    }

    /**
     * <p>
     * Stops the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     *
     * @param stopWorkspacesRequest
     * @return A Java Future containing the result of the StopWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.StopWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopWorkspacesResponse> stopWorkspaces(StopWorkspacesRequest stopWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link StopWorkspacesRequest#builder()}
     * </p>
     *
     * @param stopWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.StopWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopWorkspacesResponse> stopWorkspaces(Consumer<StopWorkspacesRequest.Builder> stopWorkspacesRequest) {
        return stopWorkspaces(StopWorkspacesRequest.builder().applyMutation(stopWorkspacesRequest).build());
    }

    /**
     * <p>
     * Terminates the specified WorkSpaces.
     * </p>
     * <important>
     * <p>
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to
     * archive any user data, contact Amazon Web Services Support before terminating the WorkSpace.
     * </p>
     * </important>
     * <p>
     * You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a
     * WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace
     * directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated,
     * check for the WorkSpace ID by using <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If
     * the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note>
     *
     * @param terminateWorkspacesRequest
     * @return A Java Future containing the result of the TerminateWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.TerminateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateWorkspacesResponse> terminateWorkspaces(
            TerminateWorkspacesRequest terminateWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified WorkSpaces.
     * </p>
     * <important>
     * <p>
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to
     * archive any user data, contact Amazon Web Services Support before terminating the WorkSpace.
     * </p>
     * </important>
     * <p>
     * You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a
     * WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace
     * directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated,
     * check for the WorkSpace ID by using <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If
     * the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateWorkspacesRequest.Builder} avoiding the
     * need to create one manually via {@link TerminateWorkspacesRequest#builder()}
     * </p>
     *
     * @param terminateWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TerminateWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.TerminateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateWorkspacesResponse> terminateWorkspaces(
            Consumer<TerminateWorkspacesRequest.Builder> terminateWorkspacesRequest) {
        return terminateWorkspaces(TerminateWorkspacesRequest.builder().applyMutation(terminateWorkspacesRequest).build());
    }

    /**
     * <p>
     * Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect
     * client add-in.
     * </p>
     *
     * @param updateConnectClientAddInRequest
     * @return A Java Future containing the result of the UpdateConnectClientAddIn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectClientAddInResponse> updateConnectClientAddIn(
            UpdateConnectClientAddInRequest updateConnectClientAddInRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect
     * client add-in.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectClientAddInRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConnectClientAddInRequest#builder()}
     * </p>
     *
     * @param updateConnectClientAddInRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateConnectClientAddIn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectClientAddInResponse> updateConnectClientAddIn(
            Consumer<UpdateConnectClientAddInRequest.Builder> updateConnectClientAddInRequest) {
        return updateConnectClientAddIn(UpdateConnectClientAddInRequest.builder().applyMutation(updateConnectClientAddInRequest)
                .build());
    }

    /**
     * <p>
     * Shares or unshares a connection alias with one account by specifying whether that account has permission to
     * associate the connection alias with a directory. If the association permission is granted, the connection alias
     * is shared with that account. If the association permission is revoked, the connection alias is unshared with the
     * account. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateConnectionAliasPermissionRequest
     * @return A Java Future containing the result of the UpdateConnectionAliasPermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateConnectionAliasPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectionAliasPermissionResponse> updateConnectionAliasPermission(
            UpdateConnectionAliasPermissionRequest updateConnectionAliasPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shares or unshares a connection alias with one account by specifying whether that account has permission to
     * associate the connection alias with a directory. If the association permission is granted, the connection alias
     * is shared with that account. If the association permission is revoked, the connection alias is unshared with the
     * account. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectionAliasPermissionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConnectionAliasPermissionRequest#builder()}
     * </p>
     *
     * @param updateConnectionAliasPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateConnectionAliasPermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAssociatedException The resource is associated with a directory.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateConnectionAliasPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectionAliasPermissionResponse> updateConnectionAliasPermission(
            Consumer<UpdateConnectionAliasPermissionRequest.Builder> updateConnectionAliasPermissionRequest) {
        return updateConnectionAliasPermission(UpdateConnectionAliasPermissionRequest.builder()
                .applyMutation(updateConnectionAliasPermissionRequest).build());
    }

    /**
     * <p>
     * Replaces the current rules of the specified IP access control group with the specified rules.
     * </p>
     *
     * @param updateRulesOfIpGroupRequest
     * @return A Java Future containing the result of the UpdateRulesOfIpGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateRulesOfIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRulesOfIpGroupResponse> updateRulesOfIpGroup(
            UpdateRulesOfIpGroupRequest updateRulesOfIpGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the current rules of the specified IP access control group with the specified rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRulesOfIpGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRulesOfIpGroupRequest#builder()}
     * </p>
     *
     * @param updateRulesOfIpGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRulesOfIpGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>InvalidResourceStateException The state of the resource is not valid for this operation.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateRulesOfIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRulesOfIpGroupResponse> updateRulesOfIpGroup(
            Consumer<UpdateRulesOfIpGroupRequest.Builder> updateRulesOfIpGroupRequest) {
        return updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest.builder().applyMutation(updateRulesOfIpGroupRequest).build());
    }

    /**
     * <p>
     * Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html"> Update a Custom
     * WorkSpaces Bundle</a>.
     * </p>
     * <important>
     * <p>
     * Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update
     * existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or
     * delete and recreate them.
     * </p>
     * </important>
     *
     * @param updateWorkspaceBundleRequest
     * @return A Java Future containing the result of the UpdateWorkspaceBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceBundleResponse> updateWorkspaceBundle(
            UpdateWorkspaceBundleRequest updateWorkspaceBundleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html"> Update a Custom
     * WorkSpaces Bundle</a>.
     * </p>
     * <important>
     * <p>
     * Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update
     * existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or
     * delete and recreate them.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceBundleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkspaceBundleRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWorkspaceBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceBundleResponse> updateWorkspaceBundle(
            Consumer<UpdateWorkspaceBundleRequest.Builder> updateWorkspaceBundleRequest) {
        return updateWorkspaceBundle(UpdateWorkspaceBundleRequest.builder().applyMutation(updateWorkspaceBundleRequest).build());
    }

    /**
     * <p>
     * Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that
     * account has permission to copy the image. If the copy image permission is granted, the image is shared with that
     * account. If the copy image permission is revoked, the image is unshared with the account.
     * </p>
     * <p>
     * After an image has been shared, the recipient account can copy the image to other Regions as needed.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services
     * Support.
     * </p>
     * <p>
     * For more information about sharing images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * To delete an image that has been shared, you must unshare the image before you delete it.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in
     * Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US),
     * contact Amazon Web Services Support.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateWorkspaceImagePermissionRequest
     * @return A Java Future containing the result of the UpdateWorkspaceImagePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateWorkspaceImagePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceImagePermissionResponse> updateWorkspaceImagePermission(
            UpdateWorkspaceImagePermissionRequest updateWorkspaceImagePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that
     * account has permission to copy the image. If the copy image permission is granted, the image is shared with that
     * account. If the copy image permission is revoked, the image is unshared with the account.
     * </p>
     * <p>
     * After an image has been shared, the recipient account can copy the image to other Regions as needed.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services
     * Support.
     * </p>
     * <p>
     * For more information about sharing images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * To delete an image that has been shared, you must unshare the image before you delete it.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in
     * Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US),
     * contact Amazon Web Services Support.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceImagePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateWorkspaceImagePermissionRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceImagePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateWorkspaceImagePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceUnavailableException The specified resource is not available.</li>
     *         <li>AccessDeniedException The user is not authorized to access a resource.</li>
     *         <li>InvalidParameterValuesException One or more parameter values are not valid.</li>
     *         <li>OperationNotSupportedException This operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesAsyncClient.UpdateWorkspaceImagePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceImagePermissionResponse> updateWorkspaceImagePermission(
            Consumer<UpdateWorkspaceImagePermissionRequest.Builder> updateWorkspaceImagePermissionRequest) {
        return updateWorkspaceImagePermission(UpdateWorkspaceImagePermissionRequest.builder()
                .applyMutation(updateWorkspaceImagePermissionRequest).build());
    }

    @Override
    default WorkSpacesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link WorkSpacesAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkSpacesAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkSpacesAsyncClient}.
     */
    static WorkSpacesAsyncClientBuilder builder() {
        return new DefaultWorkSpacesAsyncClientBuilder();
    }
}
