/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStandbyWorkspacesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<CreateStandbyWorkspacesRequest.Builder, CreateStandbyWorkspacesRequest> {
    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryRegion").getter(getter(CreateStandbyWorkspacesRequest::primaryRegion))
            .setter(setter(Builder::primaryRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryRegion").build()).build();

    private static final SdkField<List<StandbyWorkspace>> STANDBY_WORKSPACES_FIELD = SdkField
            .<List<StandbyWorkspace>> builder(MarshallingType.LIST)
            .memberName("StandbyWorkspaces")
            .getter(getter(CreateStandbyWorkspacesRequest::standbyWorkspaces))
            .setter(setter(Builder::standbyWorkspaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandbyWorkspaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StandbyWorkspace> builder(MarshallingType.SDK_POJO)
                                            .constructor(StandbyWorkspace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_REGION_FIELD,
            STANDBY_WORKSPACES_FIELD));

    private final String primaryRegion;

    private final List<StandbyWorkspace> standbyWorkspaces;

    private CreateStandbyWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.primaryRegion = builder.primaryRegion;
        this.standbyWorkspaces = builder.standbyWorkspaces;
    }

    /**
     * <p>
     * The Region of the primary WorkSpace.
     * </p>
     * 
     * @return The Region of the primary WorkSpace.
     */
    public final String primaryRegion() {
        return primaryRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the StandbyWorkspaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStandbyWorkspaces() {
        return standbyWorkspaces != null && !(standbyWorkspaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the standby WorkSpace to be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStandbyWorkspaces} method.
     * </p>
     * 
     * @return Information about the standby WorkSpace to be created.
     */
    public final List<StandbyWorkspace> standbyWorkspaces() {
        return standbyWorkspaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasStandbyWorkspaces() ? standbyWorkspaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStandbyWorkspacesRequest)) {
            return false;
        }
        CreateStandbyWorkspacesRequest other = (CreateStandbyWorkspacesRequest) obj;
        return Objects.equals(primaryRegion(), other.primaryRegion()) && hasStandbyWorkspaces() == other.hasStandbyWorkspaces()
                && Objects.equals(standbyWorkspaces(), other.standbyWorkspaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStandbyWorkspacesRequest").add("PrimaryRegion", primaryRegion())
                .add("StandbyWorkspaces", hasStandbyWorkspaces() ? standbyWorkspaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryRegion":
            return Optional.ofNullable(clazz.cast(primaryRegion()));
        case "StandbyWorkspaces":
            return Optional.ofNullable(clazz.cast(standbyWorkspaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStandbyWorkspacesRequest, T> g) {
        return obj -> g.apply((CreateStandbyWorkspacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStandbyWorkspacesRequest> {
        /**
         * <p>
         * The Region of the primary WorkSpace.
         * </p>
         * 
         * @param primaryRegion
         *        The Region of the primary WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryRegion(String primaryRegion);

        /**
         * <p>
         * Information about the standby WorkSpace to be created.
         * </p>
         * 
         * @param standbyWorkspaces
         *        Information about the standby WorkSpace to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standbyWorkspaces(Collection<StandbyWorkspace> standbyWorkspaces);

        /**
         * <p>
         * Information about the standby WorkSpace to be created.
         * </p>
         * 
         * @param standbyWorkspaces
         *        Information about the standby WorkSpace to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standbyWorkspaces(StandbyWorkspace... standbyWorkspaces);

        /**
         * <p>
         * Information about the standby WorkSpace to be created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.StandbyWorkspace.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workspaces.model.StandbyWorkspace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.StandbyWorkspace.Builder#build()} is called
         * immediately and its result is passed to {@link #standbyWorkspaces(List<StandbyWorkspace>)}.
         * 
         * @param standbyWorkspaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.StandbyWorkspace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standbyWorkspaces(java.util.Collection<StandbyWorkspace>)
         */
        Builder standbyWorkspaces(Consumer<StandbyWorkspace.Builder>... standbyWorkspaces);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String primaryRegion;

        private List<StandbyWorkspace> standbyWorkspaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStandbyWorkspacesRequest model) {
            super(model);
            primaryRegion(model.primaryRegion);
            standbyWorkspaces(model.standbyWorkspaces);
        }

        public final String getPrimaryRegion() {
            return primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final List<StandbyWorkspace.Builder> getStandbyWorkspaces() {
            List<StandbyWorkspace.Builder> result = StandbyWorkspacesListCopier.copyToBuilder(this.standbyWorkspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStandbyWorkspaces(Collection<StandbyWorkspace.BuilderImpl> standbyWorkspaces) {
            this.standbyWorkspaces = StandbyWorkspacesListCopier.copyFromBuilder(standbyWorkspaces);
        }

        @Override
        public final Builder standbyWorkspaces(Collection<StandbyWorkspace> standbyWorkspaces) {
            this.standbyWorkspaces = StandbyWorkspacesListCopier.copy(standbyWorkspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standbyWorkspaces(StandbyWorkspace... standbyWorkspaces) {
            standbyWorkspaces(Arrays.asList(standbyWorkspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standbyWorkspaces(Consumer<StandbyWorkspace.Builder>... standbyWorkspaces) {
            standbyWorkspaces(Stream.of(standbyWorkspaces).map(c -> StandbyWorkspace.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStandbyWorkspacesRequest build() {
            return new CreateStandbyWorkspacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
