/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the standby WorkSpace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingCreateStandbyWorkspacesRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingCreateStandbyWorkspacesRequest.Builder, PendingCreateStandbyWorkspacesRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(PendingCreateStandbyWorkspacesRequest::userName))
            .setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(PendingCreateStandbyWorkspacesRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(PendingCreateStandbyWorkspacesRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceId").getter(getter(PendingCreateStandbyWorkspacesRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            DIRECTORY_ID_FIELD, STATE_FIELD, WORKSPACE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String directoryId;

    private final String state;

    private final String workspaceId;

    private PendingCreateStandbyWorkspacesRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.directoryId = builder.directoryId;
        this.state = builder.state;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * Describes the standby WorkSpace that was created.
     * </p>
     * <p>
     * Because this operation is asynchronous, the identifier returned is not immediately available for use with other
     * operations. For example, if you call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkspaces</a>
     * before the WorkSpace is created, the information returned can be incomplete.
     * </p>
     * 
     * @return Describes the standby WorkSpace that was created.</p>
     *         <p>
     *         Because this operation is asynchronous, the identifier returned is not immediately available for use with
     *         other operations. For example, if you call <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html">
     *         DescribeWorkspaces</a> before the WorkSpace is created, the information returned can be incomplete.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The identifier of the directory for the standby WorkSpace.
     * </p>
     * 
     * @return The identifier of the directory for the standby WorkSpace.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The operational state of the standby WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The operational state of the standby WorkSpace.
     * @see WorkspaceState
     */
    public final WorkspaceState state() {
        return WorkspaceState.fromValue(state);
    }

    /**
     * <p>
     * The operational state of the standby WorkSpace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The operational state of the standby WorkSpace.
     * @see WorkspaceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The identifier of the standby WorkSpace.
     * </p>
     * 
     * @return The identifier of the standby WorkSpace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingCreateStandbyWorkspacesRequest)) {
            return false;
        }
        PendingCreateStandbyWorkspacesRequest other = (PendingCreateStandbyWorkspacesRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingCreateStandbyWorkspacesRequest").add("UserName", userName())
                .add("DirectoryId", directoryId()).add("State", stateAsString()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingCreateStandbyWorkspacesRequest, T> g) {
        return obj -> g.apply((PendingCreateStandbyWorkspacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingCreateStandbyWorkspacesRequest> {
        /**
         * <p>
         * Describes the standby WorkSpace that was created.
         * </p>
         * <p>
         * Because this operation is asynchronous, the identifier returned is not immediately available for use with
         * other operations. For example, if you call <a
         * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkspaces</a>
         * before the WorkSpace is created, the information returned can be incomplete.
         * </p>
         * 
         * @param userName
         *        Describes the standby WorkSpace that was created.</p>
         *        <p>
         *        Because this operation is asynchronous, the identifier returned is not immediately available for use
         *        with other operations. For example, if you call <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html">
         *        DescribeWorkspaces</a> before the WorkSpace is created, the information returned can be incomplete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The identifier of the directory for the standby WorkSpace.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory for the standby WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The operational state of the standby WorkSpace.
         * </p>
         * 
         * @param state
         *        The operational state of the standby WorkSpace.
         * @see WorkspaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceState
         */
        Builder state(String state);

        /**
         * <p>
         * The operational state of the standby WorkSpace.
         * </p>
         * 
         * @param state
         *        The operational state of the standby WorkSpace.
         * @see WorkspaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceState
         */
        Builder state(WorkspaceState state);

        /**
         * <p>
         * The identifier of the standby WorkSpace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the standby WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String directoryId;

        private String state;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingCreateStandbyWorkspacesRequest model) {
            userName(model.userName);
            directoryId(model.directoryId);
            state(model.state);
            workspaceId(model.workspaceId);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public PendingCreateStandbyWorkspacesRequest build() {
            return new PendingCreateStandbyWorkspacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
